/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.algcomparison.algorithm.multi.ImagesSemBic;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fask;
import edu.cmu.tetrad.util.Parameters;
import java.util.ArrayList;
import java.util.List;

public class FaskVote {
    private final IndependenceWrapper test;
    private final ScoreWrapper score;
    private Knowledge knowledge = new Knowledge();
    private final List<DataSet> dataSets;

    public FaskVote(List<DataSet> dataSets, ScoreWrapper score, IndependenceWrapper test) {
        this.dataSets = dataSets;
        this.score = score;
        this.test = test;
    }

    public Graph search(Parameters parameters) {
        ArrayList<DataModel> _dataSets = new ArrayList<DataModel>();
        for (DataSet dataSet : this.dataSets) {
            _dataSets.add(DataUtils.standardizeData(dataSet));
        }
        ImagesSemBic imagesSemBic = new ImagesSemBic();
        imagesSemBic.setKnowledge(this.knowledge);
        Graph G0 = imagesSemBic.search(_dataSets, parameters);
        List<Node> V = this.dataSets.get(0).getVariables();
        EdgeListGraph G = new EdgeListGraph(V);
        ArrayList<Graph> fasks = new ArrayList<Graph>();
        List<Node> nodes = G0.getNodes();
        for (DataSet dataSet : this.dataSets) {
            Fask fask = new Fask(dataSet, this.score.getScore(dataSet, parameters), this.test.getTest(dataSet, parameters));
            fask.setExternalGraph(GraphUtils.undirectedGraph(G0));
            fask.setAdjacencyMethod(Fask.AdjacencyMethod.EXTERNAL_GRAPH);
            fask.setEmpirical(!parameters.getBoolean("faskNonempirical"));
            fask.setLeftRight(Fask.LeftRight.FASK2);
            fask.setSkewEdgeThreshold(parameters.getDouble("skewEdgeThreshold"));
            fask.setDepth(parameters.getInt("depth"));
            fask.setDelta(parameters.getDouble("faskDelta"));
            fask.setTwoCycleScreeningCutoff(parameters.getDouble("twoCycleScreeningThreshold"));
            fask.setOrientationAlpha(parameters.getDouble("orientationAlpha"));
            fask.setKnowledge(this.knowledge);
            Graph g = fask.search();
            g = GraphUtils.replaceNodes(g, nodes);
            fasks.add(g);
        }
        for (Edge edge : G0.getEdges()) {
            Node X = edge.getNode1();
            Node Y = edge.getNode2();
            Edge dir1 = Edges.directedEdge(X, Y);
            Edge dir2 = Edges.directedEdge(Y, X);
            int sum1 = 0;
            int sum2 = 0;
            int count = 0;
            for (Graph g : fasks) {
                if (g.containsEdge(dir1)) {
                    ++sum1;
                }
                if (g.containsEdge(dir2)) {
                    ++sum2;
                }
                if (!g.containsEdge(dir1) && !g.containsEdge(dir2)) continue;
                ++count;
            }
            double mean1 = (double)sum1 / (double)count;
            double mean2 = (double)sum2 / (double)count;
            System.out.println(X + " " + Y + " " + mean1 + " " + mean2);
            if (mean1 == 0.5 && mean2 == 0.5) {
                G.addUndirectedEdge(X, Y);
                continue;
            }
            if (mean1 > 0.5) {
                G.addDirectedEdge(X, Y);
            }
            if (!(mean2 > 0.5)) continue;
            G.addDirectedEdge(Y, X);
        }
        return G;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

