/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetsSet;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class Fci
implements GraphSearch {
    private SepsetMap sepsets;
    private Knowledge knowledge = new Knowledge();
    private final List<Node> variables = new ArrayList<Node>();
    private final IndependenceTest independenceTest;
    private boolean completeRuleSetUsed = true;
    private boolean possibleDsepSearchDone = true;
    private int maxPathLength = -1;
    private int depth = -1;
    private long elapsedTime;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private int heuristic;
    private boolean stable;
    private boolean doDiscriminatingPathRule = true;

    public Fci(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public Fci(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            if (Thread.currentThread().isInterrupted()) break;
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        Fas fas = new Fas(this.getIndependenceTest());
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        fas.setHeuristic(this.heuristic);
        fas.setVerbose(this.verbose);
        fas.setStable(this.stable);
        fas.setHeuristic(this.heuristic);
        Graph graph = fas.search();
        this.sepsets = fas.getSepsets();
        graph.reorientAllWith(Endpoint.CIRCLE);
        SepsetsSet sepsets1 = new SepsetsSet(this.sepsets, this.independenceTest);
        if (this.isPossibleDsepSearchDone()) {
            new FciOrient(sepsets1).ruleR0(graph);
            graph.paths().removeByPossibleDsep(this.independenceTest, this.sepsets);
            graph.reorientAllWith(Endpoint.CIRCLE);
        }
        FciOrient fciOrient = new FciOrient(sepsets1);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.ruleR0(graph);
        fciOrient.doFinalOrientation(graph);
        long stop = MillisecondTimes.timeMillis();
        this.elapsedTime = stop - start;
        return graph;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public int getMaxPathLength() {
        return this.maxPathLength == Integer.MAX_VALUE ? -1 : this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setHeuristic(int heuristic) {
        this.heuristic = heuristic;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }
}

