/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetsPossibleDsep;
import edu.cmu.tetrad.search.SepsetsSet;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RecursiveTask;

public final class FciMax
implements GraphSearch {
    private SepsetMap sepsets;
    private Knowledge knowledge = new Knowledge();
    private final List<Node> variables = new ArrayList<Node>();
    private final IndependenceTest independenceTest;
    private boolean completeRuleSetUsed = true;
    private boolean possibleDsepSearchDone = true;
    private int maxPathLength = -1;
    private int depth = -1;
    private long elapsedTime;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private int heuristic;
    private boolean stable;
    private boolean doDiscriminatingPathRule = false;

    public FciMax(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public FciMax(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            if (Thread.currentThread().isInterrupted()) break;
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        Fas fas = new Fas(this.getIndependenceTest());
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        fas.setHeuristic(this.heuristic);
        fas.setVerbose(this.verbose);
        fas.setStable(this.stable);
        fas.setHeuristic(this.heuristic);
        Graph graph = fas.search();
        this.sepsets = fas.getSepsets();
        graph.reorientAllWith(Endpoint.CIRCLE);
        SepsetsPossibleDsep sp = new SepsetsPossibleDsep(graph, this.independenceTest, this.knowledge, this.depth, this.maxPathLength);
        sp.setVerbose(this.verbose);
        if (this.isPossibleDsepSearchDone()) {
            new FciOrient(new SepsetsSet(this.sepsets, this.independenceTest)).ruleR0(graph);
            graph.paths().removeByPossibleDsep(this.independenceTest, this.sepsets);
            graph.reorientAllWith(Endpoint.CIRCLE);
        }
        FciOrient fciOrient = new FciOrient(new SepsetsSet(this.sepsets, this.independenceTest));
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.fciOrientbk(this.knowledge, graph, graph.getNodes());
        this.addColliders(graph);
        fciOrient.doFinalOrientation(graph);
        long stop = MillisecondTimes.timeMillis();
        this.elapsedTime = stop - start;
        return graph;
    }

    private void addColliders(Graph graph) {
        ConcurrentHashMap scores = new ConcurrentHashMap();
        List<Node> nodes = graph.getNodes();
        class Task
        extends RecursiveTask<Boolean> {
            final int from;
            final int to;
            final int chunk = 20;
            final List<Node> nodes;
            final Graph graph;
            final /* synthetic */ Map val$scores;
            final /* synthetic */ FciMax this$0;

            public Task(List<Node> nodes, Graph graph, int from, int to) {
                this.this$0 = this$0;
                this.val$scores = var6_6;
                this.nodes = nodes;
                this.graph = graph;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        this.this$0.doNode(this.graph, this.val$scores, this.nodes.get(i));
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    Task left = new Task(this.this$0, this.nodes, this.graph, this.from, mid, this.val$scores);
                    Task right = new Task(this.this$0, this.nodes, this.graph, mid, this.to, this.val$scores);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        Task task = new Task(this, nodes, graph, 0, nodes.size(), scores);
        ForkJoinPoolInstance.getInstance().getPool().invoke(task);
        ArrayList tripleList = new ArrayList(scores.keySet());
        tripleList.sort((o1, o2) -> Double.compare((Double)scores.get(o2), (Double)scores.get(o1)));
        for (Triple triple : tripleList) {
            Node a = triple.getX();
            Node b = triple.getY();
            Node c = triple.getZ();
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
        }
    }

    private void doNode(Graph graph, Map<Triple, Double> scores, Node b) {
        int[] combination;
        List<Node> adjacentNodes = graph.getAdjacentNodes(b);
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null) {
            int[] comb3;
            int[] comb2;
            Node c;
            Node a = adjacentNodes.get(combination[0]);
            if (graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1]))) continue;
            List<Node> adja = graph.getAdjacentNodes(a);
            double score = Double.POSITIVE_INFINITY;
            List<Node> S = null;
            SublistGenerator cg2 = new SublistGenerator(adja.size(), -1);
            while ((comb2 = cg2.next()) != null) {
                List<Node> s = GraphUtils.asList(comb2, adja);
                this.independenceTest.checkIndependence(a, c, s);
                double _score = this.independenceTest.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            List<Node> adjc = graph.getAdjacentNodes(c);
            SublistGenerator cg3 = new SublistGenerator(adjc.size(), -1);
            while ((comb3 = cg3.next()) != null) {
                List<Node> s = GraphUtils.asList(comb3, adjc);
                this.independenceTest.checkIndependence(c, a, s);
                double _score = this.independenceTest.getScore();
                if (!(_score < score)) continue;
                score = _score;
                S = s;
            }
            this.getSepsets().set(a, c, S);
            if (S == null || S.contains(b)) continue;
            scores.put(new Triple(a, b, c), score);
        }
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public int getMaxPathLength() {
        return this.maxPathLength == Integer.MAX_VALUE ? -1 : this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public void setHeuristic(int heuristic) {
        this.heuristic = heuristic;
    }

    public void setStable(boolean stable) {
        this.stable = stable;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }
}

