/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import edu.cmu.tetrad.search.MeekRulesRestricted;
import edu.cmu.tetrad.search.Reorienter;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Vector;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.math3.util.FastMath;

public final class FgesOrienter
implements GraphSearch,
GraphScorer,
Reorienter {
    private ICovarianceMatrix covariances;
    private int sampleSize;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables;
    private boolean discrete;
    private Graph trueGraph;
    private Graph externalGraph;
    private long elapsedTime;
    private double penaltyDiscount = 1.0;
    private int depth = -1;
    private LocalDiscreteScore discreteScore;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final SortedSet<ScoredGraph> topGraphs = new TreeSet<ScoredGraph>();
    private int numCPDAGsToStore;
    private boolean log = true;
    private boolean verbose;
    private final SortedSet<Arrow> sortedArrows = new ConcurrentSkipListSet<Arrow>();
    private Map<OrderedPair<Node>, Set<Arrow>> lookupArrows;
    private ConcurrentMap<Node, Integer> hashIndices;
    private final ForkJoinPool pool = ForkJoinPoolInstance.getInstance().getPool();
    private double score;
    private Graph effectEdgesGraph;
    private final int minChunk = 100;
    private PrintStream out = System.out;
    private Graph adjacencies;
    private boolean faithfulnessAssumed = false;
    private final WeakHashMap<Node, Set<Node>> neighbors = new WeakHashMap();
    private Graph graphToOrient;
    int[] lastSquareIndices = new int[0];
    Matrix lastSquareCovs = new Matrix(0, 0);
    int[] lastColumnIndices = new int[0];
    Vector lastColumnCov = new Vector(0);
    int lastK = -1;

    public FgesOrienter(DataSet dataSet) {
        this.out.println("GES constructor");
        if (dataSet.isDiscrete()) {
            VerticalIntDataBox box = new VerticalIntDataBox(dataSet.getNumRows(), dataSet.getNumColumns());
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                    box.set(i, j, dataSet.getInt(i, j));
                }
            }
            BoxDataSet dataSet1 = new BoxDataSet(box, dataSet.getVariables());
            this.setDataSet(dataSet1);
            BDeuScore score = new BDeuScore(dataSet1);
            score.setSamplePrior(10.0);
            score.setStructurePrior(0.001);
            this.setDiscreteScore(score);
            this.setStructurePrior(0.001);
            this.setSamplePrior(10.0);
        } else {
            this.setCovMatrix(new CovarianceMatrix(dataSet));
        }
        this.out.println("GES constructor done");
    }

    @Override
    public void orient(Graph graph) {
        this.graphToOrient = new EdgeListGraph(graph);
        this.graphToOrient = GraphUtils.undirectedGraph(this.graphToOrient);
        Graph _graph = this.search();
        graph.removeEdges(graph.getEdges());
        for (Edge edge : _graph.getEdges()) {
            graph.addEdge(edge);
        }
    }

    public void setFaithfulnessAssumed(boolean faithfulness) {
        this.faithfulnessAssumed = faithfulness;
    }

    public boolean isFaithfulnessAssumed() {
        return this.faithfulnessAssumed;
    }

    @Override
    public Graph search() {
        EdgeListGraph graph;
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        ArrayList<Node> nodes = new ArrayList<Node>(this.variables);
        this.effectEdgesGraph = this.getEffectEdges(nodes);
        if (this.adjacencies != null) {
            this.adjacencies = GraphUtils.replaceNodes(this.adjacencies, nodes);
        }
        if (this.externalGraph == null) {
            graph = new EdgeListGraph(this.getVariables());
        } else {
            graph = new EdgeListGraph(this.externalGraph);
            for (Edge edge : this.externalGraph.getEdges()) {
                if (this.effectEdgesGraph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
                this.effectEdgesGraph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
            }
        }
        this.addRequiredEdges(graph);
        this.topGraphs.clear();
        this.storeGraph(graph);
        long start = MillisecondTimes.timeMillis();
        this.score = 0.0;
        this.fes(graph);
        this.bes(graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - start;
        this.logger.log("graph", "\nReturning this graph: " + graph);
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.flush();
        return graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public void setStructurePrior(double structurePrior) {
        if (this.getDiscreteScore() != null) {
            this.getDiscreteScore().setStructurePrior(structurePrior);
        }
    }

    public void setSamplePrior(double samplePrior) {
        if (this.getDiscreteScore() != null) {
            this.getDiscreteScore().setSamplePrior(samplePrior);
        }
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        if (penaltyDiscount < 0.0) {
            throw new IllegalArgumentException("Penalty penaltyDiscount must be >= 0: " + penaltyDiscount);
        }
        this.penaltyDiscount = penaltyDiscount;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public double getScore(Graph dag) {
        return this.scoreDag(dag);
    }

    public SortedSet<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }

    public int getnumCPDAGsToStore() {
        return this.numCPDAGsToStore;
    }

    public LocalDiscreteScore getDiscreteScore() {
        return this.discreteScore;
    }

    public void setDiscreteScore(LocalDiscreteScore discreteScore) {
        this.discreteScore = discreteScore;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public Graph getExternalGraph() {
        return this.externalGraph;
    }

    public void setExternalGraph(Graph externalGraph) {
        externalGraph = GraphUtils.replaceNodes(externalGraph, this.variables);
        this.out.println("Initial graph variables: " + externalGraph.getNodes());
        this.out.println("Data set variables: " + this.variables);
        if (!new HashSet<Node>(externalGraph.getNodes()).equals(new HashSet<Node>(this.variables))) {
            throw new IllegalArgumentException("Variables aren't the same.");
        }
        this.externalGraph = externalGraph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public Graph getAdjacencies() {
        return this.adjacencies;
    }

    public void setAdjacencies(Graph adjacencies) {
        this.adjacencies = adjacencies;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    private Graph getEffectEdges(List<Node> nodes) {
        long start = MillisecondTimes.timeMillis();
        EdgeListGraph effectEdgesGraph = new EdgeListGraph(nodes);
        HashSet emptySet = new HashSet(0);
        int[] count = new int[1];
        this.buildIndexing(nodes);
        class EffectTask
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ int[] val$count;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ Set val$emptySet;
            final /* synthetic */ Graph val$effectEdgesGraph;

            public EffectTask(int chunk, int from, int to) {
                this.val$count = nArray;
                this.val$nodes = list;
                this.val$emptySet = set;
                this.val$effectEdgesGraph = graph;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            protected Boolean compute() {
                if (this.to - this.from > this.chunk) {
                    int mid = (this.to + this.from) / 2;
                    ArrayList<EffectTask> tasks = new ArrayList<EffectTask>();
                    tasks.add(new EffectTask(this.chunk, this.from, mid));
                    tasks.add(new EffectTask(this.chunk, mid, this.to));
                    ForkJoinTask.invokeAll(tasks);
                    return true;
                }
                int i = this.from;
                while (i < this.to) {
                    int[] nArray = this.val$count;
                    // MONITORENTER : this.val$count
                    int n = this.val$count[0];
                    this.val$count[0] = n + 1;
                    if ((n + 1) % 1000 == 0) {
                        FgesOrienter.this.out.println("Initializing effect edges: " + this.val$count[0]);
                    }
                    // MONITOREXIT : nArray
                    Node y = (Node)this.val$nodes.get(i);
                    for (int j = 0; j < i; ++j) {
                        double bump;
                        Node x = (Node)this.val$nodes.get(j);
                        if (!FgesOrienter.this.graphToOrient.isAdjacentTo(x, y) || FgesOrienter.this.existsKnowledge() && (FgesOrienter.this.getKnowledge().isForbidden(x.getName(), y.getName()) && FgesOrienter.this.getKnowledge().isForbidden(y.getName(), x.getName()) || FgesOrienter.this.invalidSetByKnowledge(y, this.val$emptySet)) || FgesOrienter.this.adjacencies != null && !FgesOrienter.this.adjacencies.isAdjacentTo(x, y)) continue;
                        if (FgesOrienter.this.covariances != null) {
                            double s1 = FgesOrienter.this.localSemScoreSingleParent((Integer)FgesOrienter.this.hashIndices.get(y), (Integer)FgesOrienter.this.hashIndices.get(x));
                            double s2 = FgesOrienter.this.localSemScoreSingleParent((Integer)FgesOrienter.this.hashIndices.get(y));
                            bump = s1 - s2;
                        } else {
                            bump = FgesOrienter.this.scoreGraphChange(y, Collections.singleton(x), this.val$emptySet, FgesOrienter.this.hashIndices);
                        }
                        if (bump > -FgesOrienter.this.getPenaltyDiscount() * FastMath.log(FgesOrienter.this.sampleSize())) {
                            Edge edge = Edges.undirectedEdge(x, y);
                            this.val$effectEdgesGraph.addEdge(edge);
                        }
                        if (!(bump > 0.0)) continue;
                        Arrow arrow1 = new Arrow(bump, x, y, this.val$emptySet, this.val$emptySet);
                        Arrow arrow2 = new Arrow(bump, y, x, this.val$emptySet, this.val$emptySet);
                        FgesOrienter.this.sortedArrows.add(arrow1);
                        FgesOrienter.this.addLookupArrow(x, y, arrow1);
                        FgesOrienter.this.sortedArrows.add(arrow2);
                        FgesOrienter.this.addLookupArrow(y, x, arrow2);
                    }
                    ++i;
                }
                return true;
            }
        }
        this.pool.invoke(new EffectTask(this.minChunk, 0, nodes.size()));
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            this.out.println("Elapsed getEffectEdges = " + (stop - start) + " ms");
        }
        return effectEdgesGraph;
    }

    private void fes(Graph graph) {
        TetradLogger.getInstance().log("info", "** FORWARD EQUIVALENCE SEARCH");
        while (!this.sortedArrows.isEmpty()) {
            Arrow arrow = this.sortedArrows.first();
            this.sortedArrows.remove(arrow);
            Node x = arrow.getA();
            Node y = arrow.getB();
            this.clearArrow(x, y);
            if (graph.isAdjacentTo(x, y) || !this.validInsert(x, y, arrow.getHOrT(), arrow.getNaYX(), graph)) continue;
            Set<Node> t = arrow.getHOrT();
            double bump = arrow.getBump();
            this.insert(x, y, t, graph, bump);
            this.score += bump;
            Set<Node> visited = this.rebuildCPDAGRestricted(graph, x, y);
            HashSet<Node> toProcess = new HashSet<Node>();
            for (Node node : visited) {
                Set<Node> storedNeighbors;
                Set<Node> neighbors = FgesOrienter.getNeighbors(node, graph);
                if (neighbors.equals(storedNeighbors = this.neighbors.get(node))) continue;
                toProcess.add(node);
                this.neighbors.put(node, neighbors);
            }
            Edge xy = graph.getEdge(x, y);
            if (xy.pointsTowards(x)) {
                toProcess.add(x);
            } else if (xy.pointsTowards(y)) {
                toProcess.add(y);
            }
            this.reevaluateForward(graph, toProcess);
            this.storeGraph(graph);
        }
    }

    private Set<Node> adjNodes(Graph graph, Node x, Node y) {
        HashSet<Node> adj = new HashSet<Node>();
        adj.addAll(graph.getAdjacentNodes(x));
        adj.addAll(graph.getAdjacentNodes(y));
        adj.add(x);
        adj.add(y);
        return adj;
    }

    private void bes(Graph graph) {
        TetradLogger.getInstance().log("info", "** BACKWARD EQUIVALENCE SEARCH");
        this.initializeArrowsBackward(graph);
        while (!this.sortedArrows.isEmpty()) {
            Node y;
            Arrow arrow = this.sortedArrows.first();
            this.sortedArrows.remove(arrow);
            Node x = arrow.getA();
            if (!graph.isAdjacentTo(x, y = arrow.getB()) || !this.validDelete(y, arrow.getHOrT(), arrow.getNaYX(), graph)) continue;
            Set<Node> h = arrow.getHOrT();
            double bump = arrow.getBump();
            this.delete(x, y, h, graph, bump);
            this.score += bump;
            this.rebuildCPDAGRestricted(graph, x, y);
            this.storeGraph(graph);
            this.reevaluateBackward(graph, x, y);
        }
    }

    private boolean existsKnowledge() {
        return !this.knowledge.isEmpty();
    }

    private void initializeArrowsBackward(Graph graph) {
        this.sortedArrows.clear();
        this.lookupArrows.clear();
        for (Edge edge : graph.getEdges()) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            if (this.existsKnowledge() && !this.getKnowledge().noEdgeRequired(x.getName(), y.getName())) continue;
            if (Edges.isDirectedEdge(edge)) {
                this.calculateArrowsBackward(x, y, graph);
                continue;
            }
            this.calculateArrowsBackward(x, y, graph);
            this.calculateArrowsBackward(y, x, graph);
        }
    }

    private void reevaluateForward(Graph graph, Set<Node> nodes) {
        ArrayList<Node> _nodes = new ArrayList<Node>(nodes);
        ArrayList<OrderedPair<Node>> pairs = new ArrayList<OrderedPair<Node>>();
        for (Node x : _nodes) {
            List<Node> adj = this.isFaithfulnessAssumed() ? this.effectEdgesGraph.getAdjacentNodes(x) : this.variables;
            for (Node w : adj) {
                pairs.add(new OrderedPair<Node>(w, x));
            }
        }
        class AdjTask
        extends RecursiveTask<Boolean> {
            private final List<OrderedPair<Node>> pairs;
            private final int from;
            private final int to;
            final /* synthetic */ Graph val$graph;
            final /* synthetic */ FgesOrienter this$0;

            public AdjTask(List<OrderedPair<Node>> pairs, int from, int to) {
                this.this$0 = this$0;
                this.val$graph = var5_5;
                this.pairs = pairs;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= 25) {
                    for (int _w = this.from; _w < this.to; ++_w) {
                        Node x;
                        OrderedPair<Node> p = this.pairs.get(_w);
                        Node w = p.getFirst();
                        if (w == (x = p.getSecond()) || this.this$0.adjacencies != null && !this.this$0.adjacencies.isAdjacentTo(w, x) || this.val$graph.isAdjacentTo(w, x)) continue;
                        this.this$0.calculateArrowsForward(w, x, this.val$graph);
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    ArrayList<AdjTask> tasks = new ArrayList<AdjTask>();
                    tasks.add(new AdjTask(this.this$0, this.pairs, this.from, mid, this.val$graph));
                    tasks.add(new AdjTask(this.this$0, this.pairs, mid, this.to, this.val$graph));
                    ForkJoinTask.invokeAll(tasks);
                }
                return true;
            }
        }
        AdjTask task = new AdjTask(this, pairs, 0, pairs.size(), graph);
        this.pool.invoke(task);
    }

    private void calculateArrowsForward(Node a, Node b, Graph graph) {
        int[] choice;
        if (this.isFaithfulnessAssumed() && !this.effectEdgesGraph.isAdjacentTo(a, b)) {
            return;
        }
        if (this.adjacencies != null && !this.adjacencies.isAdjacentTo(a, b)) {
            return;
        }
        if (!this.graphToOrient.isAdjacentTo(a, b)) {
            return;
        }
        if (this.existsKnowledge() && this.getKnowledge().isForbidden(a.getName(), b.getName())) {
            return;
        }
        Set<Node> naYX = FgesOrienter.getNaYX(a, b, graph);
        List<Node> t = FgesOrienter.getTNeighbors(a, b, graph);
        int _depth = FastMath.min(t.size(), this.depth == -1 ? 1000 : this.depth);
        this.clearArrow(a, b);
        SublistGenerator gen = new SublistGenerator(t.size(), _depth);
        while ((choice = gen.next()) != null) {
            double bump;
            Set<Node> s = GraphUtils.asSet(choice, t);
            HashSet<Node> union = new HashSet<Node>(s);
            union.addAll(naYX);
            if (!GraphUtils.isClique(union, graph) || this.existsKnowledge() && this.invalidSetByKnowledge(b, s) || !((bump = this.insertEval(a, b, s, naYX, graph, this.hashIndices)) > 0.0)) continue;
            Arrow arrow = new Arrow(bump, a, b, s, naYX);
            this.sortedArrows.add(arrow);
            this.addLookupArrow(a, b, arrow);
        }
    }

    private void reevaluateBackward(Graph graph, Node x, Node y) {
        Set<Node> _adj = this.adjNodes(graph, x, y);
        ArrayList<Node> adj = new ArrayList<Node>(_adj);
        class BackwardTask
        extends RecursiveTask<Boolean> {
            private final List<Node> nodes;
            private final Map<Node, Integer> hashIndices;
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ Node val$x;
            final /* synthetic */ Node val$y;
            final /* synthetic */ Graph val$graph;
            final /* synthetic */ FgesOrienter this$0;

            public BackwardTask(List<Node> nodes, int chunk, int from, int to, Map<Node, Integer> hashIndices) {
                this.this$0 = this$0;
                this.val$x = var7_7;
                this.val$y = var8_8;
                this.val$graph = var9_9;
                this.nodes = new ArrayList<Node>(nodes);
                this.hashIndices = new HashMap<Node, Integer>(hashIndices);
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int _w = this.from; _w < this.to; ++_w) {
                        Node w = this.nodes.get(_w);
                        if (w == this.val$x || w == this.val$y) continue;
                        if (!this.val$graph.isAdjacentTo(w, this.val$x)) {
                            this.this$0.calculateArrowsBackward(w, this.val$x, this.val$graph);
                        }
                        if (this.val$graph.isAdjacentTo(w, this.val$y)) continue;
                        this.this$0.calculateArrowsBackward(w, this.val$y, this.val$graph);
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    ArrayList<BackwardTask> tasks = new ArrayList<BackwardTask>();
                    tasks.add(new BackwardTask(this.this$0, this.nodes, this.chunk, this.from, mid, this.hashIndices, this.val$x, this.val$y, this.val$graph));
                    tasks.add(new BackwardTask(this.this$0, this.nodes, this.chunk, mid, this.to, this.hashIndices, this.val$x, this.val$y, this.val$graph));
                    ForkJoinTask.invokeAll(tasks);
                }
                return true;
            }
        }
        this.pool.invoke(new BackwardTask(this, adj, this.minChunk, 0, adj.size(), this.hashIndices, x, y, graph));
    }

    private void calculateArrowsBackward(Node a, Node b, Graph graph) {
        int[] choice;
        if (a == b) {
            return;
        }
        if (!graph.isAdjacentTo(a, b)) {
            return;
        }
        if (this.existsKnowledge() && !this.getKnowledge().noEdgeRequired(a.getName(), b.getName())) {
            return;
        }
        Set<Node> naYX = FgesOrienter.getNaYX(a, b, graph);
        this.clearArrow(a, b);
        ArrayList<Node> _naYX = new ArrayList<Node>(naYX);
        SublistGenerator gen = new SublistGenerator(_naYX.size(), _naYX.size());
        while ((choice = gen.next()) != null) {
            double bump;
            Set<Node> h = GraphUtils.asSet(choice, _naYX);
            HashSet<Node> diff = new HashSet<Node>(naYX);
            diff.removeAll(h);
            if (!GraphUtils.isClique(diff, graph) || this.existsKnowledge() && this.invalidSetByKnowledge(b, h) || !((bump = this.deleteEval(a, b, h, naYX, graph, this.hashIndices)) > 0.0)) continue;
            Arrow arrow = new Arrow(bump, a, b, h, naYX);
            this.sortedArrows.add(arrow);
            this.addLookupArrow(a, b, arrow);
        }
    }

    private static List<Node> getTNeighbors(Node x, Node y, Graph graph) {
        List<Edge> yEdges = graph.getEdges(y);
        ArrayList<Node> tNeighbors = new ArrayList<Node>();
        for (Edge edge : yEdges) {
            Node z;
            if (!Edges.isUndirectedEdge(edge) || graph.isAdjacentTo(z = edge.getDistalNode(y), x)) continue;
            tNeighbors.add(z);
        }
        return tNeighbors;
    }

    private static Set<Node> getNeighbors(Node y, Graph graph) {
        List<Edge> yEdges = graph.getEdges(y);
        HashSet<Node> neighbors = new HashSet<Node>();
        for (Edge edge : yEdges) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            Node z = edge.getDistalNode(y);
            neighbors.add(z);
        }
        return neighbors;
    }

    private double insertEval(Node x, Node y, Set<Node> t, Set<Node> naYX, Graph graph, Map<Node, Integer> hashIndices) {
        HashSet<Node> set1 = new HashSet<Node>(naYX);
        set1.addAll(t);
        set1.addAll(graph.getParents(y));
        set1.remove(x);
        HashSet<Node> set2 = new HashSet<Node>(set1);
        set1.add(x);
        return this.scoreGraphChange(y, set1, set2, hashIndices);
    }

    private double deleteEval(Node x, Node y, Set<Node> h, Set<Node> naYX, Graph graph, Map<Node, Integer> hashIndices) {
        HashSet<Node> set1 = new HashSet<Node>(naYX);
        set1.removeAll(h);
        set1.addAll(graph.getParents(y));
        set1.remove(x);
        HashSet<Node> set2 = new HashSet<Node>(set1);
        set2.add(x);
        return this.scoreGraphChange(y, set1, set2, hashIndices);
    }

    private void insert(Node x, Node y, Set<Node> t, Graph graph, double bump) {
        int numEdges;
        if (graph.isAdjacentTo(x, y)) {
            return;
        }
        Edge trueEdge = null;
        if (this.trueGraph != null) {
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            trueEdge = this.trueGraph.getEdge(_x, _y);
        }
        graph.addDirectedEdge(x, y);
        if (this.log) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            TetradLogger.getInstance().log("insertedEdges", graph.getNumEdges() + ". INSERT " + graph.getEdge(x, y) + " " + t + " " + bump + " " + label);
        }
        if ((numEdges = graph.getNumEdges()) % 1000 == 0) {
            this.out.println("Num edges added: " + numEdges);
        }
        if (this.verbose) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            this.out.println(graph.getNumEdges() + ". INSERT " + graph.getEdge(x, y) + " " + t + " " + bump + " " + label);
        }
        for (Node _t : t) {
            Edge oldEdge = graph.getEdge(_t, y);
            if (oldEdge == null) {
                throw new IllegalArgumentException("Not adjacent: " + _t + ", " + y);
            }
            graph.removeEdge(_t, y);
            graph.addDirectedEdge(_t, y);
            if (!this.log || !this.verbose) continue;
            TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + graph.getEdge(_t, y));
            this.out.println("--- Directing " + oldEdge + " to " + graph.getEdge(_t, y));
        }
    }

    private void delete(Node x, Node y, Set<Node> subset, Graph graph, double bump) {
        int numEdges;
        Edge trueEdge = null;
        if (this.trueGraph != null) {
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            trueEdge = this.trueGraph.getEdge(_x, _y);
        }
        graph.removeEdge(x, y);
        if (this.verbose && (numEdges = graph.getNumEdges()) % 1000 == 0) {
            this.out.println("Num edges (backwards) = " + numEdges);
        }
        if (this.log) {
            Edge oldEdge = graph.getEdge(x, y);
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            TetradLogger.getInstance().log("deletedEdges", graph.getNumEdges() - 1 + ". DELETE " + oldEdge + " " + subset + " (" + bump + ") " + label);
            this.out.println(graph.getNumEdges() + ". DELETE " + oldEdge + " " + subset + " (" + bump + ") " + label);
        }
        for (Node h : subset) {
            Edge edge;
            Edge oldEdge = graph.getEdge(y, h);
            graph.removeEdge(y, h);
            graph.addDirectedEdge(y, h);
            if (this.log) {
                TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + graph.getEdge(y, h));
            }
            if (this.verbose) {
                this.out.println("--- Directing " + oldEdge + " to " + graph.getEdge(y, h));
            }
            if ((edge = graph.getEdge(x, h)) == null || !Edges.isUndirectedEdge(edge)) continue;
            if (!graph.isAdjacentTo(x, h)) {
                throw new IllegalArgumentException("Not adjacent: " + x + ", " + h);
            }
            oldEdge = edge;
            graph.removeEdge(x, h);
            graph.addDirectedEdge(x, h);
            if (this.log) {
                TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldEdge + " to " + edge);
            }
            if (!this.verbose) continue;
            this.out.println("--- Directing " + oldEdge + " to " + edge);
        }
    }

    private boolean validInsert(Node x, Node y, Set<Node> s, Set<Node> naYX, Graph graph) {
        HashSet<Node> union = new HashSet<Node>(s);
        union.addAll(naYX);
        int cycleBound = -1;
        return this.allNeighbors(y, union, graph) && !this.existsUnblockedSemiDirectedPath(y, x, union, graph, cycleBound);
    }

    private boolean allNeighbors(Node y, Set<Node> union, Graph graph) {
        for (Node n : union) {
            Edge e = graph.getEdge(y, n);
            if (e == null) {
                return false;
            }
            if (Edges.isUndirectedEdge(e)) continue;
            return false;
        }
        return true;
    }

    private boolean validDelete(Node y, Set<Node> h, Set<Node> naXY, Graph graph) {
        HashSet<Node> set = new HashSet<Node>(naXY);
        set.removeAll(h);
        return GraphUtils.isClique(set, graph) && this.allNeighbors(y, set, graph);
    }

    private void addRequiredEdges(Graph graph) {
        if (!this.existsKnowledge()) {
            return;
        }
        Iterator<KnowledgeEdge> it = this.getKnowledge().requiredEdgesIterator();
        while (it.hasNext()) {
            KnowledgeEdge next = it.next();
            Node nodeA = graph.getNode(next.getFrom());
            Node nodeB = graph.getNode(next.getTo());
            if (graph.paths().isAncestorOf(nodeB, nodeA)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeA, nodeB);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeA, nodeB));
        }
        for (Edge edge : graph.getEdges()) {
            Node nodeB;
            Node nodeA;
            String B;
            String A = edge.getNode1().getName();
            if (this.knowledge.isForbidden(A, B = edge.getNode2().getName())) {
                nodeA = edge.getNode1();
                if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode2()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                    graph.removeEdges(nodeA, nodeB);
                    graph.addDirectedEdge(nodeB, nodeA);
                    TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                }
                if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                continue;
            }
            if (!this.knowledge.isForbidden(B, A)) continue;
            nodeA = edge.getNode2();
            if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode1()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
            }
            if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeB, nodeA);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
        }
    }

    private boolean invalidSetByKnowledge(Node y, Set<Node> subset) {
        for (Node node : subset) {
            if (!this.getKnowledge().isForbidden(node.getName(), y.getName())) continue;
            return true;
        }
        return false;
    }

    private static Set<Node> getNaYX(Node x, Node y, Graph graph) {
        List<Edge> yEdges = graph.getEdges(y);
        HashSet<Node> nayx = new HashSet<Node>();
        for (Edge edge : yEdges) {
            Node z;
            if (!Edges.isUndirectedEdge(edge) || !graph.isAdjacentTo(z = edge.getDistalNode(y), x)) continue;
            nayx.add(z);
        }
        return nayx;
    }

    private boolean existsUnblockedSemiDirectedPath(Node from, Node to, Set<Node> cond, Graph G, int bound) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.offer(from);
        V.add(from);
        Node e = null;
        int distance = 0;
        while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (t == to) {
                return true;
            }
            if (e == t) {
                e = null;
                if (++distance > (bound == -1 ? 1000 : bound)) {
                    return true;
                }
            }
            for (Node u : G.getAdjacentNodes(t)) {
                Edge edge = G.getEdge(t, u);
                Node c = FgesOrienter.traverseSemiDirected(t, edge);
                if (c == null || cond.contains(c)) continue;
                if (c == to) {
                    return true;
                }
                if (V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
                if (e != null) continue;
                e = u;
            }
        }
        return false;
    }

    private static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        return null;
    }

    private Set<Node> rebuildCPDAGRestricted(Graph graph, Node x, Node y) {
        HashSet<Node> visited = new HashSet<Node>();
        visited.addAll(this.reorientNode(graph, x));
        visited.addAll(this.reorientNode(graph, y));
        if (TetradLogger.getInstance().isEventActive("rebuiltCPDAGs")) {
            TetradLogger.getInstance().log("rebuiltCPDAGs", "Rebuilt CPDAG = " + graph);
        }
        return visited;
    }

    private Set<Node> reorientNode(Graph graph, Node a) {
        List<Node> nodes = graph.getAdjacentNodes(a);
        nodes.add(a);
        List<Edge> edges = graph.getEdges(a);
        SearchGraphUtils.basicCpdagRestricted2(graph, a);
        this.addRequiredEdges(graph);
        Set<Node> visited = this.meekOrientRestricted(graph, nodes, this.getKnowledge());
        List<Edge> newEdges = graph.getEdges(a);
        newEdges.removeAll(edges);
        for (Edge edge : newEdges) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            Node _node = edge.getDistalNode(a);
            visited.addAll(this.reorientNode(graph, _node));
        }
        return visited;
    }

    private Set<Node> meekOrientRestricted(Graph graph, List<Node> nodes, Knowledge knowledge) {
        MeekRulesRestricted rules = new MeekRulesRestricted();
        rules.setKnowledge(knowledge);
        rules.orientImplied(graph, new HashSet<Node>(nodes));
        return rules.getVisitedNodes();
    }

    private void setDataSet(DataSet dataSet) {
        this.variables = dataSet.getVariables();
        this.discrete = dataSet.isDiscrete();
        if (!this.isDiscrete()) {
            CovarianceMatrix covariances = new CovarianceMatrix(dataSet);
            this.setCovMatrix(covariances);
        }
        this.sampleSize = dataSet.getNumRows();
    }

    private void setCovMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covariances = covarianceMatrix;
        this.variables = covarianceMatrix.getVariables();
        this.sampleSize = covarianceMatrix.getSampleSize();
        this.out.println("Calculating variances");
    }

    private void buildIndexing(List<Node> nodes) {
        this.hashIndices = new ConcurrentHashMap<Node, Integer>();
        for (Node node : nodes) {
            this.hashIndices.put(node, this.variables.indexOf(node));
        }
    }

    private void clearArrow(Node x, Node y) {
        OrderedPair<Node> pair = new OrderedPair<Node>(x, y);
        Set<Arrow> lookupArrows = this.lookupArrows.get(pair);
        if (lookupArrows != null) {
            this.sortedArrows.removeAll(lookupArrows);
        }
        this.lookupArrows.remove(pair);
    }

    private void addLookupArrow(Node i, Node j, Arrow arrow) {
        OrderedPair<Node> pair = new OrderedPair<Node>(i, j);
        Set<Arrow> arrows = this.lookupArrows.get(pair);
        if (arrows == null) {
            arrows = new ConcurrentSkipListSet<Arrow>();
            this.lookupArrows.put(pair, arrows);
        }
        arrows.add(arrow);
    }

    @Override
    public double scoreDag(Graph dag) {
        this.buildIndexing(dag.getNodes());
        double score = 0.0;
        for (Node y : dag.getNodes()) {
            HashSet<Node> parents = new HashSet<Node>(dag.getParents(y));
            int nextIndex = -1;
            for (int i = 0; i < this.getVariables().size(); ++i) {
                nextIndex = (Integer)this.hashIndices.get(this.variables.get(i));
            }
            int[] parentIndices = new int[parents.size()];
            Iterator pi = parents.iterator();
            int count = 0;
            while (pi.hasNext()) {
                Node nextParent = (Node)pi.next();
                parentIndices[count++] = (Integer)this.hashIndices.get(nextParent);
            }
            if (this.isDiscrete()) {
                score += this.localDiscreteScore(nextIndex, parentIndices);
                continue;
            }
            score += this.localSemScore(nextIndex, parentIndices);
        }
        return score;
    }

    private double scoreGraphChange(Node y, Set<Node> parents1, Set<Node> parents2, Map<Node, Integer> hashIndices) {
        int yIndex = hashIndices.get(y);
        int[] parentIndices1 = new int[parents1.size()];
        int count = -1;
        for (Node parent : parents1) {
            parentIndices1[++count] = hashIndices.get(parent);
        }
        double score1 = this.isDiscrete() ? this.localDiscreteScore(yIndex, parentIndices1) : this.localSemScore(yIndex, parentIndices1);
        int[] parentIndices2 = new int[parents2.size()];
        int count2 = -1;
        for (Node parent : parents2) {
            parentIndices2[++count2] = hashIndices.get(parent);
        }
        double score2 = this.isDiscrete() ? this.localDiscreteScore(yIndex, parentIndices2) : this.localSemScore(yIndex, parentIndices2);
        return score1 - score2;
    }

    private double localDiscreteScore(int i, int[] parents) {
        return this.getDiscreteScore().localScore(i, parents);
    }

    private double localSemScore(int i, int[] parents) {
        Matrix covxxInv;
        ICovarianceMatrix cov = this.getCovMatrix();
        double residualVariance = cov.getValue(i, i);
        int n = this.sampleSize();
        int p = parents.length;
        Matrix covxx = this.getSelection1(cov, parents);
        try {
            covxxInv = covxx.inverse();
        }
        catch (Exception e) {
            this.printMinimalLinearlyDependentSet(parents, cov);
            this.out.println("Using generalized inverse.");
            covxxInv = covxx.ginverse();
        }
        Vector covxy = this.getSelection2(cov, parents, i);
        Vector b = covxxInv.times(covxy);
        residualVariance -= covxy.dotProduct(b);
        if (residualVariance <= 0.0 && this.verbose) {
            this.out.println("Nonpositive residual varianceY: resVar / varianceY = " + residualVariance / cov.getValue(i, i));
            return Double.NaN;
        }
        double c = this.getPenaltyDiscount();
        return this.score(residualVariance, n, p, c);
    }

    private double localSemScoreSingleParent(int i, int parent) {
        double b;
        double residualVariance = this.covariances.getValue(i, i);
        int n = this.sampleSize();
        boolean p = true;
        double covXX = this.covariances.getValue(parent, parent);
        double covxxInv = 1.0 / covXX;
        double covxy = this.getCovMatrix().getValue(i, parent);
        if ((residualVariance -= covxy * (b = covxxInv * covxy)) <= 0.0 && this.verbose) {
            this.out.println("Nonpositive residual varianceY: resVar / varianceY = " + residualVariance / this.getCovMatrix().getValue(i, i));
            return Double.NaN;
        }
        double c = this.getPenaltyDiscount();
        return this.score(residualVariance, n, 1, c);
    }

    private double score(double residualVariance, int n, int p, double c) {
        return (double)(-n) * FastMath.log(residualVariance) - c * (double)this.getK(p) * FastMath.log(n);
    }

    private int getK(int p) {
        return (p + 1) * (p + 2) / 2;
    }

    private double localSemScoreSingleParent(int i) {
        ICovarianceMatrix cov = this.getCovMatrix();
        double residualVariance = cov.getValue(i, i);
        int n = this.sampleSize();
        boolean p = false;
        if (residualVariance <= 0.0 && this.verbose) {
            this.out.println("Nonpositive residual varianceY: resVar / varianceY = " + residualVariance / cov.getValue(i, i));
            return Double.NaN;
        }
        double c = this.getPenaltyDiscount();
        return this.score(residualVariance, n, 0, c);
    }

    private Matrix getSelection1(ICovarianceMatrix cov, int[] rows) {
        Matrix m = new Matrix(rows.length, rows.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = i; j < rows.length; ++j) {
                double value = cov.getValue(rows[i], rows[j]);
                m.set(i, j, value);
                m.set(j, i, value);
            }
        }
        this.lastSquareIndices = rows;
        this.lastSquareCovs = m;
        return m;
    }

    private Vector getSelection2(ICovarianceMatrix cov, int[] rows, int k) {
        Vector m = new Vector(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            double value = cov.getValue(rows[i], k);
            m.set(i, value);
        }
        this.lastColumnCov = m;
        this.lastColumnIndices = rows;
        this.lastK = k;
        return m;
    }

    private void printMinimalLinearlyDependentSet(int[] parents, ICovarianceMatrix cov) {
        int[] choice;
        ArrayList<Node> _parents = new ArrayList<Node>();
        for (int p : parents) {
            _parents.add(this.variables.get(p));
        }
        SublistGenerator gen = new SublistGenerator(_parents.size(), _parents.size());
        while ((choice = gen.next()) != null) {
            int[] sel = new int[choice.length];
            ArrayList<Node> _sel = new ArrayList<Node>();
            for (int m = 0; m < choice.length; ++m) {
                sel[m] = parents[m];
                _sel.add(this.variables.get(sel[m]));
            }
            Matrix m = cov.getSelection(sel, sel);
            try {
                m.inverse();
            }
            catch (Exception e2) {
                this.out.println("### Linear dependence among variables: " + _sel);
            }
        }
    }

    private int sampleSize() {
        return this.sampleSize;
    }

    private List<Node> getVariables() {
        return this.variables;
    }

    private ICovarianceMatrix getCovMatrix() {
        return this.covariances;
    }

    private boolean isDiscrete() {
        return this.discrete;
    }

    private void storeGraph(Graph graph) {
        if (this.numCPDAGsToStore < 1) {
            return;
        }
        if (this.topGraphs.isEmpty() || this.score > this.topGraphs.first().getScore()) {
            EdgeListGraph graphCopy = new EdgeListGraph(graph);
            this.topGraphs.add(new ScoredGraph(graphCopy, this.score));
            if (this.topGraphs.size() > this.getnumCPDAGsToStore()) {
                this.topGraphs.remove(this.topGraphs.first());
            }
        }
    }

    private static class Arrow
    implements Comparable<Arrow> {
        private final double bump;
        private final Node a;
        private final Node b;
        private final Set<Node> hOrT;
        private final Set<Node> naYX;

        public Arrow(double bump, Node a, Node b, Set<Node> hOrT, Set<Node> naYX) {
            this.bump = bump;
            this.a = a;
            this.b = b;
            this.hOrT = hOrT;
            this.naYX = naYX;
        }

        public double getBump() {
            return this.bump;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public Set<Node> getHOrT() {
            return this.hOrT;
        }

        public Set<Node> getNaYX() {
            return this.naYX;
        }

        @Override
        public int compareTo(Arrow arrow) {
            return Double.compare(arrow.getBump(), this.getBump());
        }

        public String toString() {
            return "Arrow<" + this.a + "->" + this.b + " bump = " + this.bump + " t/h = " + this.hOrT + " naYX = " + this.naYX + ">";
        }
    }
}

