/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.search.SepsetsGreedy;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public final class GFci
implements GraphSearch {
    private Graph graph;
    private Knowledge knowledge = new Knowledge();
    private IndependenceTest independenceTest;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private int maxDegree = -1;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    ICovarianceMatrix covarianceMatrix;
    int sampleSize;
    private PrintStream out = System.out;
    private boolean faithfulnessAssumed = true;
    private final Score score;
    private boolean doDiscriminatingPathRule = true;
    private boolean possibleDsepSearchDone = true;
    private int depth = -1;

    public GFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.sampleSize = score.getSampleSize();
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        this.independenceTest.setVerbose(this.verbose);
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.graph = new EdgeListGraph(nodes);
        Fges fges = new Fges(this.score);
        fges.setKnowledge(this.getKnowledge());
        fges.setVerbose(this.verbose);
        fges.setFaithfulnessAssumed(this.faithfulnessAssumed);
        fges.setMaxDegree(this.maxDegree);
        fges.setOut(this.out);
        this.graph = fges.search();
        EdgeListGraph fgesGraph = new EdgeListGraph(this.graph);
        SepsetsGreedy sepsets = new SepsetsGreedy(this.graph, this.independenceTest, null, this.depth);
        GraphUtils.gfciExtraEdgeRemovalStep(this.graph, fgesGraph, nodes, sepsets);
        this.modifiedR0(fgesGraph, sepsets);
        if (this.possibleDsepSearchDone) {
            this.graph.paths().removeByPossibleDsep(this.independenceTest, null);
        }
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.doFinalOrientation(this.graph);
        GraphUtils.replaceNodes(this.graph, this.independenceTest.getVariables());
        return this.graph;
    }

    public void setMaxDegree(int maxDegree) {
        if (maxDegree < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + maxDegree);
        }
        this.maxDegree = maxDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public void modifiedR0(Graph fgesGraph, SepsetProducer sepsets) {
        this.graph = new EdgeListGraph(this.graph);
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, this.graph, this.graph.getNodes());
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (fgesGraph.isDefCollider(a, b, c = adjacentNodes.get(combination[1]))) {
                    this.graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.graph.setEndpoint(c, b, Endpoint.ARROW);
                    continue;
                }
                if (!fgesGraph.isAdjacentTo(a, c) || this.graph.isAdjacentTo(a, c) || (sepset = sepsets.getSepset(a, c)) == null || sepset.contains(b)) continue;
                this.graph.setEndpoint(a, b, Endpoint.ARROW);
                this.graph.setEndpoint(c, b, Endpoint.ARROW);
            }
        }
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covarianceMatrix;
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setIndependenceTest(IndependenceTest independenceTest) {
        this.independenceTest = independenceTest;
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.faithfulnessAssumed = faithfulnessAssumed;
    }

    private void fciOrientbk(Knowledge knowledge, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

