/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.Score;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphScore
implements Score {
    private Graph dag;
    private IndependenceFacts facts;
    private final List<Node> variables;
    private boolean verbose = false;
    private Node n = null;
    private List<Node> prefix = null;

    public GraphScore(Graph dag) {
        this.dag = dag;
        this.variables = new ArrayList<Node>(dag.getNodes());
        this.variables.removeIf(node -> node.getNodeType() == NodeType.LATENT);
    }

    public GraphScore(IndependenceFacts facts) {
        this.facts = facts;
        this.variables = new ArrayList<Node>(facts.getVariables());
        this.variables.removeIf(node -> node.getNodeType() == NodeType.LATENT);
    }

    @Override
    public double localScore(int y, int[] z) {
        return this.getPearlParentsTest().size();
    }

    private Set<Node> getPearlParentsTest() {
        HashSet<Node> mb = new HashSet<Node>();
        for (Node z0 : this.prefix) {
            ArrayList<Node> cond = new ArrayList<Node>(this.prefix);
            cond.remove(z0);
            if (!this.dag.paths().isDConnectedTo(this.n, z0, cond)) continue;
            mb.add(z0);
        }
        return mb;
    }

    private List<Node> getVariableList(int[] indices) {
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i : indices) {
            variables.add(this.variables.get(i));
        }
        return variables;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.locallyConsistentScoringCriterion(x, y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    private double locallyConsistentScoringCriterion(int x, int y, int[] z) {
        boolean dSeparatedFrom;
        Node _y = this.variables.get(y);
        Node _x = this.variables.get(x);
        List<Node> _z = this.getVariableList(z);
        if (this.dag != null) {
            dSeparatedFrom = this.dag.paths().isDSeparatedFrom(_x, _y, _z);
        } else if (this.facts != null) {
            dSeparatedFrom = this.facts.isIndependent(_x, _y, _z);
        } else {
            throw new IllegalStateException("Expecting either a graph or a IndependenceFacts object.");
        }
        return dSeparatedFrom ? -1.0 : 1.0;
    }

    @Override
    public double localScore(int i, int parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double localScore(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (Node node : this.variables) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        throw new IllegalArgumentException("No variable by that name: " + name);
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    public DataModel getData() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    public boolean getAlternativePenalty() {
        return false;
    }

    public Graph getDag() {
        return new EdgeListGraph(this.dag);
    }

    public boolean isDSeparatedFrom(Node x, Node y, List<Node> z) {
        if (this.dag != null) {
            return this.dag.paths().isDSeparatedFrom(x, y, z);
        }
        if (this.facts != null) {
            return this.facts.isIndependent(x, y, z);
        }
        throw new IllegalArgumentException("Expecting either a DAG or an IndependenceFacts object.");
    }

    public boolean isDConnectedTo(Node x, Node y, List<Node> z) {
        return !this.isDSeparatedFrom(x, y, z);
    }

    public void setPrefix(List<Node> prefix) {
        this.prefix = prefix;
    }

    public void setN(Node n) {
        this.n = n;
    }
}

