/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphoidAxioms {
    private final Set<GraphoidIndFact> facts;
    private final List<Node> nodes;
    private boolean trivialtyAssumed = false;
    private Map<GraphoidIndFact, String> textSpecs = null;

    public GraphoidAxioms(Set<GraphoidIndFact> facts, List<Node> nodes) {
        this.facts = new LinkedHashSet<GraphoidIndFact>(facts);
        this.nodes = new ArrayList<Node>(nodes);
    }

    public GraphoidAxioms(Set<GraphoidIndFact> facts, List<Node> nodes, Map<GraphoidIndFact, String> textSpecs) {
        this.facts = new LinkedHashSet<GraphoidIndFact>(facts);
        this.nodes = new ArrayList<Node>(nodes);
        this.textSpecs = new HashMap<GraphoidIndFact, String>(textSpecs);
    }

    public static void main(String ... args) {
        try {
            String line;
            File file = new File(args[0]);
            int numVars = Integer.parseInt(args[1]);
            System.out.println(file.getAbsolutePath());
            FileReader in1 = new FileReader(file);
            BufferedReader in = new BufferedReader(in1);
            int index = 0;
            while ((line = in.readLine()) != null) {
                System.out.println("\nLine " + ++index + " " + line);
                line = line.trim();
                ArrayList<Node> variables = new ArrayList<Node>();
                for (int i = 0; i < numVars; ++i) {
                    variables.add(new ContinuousVariable("" + i));
                }
                GraphoidAxioms axioms = GraphoidAxioms.getGraphoidAxioms(line, variables);
                axioms.setTrivialtyAssumed();
                axioms.setSymmetryAssumed();
                System.out.println(axioms.getIndependenceFacts().getVariableNames());
                axioms.compositionalGraphoid();
            }
        }
        catch (IOException e) {
            System.out.println("E.g., java -cp tetrad-gui-7.1.3-SNAPSHOT-launch.jar edu.cmu.tetrad.search.GraphoidAxioms  udags5.txt 5\n");
            throw new RuntimeException(e);
        }
    }

    private static GraphoidAxioms getGraphoidAxioms(String line, List<Node> nodes) throws IOException {
        LinkedHashSet<GraphoidIndFact> facts = new LinkedHashSet<GraphoidIndFact>();
        HashMap<GraphoidIndFact, String> textSpecs = new HashMap<GraphoidIndFact, String>();
        if (!line.isEmpty()) {
            String[] split;
            for (String ic : split = line.split(",")) {
                int i;
                HashSet<Node> x = new HashSet<Node>();
                HashSet<Node> y = new HashSet<Node>();
                HashSet<Node> z = new HashSet<Node>();
                String[] tokens1 = ic.split("\\|");
                String[] tokens2 = tokens1[0].split(":");
                for (i = 0; i < tokens2[0].length(); ++i) {
                    int i1 = Integer.parseInt(tokens2[0].substring(i, i + 1).trim());
                    x.add(nodes.get(i1));
                }
                for (i = 0; i < tokens2[1].length(); ++i) {
                    String substring = tokens2[1].substring(i, i + 1);
                    int i1 = Integer.parseInt(substring.trim());
                    y.add(nodes.get(i1));
                }
                if (tokens1.length == 2) {
                    for (i = 0; i < tokens1[1].length(); ++i) {
                        int i1 = Integer.parseInt(tokens1[1].substring(i, i + 1).trim());
                        z.add(nodes.get(i1));
                    }
                }
                GraphoidIndFact fact = new GraphoidIndFact(x, y, z);
                facts.add(fact);
                textSpecs.put(fact, ic);
            }
        }
        return new GraphoidAxioms(facts, nodes, textSpecs);
    }

    public boolean semigraphoid() {
        return this.symmetry() && this.decomposition() && this.weakUnion() && this.contraction();
    }

    public boolean graphoid() {
        return this.semigraphoid() && this.intersection();
    }

    public boolean compositionalGraphoid() {
        return this.graphoid() && this.composition();
    }

    public IndependenceFacts getIndependenceFacts() {
        IndependenceFacts ifFacts = new IndependenceFacts();
        for (GraphoidIndFact ic : this.facts) {
            for (Node x : ic.getX()) {
                for (Node y : ic.getY()) {
                    ifFacts.add(new IndependenceFact(x, y, ic.getZ()));
                }
            }
        }
        ifFacts.setNodes(this.nodes);
        return ifFacts;
    }

    public boolean symmetry() {
        block0: for (GraphoidIndFact fact : this.facts) {
            for (GraphoidIndFact fact2 : this.facts) {
                if (fact == fact2 || !fact.getX().equals(fact2.getY()) || !fact.getY().equals(fact2.getX()) || !fact.getZ().equals(fact2.getZ())) continue;
                continue block0;
            }
            TetradLogger.getInstance().forceLogMessage("Symmetry fails for " + fact);
            return false;
        }
        return true;
    }

    public boolean decomposition() {
        boolean found0 = false;
        for (GraphoidIndFact fact : this.facts) {
            int[] choice;
            Set<Node> X = fact.getX();
            Set<Node> YW = fact.getY();
            Set<Node> Z = fact.getZ();
            ArrayList<Node> YWList = new ArrayList<Node>(YW);
            SublistGenerator gen = new SublistGenerator(YWList.size(), YWList.size());
            while ((choice = gen.next()) != null) {
                Object fact1;
                Set<Node> Y = GraphUtils.asSet(choice, YWList);
                HashSet<Node> W = new HashSet<Node>(YW);
                W.removeAll(Y);
                if (this.trivialtyAssumed && X.isEmpty() || Y.isEmpty() || W.isEmpty()) continue;
                boolean found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getY().equals(Y)) continue;
                    found = true;
                }
                if (!found) {
                    fact1 = new GraphoidIndFact(X, Y, Z);
                    if (this.textSpecs != null) {
                        TetradLogger.getInstance().forceLogMessage("Decomposition fails: Have " + this.textSpecs.get(fact) + "; Missing " + fact1);
                    } else {
                        TetradLogger.getInstance().forceLogMessage("Decomposition fails: Have " + fact + "; Missing " + fact1);
                    }
                    found0 = true;
                }
                found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getY().equals(W)) continue;
                    found = true;
                }
                if (found) continue;
                fact1 = new GraphoidIndFact(X, W, Z);
                if (this.textSpecs != null) {
                    TetradLogger.getInstance().forceLogMessage("Decomposition fails: Have " + this.textSpecs.get(fact) + "; Missing " + fact1);
                } else {
                    TetradLogger.getInstance().forceLogMessage("Decomposition fails: Have " + fact + "; Missing " + fact1);
                }
                found0 = true;
            }
        }
        return !found0;
    }

    public boolean weakUnion() {
        boolean found0 = false;
        for (GraphoidIndFact fact : this.facts) {
            int[] choice;
            Set<Node> X = fact.getX();
            Set<Node> YW = fact.getY();
            Set<Node> Z = fact.getZ();
            ArrayList<Node> YWList = new ArrayList<Node>(YW);
            SublistGenerator gen = new SublistGenerator(YW.size(), YW.size());
            while ((choice = gen.next()) != null) {
                Set<Node> Y = GraphUtils.asSet(choice, YWList);
                HashSet<Node> W = new HashSet<Node>(YW);
                W.removeAll(Y);
                HashSet<Node> ZW = new HashSet<Node>(Z);
                ZW.addAll(W);
                if (this.trivialtyAssumed && X.isEmpty() || Y.isEmpty() || W.isEmpty()) continue;
                boolean found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getX().equals(X) || !_fact.getY().equals(Y) || !_fact.getZ().equals(ZW)) continue;
                    found = true;
                }
                if (found) continue;
                GraphoidIndFact newFact = new GraphoidIndFact(X, Y, ZW);
                if (this.textSpecs != null) {
                    TetradLogger.getInstance().forceLogMessage("Weak Union fails: Have " + this.textSpecs.get(fact) + "; Missing " + newFact);
                } else {
                    TetradLogger.getInstance().forceLogMessage("Weak Union fails: Have " + fact + "; Missing " + newFact);
                }
                found0 = true;
            }
        }
        return !found0;
    }

    public boolean contraction() {
        boolean found0 = false;
        for (GraphoidIndFact fact1 : new HashSet<GraphoidIndFact>(this.facts)) {
            Set<Node> X = fact1.getX();
            Set<Node> Y = fact1.getY();
            Set<Node> Z = fact1.getZ();
            HashSet<Node> ZY = new HashSet<Node>(Z);
            ZY.addAll(Y);
            for (GraphoidIndFact fact2 : new HashSet<GraphoidIndFact>(this.facts)) {
                Set<Node> W;
                if (fact1 == fact2 || !fact2.getX().equals(X) || !fact2.getZ().equals(ZY) || X.equals(W = fact2.getY()) || X.equals(ZY) || W.equals(ZY)) continue;
                HashSet<Node> YW = new HashSet<Node>(Y);
                YW.addAll(W);
                boolean found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getX().equals(X) || !_fact.getY().equals(YW) || !_fact.getZ().equals(Z)) continue;
                    found = true;
                }
                if (found) continue;
                GraphoidIndFact newFact = new GraphoidIndFact(X, YW, Z);
                if (this.textSpecs != null) {
                    TetradLogger.getInstance().forceLogMessage("Contraction fails: Have " + this.textSpecs.get(fact1) + " and " + this.textSpecs.get(fact2) + "; Missing " + newFact);
                } else {
                    TetradLogger.getInstance().forceLogMessage("Contraction fails: Have " + fact1 + " and " + fact2 + "; Missing " + newFact);
                }
                found0 = true;
            }
        }
        return !found0;
    }

    public boolean intersection() {
        boolean found0 = false;
        for (GraphoidIndFact fact1 : this.facts) {
            int[] choice;
            Set<Node> X = fact1.getX();
            Set<Node> Y = fact1.getY();
            Set<Node> ZW = fact1.getZ();
            ArrayList<Node> ZWList = new ArrayList<Node>(ZW);
            SublistGenerator gen = new SublistGenerator(ZWList.size(), ZWList.size());
            while ((choice = gen.next()) != null) {
                Set<Node> Z = GraphUtils.asSet(choice, ZWList);
                HashSet<Node> W = new HashSet<Node>(ZW);
                W.removeAll(Z);
                if (this.trivialtyAssumed && X.isEmpty() || W.isEmpty()) continue;
                HashSet<Node> ZY = new HashSet<Node>(Z);
                ZY.addAll(Y);
                boolean found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getX().equals(X) || !_fact.getY().equals(W) || !_fact.getZ().equals(ZY)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                HashSet<Node> YW = new HashSet<Node>(Y);
                YW.addAll(W);
                if (YW.isEmpty()) continue;
                boolean found2 = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getX().equals(X) || !_fact.getY().equals(YW) || !_fact.getZ().equals(Z)) continue;
                    found2 = true;
                }
                if (found2) continue;
                GraphoidIndFact fact2 = new GraphoidIndFact(X, W, ZY);
                GraphoidIndFact newFact = new GraphoidIndFact(X, YW, Z);
                if (this.textSpecs != null) {
                    TetradLogger.getInstance().forceLogMessage("Intersection fails: Have " + this.textSpecs.get(fact1) + " and " + this.textSpecs.get(fact2) + "; Missing " + newFact);
                } else {
                    TetradLogger.getInstance().forceLogMessage("Intersection fails: Have " + fact1 + " and " + fact2 + "; Missing " + newFact);
                }
                found0 = true;
            }
        }
        return !found0;
    }

    public boolean composition() {
        boolean found0 = false;
        for (GraphoidIndFact fact1 : new HashSet<GraphoidIndFact>(this.facts)) {
            Set<Node> X = fact1.getX();
            Set<Node> Y = fact1.getY();
            Set<Node> Z = fact1.getZ();
            for (GraphoidIndFact fact2 : new HashSet<GraphoidIndFact>(this.facts)) {
                if (fact1 == fact2 || !fact2.getX().equals(X) || !fact2.getZ().equals(Z)) continue;
                Set W = fact2.Y;
                HashSet<Node> YW = new HashSet<Node>(Y);
                YW.addAll(W);
                boolean found = false;
                for (GraphoidIndFact _fact : this.facts) {
                    if (!_fact.getX().equals(X) || !_fact.getY().equals(YW) || !_fact.getZ().equals(Z)) continue;
                    found = true;
                }
                if (found) continue;
                GraphoidIndFact newFact = new GraphoidIndFact(X, YW, Z);
                if (this.textSpecs != null) {
                    TetradLogger.getInstance().forceLogMessage("Composition fails: Have " + this.textSpecs.get(fact1) + " and " + this.textSpecs.get(fact2) + "; Missing " + newFact);
                } else {
                    TetradLogger.getInstance().forceLogMessage("Composition fails: Have " + fact1 + " and " + fact2 + "; Missing " + newFact);
                }
                found0 = true;
            }
        }
        return !found0;
    }

    public void setTrivialtyAssumed() {
        this.trivialtyAssumed = true;
    }

    public void setSymmetryAssumed() {
        for (GraphoidIndFact fact : new HashSet<GraphoidIndFact>(this.facts)) {
            Set<Node> X = fact.getX();
            Set<Node> Y = fact.getY();
            Set<Node> Z = fact.getZ();
            GraphoidIndFact newFact = new GraphoidIndFact(Y, X, Z);
            this.facts.add(newFact);
            if (this.textSpecs == null) continue;
            this.textSpecs.put(newFact, this.textSpecs.get(fact));
        }
    }

    public static class GraphoidIndFact {
        private final Set<Node> X;
        private final Set<Node> Y;
        private final Set<Node> Z;

        public GraphoidIndFact(Set<Node> X, Set<Node> Y, Set<Node> Z) {
            if (X.isEmpty() || Y.isEmpty()) {
                throw new IllegalArgumentException("X or Y is empty");
            }
            if (!this.disjoint(X, Y, Z)) {
                throw new IllegalArgumentException();
            }
            this.X = new HashSet<Node>(X);
            this.Y = new HashSet<Node>(Y);
            this.Z = new HashSet<Node>(Z);
        }

        public Set<Node> getX() {
            return new HashSet<Node>(this.X);
        }

        public Set<Node> getY() {
            return new HashSet<Node>(this.Y);
        }

        public Set<Node> getZ() {
            return new HashSet<Node>(this.Z);
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GraphoidIndFact)) {
                return false;
            }
            GraphoidIndFact _fact = (GraphoidIndFact)o;
            return this.X.equals(_fact.X) && this.Y.equals(_fact.Y) && this.Z.equals(_fact.Z);
        }

        public String toString() {
            return this.X + " : " + this.Y + " | " + this.Z;
        }

        private boolean disjoint(Set<Node> set1, Set<Node> set2, Set<Node> set3) {
            return this.intersection(set1, set2).isEmpty() && this.intersection(set1, set3).isEmpty() || !this.intersection(set2, set3).isEmpty();
        }

        private Set<Node> intersection(Set<Node> set1, Set<Node> set2) {
            HashSet<Node> W = new HashSet<Node>(set1);
            W.retainAll(set2);
            return W;
        }
    }
}

