/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Grasp {
    private final List<Node> variables;
    private Score score;
    private IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private TeyssierScorer scorer;
    private long start;
    private boolean useScore = true;
    private boolean useRaskuttiUhler;
    private boolean ordered;
    private boolean verbose;
    private boolean cachingScores = true;
    private int uncoveredDepth = 1;
    private int nonSingularDepth = 1;
    private boolean useDataOrder = true;
    private int depth = 4;
    private int numStarts = 1;

    public Grasp(@NotNull Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
    }

    public Grasp(@NotNull IndependenceTest test) {
        this.test = test;
        this.variables = new ArrayList<Node>(test.getVariables());
        this.useScore = false;
    }

    public Grasp(@NotNull IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
        this.variables = new ArrayList<Node>(test.getVariables());
    }

    public List<Node> bestOrder(@NotNull List<Node> order) {
        long start = MillisecondTimes.timeMillis();
        order = new ArrayList<Node>(order);
        this.scorer = new TeyssierScorer(this.test, this.score);
        this.scorer.setUseRaskuttiUhler(this.useRaskuttiUhler);
        this.scorer.setKnowledge(this.knowledge);
        if (this.useRaskuttiUhler) {
            this.scorer.setUseScore(false);
            this.scorer.setUseRaskuttiUhler(true);
        } else {
            this.scorer.setUseScore(this.useScore && !(this.score instanceof GraphScore));
        }
        this.scorer.clearBookmarks();
        this.scorer.setCachingScores(this.cachingScores);
        List<Node> bestPerm = null;
        double best = Double.NEGATIVE_INFINITY;
        this.scorer.score(order);
        for (int r = 0; r < this.numStarts && !Thread.interrupted(); ++r) {
            if (r == 0 && !this.useDataOrder || r > 0) {
                Collections.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            this.scorer.score(order);
            List<Node> perm = this.grasp(this.scorer);
            this.scorer.score(perm);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = perm;
        }
        this.scorer.score(bestPerm);
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("Final order = " + this.scorer.getPi());
            TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((o1, o2) -> {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(o1.getName(), o2.getName())) {
                    return -1;
                }
                if (this.knowledge.isRequired(o2.getName(), o1.getName())) {
                    return 1;
                }
                if (this.knowledge.isForbidden(o1.getName(), o2.getName())) {
                    return 1;
                }
                if (this.knowledge.isForbidden(o2.getName(), o1.getName())) {
                    return -1;
                }
                return 0;
            });
        }
        System.out.println("Initial knowledge sort order = " + order);
        if (this.violatesKnowledge(order)) {
            throw new IllegalArgumentException("The initial sorting procedure could not find a permutation consistent with that knowledge.");
        }
    }

    public List<Node> grasp(@NotNull TeyssierScorer scorer) {
        scorer.clearBookmarks();
        ArrayList<int[]> depths = new ArrayList<int[]>();
        if (this.ordered && this.uncoveredDepth != 0 && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, 0, 0});
        }
        if (this.ordered && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, 0});
        }
        depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, this.nonSingularDepth < 0 ? Integer.MAX_VALUE : this.nonSingularDepth});
        double sNew = scorer.score();
        for (int[] depth : depths) {
            double sOld;
            do {
                sOld = sNew;
                this.graspDfs(scorer, sOld, depth, 1, new HashSet<Set<Node>>(), new HashSet<Set<Set<Node>>>());
            } while ((sNew = scorer.score()) > sOld);
        }
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("# Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (GRaSP) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
        }
        return scorer.getPi();
    }

    private void graspDfs(@NotNull TeyssierScorer scorer, double sOld, int[] depth, int currentDepth, Set<Set<Node>> tucks, Set<Set<Set<Node>>> dfsHistory) {
        for (Node y : scorer.getShuffledVariables()) {
            Set<Node> ancestors = scorer.getAncestors(y);
            ArrayList<Node> parents = new ArrayList<Node>(scorer.getParents(y));
            Collections.shuffle(parents);
            for (Node x : parents) {
                boolean covered = scorer.coveredEdge(x, y);
                boolean singular = true;
                HashSet<Node> tuck = new HashSet<Node>();
                tuck.add(x);
                tuck.add(y);
                if (covered && tucks.contains(tuck) || currentDepth > depth[1] && !covered) continue;
                int[] idcs = new int[]{scorer.index(x), scorer.index(y)};
                int i = idcs[0];
                scorer.bookmark(currentDepth);
                boolean first = true;
                ArrayList<Node> Z = new ArrayList<Node>(scorer.getOrderShallow().subList(i + 1, idcs[1]));
                Iterator zItr = Z.iterator();
                do {
                    if (first) {
                        scorer.moveTo(y, i);
                        first = false;
                        continue;
                    }
                    Node z = (Node)zItr.next();
                    if (!ancestors.contains(z)) continue;
                    if (scorer.getParents(z).contains(x)) {
                        singular = false;
                    }
                    scorer.moveTo(z, i++);
                } while (zItr.hasNext());
                if (currentDepth > depth[2] && !singular) {
                    scorer.goToBookmark(currentDepth);
                    continue;
                }
                if (this.violatesKnowledge(scorer.getPi())) {
                    scorer.goToBookmark(currentDepth);
                    continue;
                }
                double sNew = scorer.score();
                if (sNew > sOld) {
                    if (this.verbose) {
                        System.out.printf("Edges: %d \t|\t Score Improvement: %f \t|\t Tucks Performed: %s %s \n", scorer.getNumEdges(), sNew - sOld, tucks, tuck);
                    }
                    return;
                }
                if (sNew == sOld && currentDepth < depth[0]) {
                    tucks.add(tuck);
                    if (currentDepth > depth[1]) {
                        if (!dfsHistory.contains(tucks)) {
                            dfsHistory.add(new HashSet<Set<Node>>(tucks));
                            this.graspDfs(scorer, sOld, depth, currentDepth + 1, tucks, dfsHistory);
                        }
                    } else {
                        this.graspDfs(scorer, sOld, depth, currentDepth + 1, tucks, dfsHistory);
                    }
                    tucks.remove(tuck);
                }
                if (scorer.score() > sOld) {
                    return;
                }
                scorer.goToBookmark(currentDepth);
            }
        }
    }

    @NotNull
    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void setCacheScores(boolean cachingScores) {
        this.cachingScores = cachingScores;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.test != null) {
            this.test.setVerbose(verbose);
        }
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    public void setSingularDepth(int uncoveredDepth) {
        if (uncoveredDepth < -1) {
            throw new IllegalArgumentException("Uncovered depth should be >= -1.");
        }
        this.uncoveredDepth = uncoveredDepth;
    }

    public void setNonSingularDepth(int nonSingularDepth) {
        if (nonSingularDepth < -1) {
            throw new IllegalArgumentException("Non-singular depth should be >= -1.");
        }
        this.nonSingularDepth = nonSingularDepth;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) {
                        return true;
                    }
                    if (!this.knowledge.isRequired(order.get(j).getName(), order.get(i).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setUseRaskuttiUhler(boolean usePearl) {
        this.useRaskuttiUhler = usePearl;
        if (this.useRaskuttiUhler) {
            this.useScore = false;
        }
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void orientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
        }
    }

    private void addRequiredEdges(Graph graph) {
        Iterator<KnowledgeEdge> it = this.knowledge.requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            KnowledgeEdge next = it.next();
            Node nodeA = graph.getNode(next.getFrom());
            Node nodeB = graph.getNode(next.getTo());
            if (graph.paths().isAncestorOf(nodeB, nodeA)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeA, nodeB);
            if (!this.verbose) continue;
            TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeA, nodeB));
        }
        for (Edge edge : graph.getEdges()) {
            Node nodeB;
            Node nodeA;
            String B;
            if (Thread.currentThread().isInterrupted()) break;
            String A = edge.getNode1().getName();
            if (this.knowledge.isForbidden(A, B = edge.getNode2().getName())) {
                nodeA = edge.getNode1();
                if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode2()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                    graph.removeEdges(nodeA, nodeB);
                    graph.addDirectedEdge(nodeB, nodeA);
                    if (this.verbose) {
                        TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                    }
                }
                if (graph.isChildOf(nodeA, nodeB) || !this.knowledge.isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                if (!this.verbose) continue;
                TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                continue;
            }
            if (!this.knowledge.isForbidden(B, A)) continue;
            nodeA = edge.getNode2();
            if (graph.isAdjacentTo(nodeA, nodeB = edge.getNode1()) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                if (this.verbose) {
                    TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                }
            }
            if (graph.isChildOf(nodeA, nodeB) || !this.knowledge.isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeB, nodeA);
            if (!this.verbose) continue;
            TetradLogger.getInstance().forceLogMessage("Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
        }
    }
}

