/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.Grasp;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.search.SepsetsGreedy;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class GraspFci
implements GraphSearch {
    private Graph graph;
    private Knowledge knowledge = new Knowledge();
    private IndependenceTest independenceTest;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    ICovarianceMatrix covarianceMatrix;
    int sampleSize;
    private PrintStream out = System.out;
    private final Score score;
    private int numStarts = 1;
    private int depth = -1;
    private boolean useRaskuttiUhler = false;
    private boolean useDataOrder = true;
    private boolean useScore = true;
    private boolean doDiscriminatingPathRule = true;
    private boolean possibleDsepSearchDone = true;
    private boolean ordered = false;
    private boolean cachingScores = true;
    private int graspDepth = 3;
    private int uncoveredDepth = 1;
    private int nonSingularDepth = 1;

    public GraspFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.sampleSize = score.getSampleSize();
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.graph = new EdgeListGraph(nodes);
        TeyssierScorer scorer = new TeyssierScorer(this.independenceTest, this.score);
        Grasp alg = new Grasp(this.independenceTest, this.score);
        alg.setOrdered(this.ordered);
        alg.setUseScore(this.useScore);
        alg.setUseRaskuttiUhler(this.useRaskuttiUhler);
        alg.setUseDataOrder(this.useDataOrder);
        alg.setDepth(this.graspDepth);
        alg.setSingularDepth(this.uncoveredDepth);
        alg.setNonSingularDepth(this.nonSingularDepth);
        alg.setNumStarts(this.numStarts);
        alg.setCacheScores(this.cachingScores);
        alg.setVerbose(this.verbose);
        List<Node> variables = this.score.getVariables();
        assert (variables != null);
        alg.bestOrder(variables);
        this.graph = alg.getGraph(true);
        Knowledge knowledge2 = new Knowledge(this.knowledge);
        EdgeListGraph referenceDag = new EdgeListGraph(this.graph);
        SepsetsGreedy sepsets = new SepsetsGreedy(this.graph, this.independenceTest, null, this.depth);
        GraphUtils.gfciExtraEdgeRemovalStep(this.graph, referenceDag, nodes, sepsets);
        this.modifiedR0(referenceDag, sepsets);
        FciOrient fciOrient = new FciOrient(sepsets);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setVerbose(this.verbose);
        fciOrient.setKnowledge(knowledge2);
        fciOrient.doFinalOrientation(this.graph);
        GraphUtils.replaceNodes(this.graph, this.independenceTest.getVariables());
        return this.graph;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge, Node y) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z;
            if (z == x || z == y || !this.possibleParentOf(_z = z.getName(), _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    public void modifiedR0(Graph fgesGraph, SepsetProducer sepsets) {
        this.graph = new EdgeListGraph(this.graph);
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, this.graph, this.graph.getNodes());
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (fgesGraph.isDefCollider(a, b, c = adjacentNodes.get(combination[1]))) {
                    this.graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.graph.setEndpoint(c, b, Endpoint.ARROW);
                    continue;
                }
                if (!fgesGraph.isAdjacentTo(a, c) || this.graph.isAdjacentTo(a, c) || (sepset = sepsets.getSepset(a, c)) == null || sepset.contains(b)) continue;
                this.graph.setEndpoint(a, b, Endpoint.ARROW);
                this.graph.setEndpoint(c, b, Endpoint.ARROW);
            }
        }
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covarianceMatrix;
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setIndependenceTest(IndependenceTest independenceTest) {
        this.independenceTest = independenceTest;
    }

    private void fciOrientbk(Knowledge knowledge, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public void setGraspDepth(int graspDepth) {
        if (graspDepth < -1) {
            throw new IllegalArgumentException("GRaSP depth should be >= -1.");
        }
        this.graspDepth = graspDepth;
    }

    public void setSingularDepth(int uncoveredDepth) {
        if (uncoveredDepth < -1) {
            throw new IllegalArgumentException("Uncovered depth should be >= -1.");
        }
        this.uncoveredDepth = uncoveredDepth;
    }

    public void setNonSingularDepth(int nonSingularDepth) {
        if (nonSingularDepth < -1) {
            throw new IllegalArgumentException("Non-singular depth should be >= -1.");
        }
        this.nonSingularDepth = nonSingularDepth;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setCacheScores(boolean cachingScores) {
        this.cachingScores = cachingScores;
    }
}

