/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraspTol {
    private final List<Node> variables;
    private Score score;
    private IndependenceTest test;
    private Knowledge knowledge = new Knowledge();
    private TeyssierScorer scorer;
    private long start;
    private boolean useScore = true;
    private boolean usePearl;
    private boolean ordered;
    private boolean verbose;
    private boolean cachingScores = true;
    private int uncoveredDepth = 1;
    private int nonSingularDepth = 1;
    private int toleranceDepth;
    private boolean useDataOrder = true;
    private boolean allowRandomnessInsideAlgorithm;
    private int depth = 4;
    private int numStarts = 1;

    public GraspTol(@NotNull Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
    }

    public GraspTol(@NotNull IndependenceTest test) {
        this.test = test;
        this.variables = new ArrayList<Node>(test.getVariables());
        this.useScore = false;
    }

    public GraspTol(@NotNull IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
        this.variables = new ArrayList<Node>(test.getVariables());
    }

    public GraspTol(List<Node> variables) {
        this.variables = variables;
    }

    public List<Node> bestOrder(@NotNull List<Node> order) {
        long start = MillisecondTimes.timeMillis();
        order = new ArrayList<Node>(order);
        this.scorer = new TeyssierScorer(this.test, this.score);
        this.scorer.setUseRaskuttiUhler(this.usePearl);
        if (this.usePearl) {
            this.scorer.setUseScore(false);
        } else {
            this.scorer.setUseScore(this.useScore && !(this.score instanceof GraphScore));
        }
        this.scorer.setKnowledge(this.knowledge);
        this.scorer.clearBookmarks();
        this.scorer.setCachingScores(this.cachingScores);
        List<Node> bestPerm = null;
        double best = Double.NEGATIVE_INFINITY;
        this.scorer.score(order);
        for (int r = 0; r < this.numStarts && !Thread.interrupted(); ++r) {
            if (r == 0 && !this.useDataOrder || r > 0) {
                RandomUtil.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            this.scorer.score(order);
            List<Node> perm = this.grasp(this.scorer);
            this.scorer.score(perm);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = perm;
        }
        this.scorer.score(bestPerm);
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("Final order = " + this.scorer.getPi());
            TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public void betterMutation(@NotNull TeyssierScorer scorer) {
        double s;
        List<Node> pi = scorer.getPi();
        double sp = scorer.score(pi);
        scorer.bookmark();
        do {
            s = sp;
            for (Node k : scorer.getPi()) {
                int index;
                int j;
                sp = Double.NEGATIVE_INFINITY;
                for (j = index = scorer.index(k); j >= 0; --j) {
                    scorer.moveTo(k, j);
                    if (!(scorer.score() > sp) || this.violatesKnowledge(scorer.getPi())) continue;
                    sp = scorer.score();
                    scorer.bookmark();
                }
                scorer.goToBookmark();
                scorer.bookmark();
                for (j = index; j < scorer.size(); ++j) {
                    scorer.moveTo(k, j);
                    if (!(scorer.score() > sp) || this.violatesKnowledge(scorer.getPi())) continue;
                    sp = scorer.score();
                    scorer.bookmark();
                    if (!this.verbose) continue;
                    System.out.println("# Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (betterMutation) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " sp");
                }
                scorer.goToBookmark();
            }
        } while (sp > s);
    }

    private void tuck(Node k, int j, TeyssierScorer scorer) {
        if (j >= scorer.index(k)) {
            return;
        }
        ArrayList<Node> d2 = new ArrayList<Node>();
        for (int i = j + 1; i < scorer.index(k); ++i) {
            d2.add(scorer.get(i));
        }
        ArrayList gammac = new ArrayList(d2);
        gammac.removeAll(scorer.getAncestors(k));
        Node first = null;
        if (!gammac.isEmpty()) {
            first = (Node)gammac.get(0);
            for (Node n : gammac) {
                if (scorer.index(n) >= scorer.index(first)) continue;
                first = n;
            }
        }
        if (scorer.getParents(k).contains(scorer.get(j))) {
            if (first != null) {
                scorer.moveTo(scorer.get(j), scorer.index(first));
            }
            scorer.moveTo(k, j);
        }
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((o1, o2) -> {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(o1.getName(), o2.getName())) {
                    return 1;
                }
                if (this.knowledge.isRequired(o2.getName(), o1.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o1.getName(), o2.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o2.getName(), o1.getName())) {
                    return 1;
                }
                return 0;
            });
        }
    }

    public List<Node> grasp(@NotNull TeyssierScorer scorer) {
        scorer.clearBookmarks();
        ArrayList<int[]> depths = new ArrayList<int[]>();
        if (this.ordered && this.uncoveredDepth != 0 && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, 0, 0});
        }
        if (this.ordered && this.nonSingularDepth != 0) {
            depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, 0});
        }
        depths.add(new int[]{this.depth < 1 ? Integer.MAX_VALUE : this.depth, this.uncoveredDepth < 0 ? Integer.MAX_VALUE : this.uncoveredDepth, this.nonSingularDepth < 0 ? Integer.MAX_VALUE : this.nonSingularDepth});
        double sNew = scorer.score();
        for (int[] depth : depths) {
            double sOld;
            do {
                sOld = sNew;
                this.graspDfsTol(scorer, sOld, depth, 1, this.toleranceDepth, 0, new HashSet<Set<Node>>(), new HashSet<Set<Set<Node>>>());
            } while ((sNew = scorer.score()) > sOld);
        }
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage("# Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (GRaSP) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " s");
        }
        return scorer.getPi();
    }

    private void graspDfsTol(@NotNull TeyssierScorer scorer, double sOld, int[] depth, int currentDepth, int tol, int tolCur, Set<Set<Node>> tucks, Set<Set<Set<Node>>> dfsHistory) {
        List<Node> variables = this.allowRandomnessInsideAlgorithm ? scorer.getShuffledVariables() : scorer.getPi();
        block0: for (Node y : variables) {
            if (Thread.interrupted()) break;
            Set<Node> ancestors = scorer.getAncestors(y);
            ArrayList<Node> parents = new ArrayList<Node>(scorer.getParents(y));
            if (this.allowRandomnessInsideAlgorithm) {
                RandomUtil.shuffle(parents);
            }
            for (Node x : parents) {
                if (Thread.interrupted()) continue block0;
                boolean covered = scorer.coveredEdge(x, y);
                boolean singular = true;
                HashSet<Node> tuck = new HashSet<Node>();
                tuck.add(x);
                tuck.add(y);
                if (covered && tucks.contains(tuck) || currentDepth > depth[1] && !covered) continue;
                int[] idcs = new int[]{scorer.index(x), scorer.index(y)};
                int i = idcs[0];
                scorer.bookmark(currentDepth);
                boolean first = true;
                ArrayList<Node> Z = new ArrayList<Node>(scorer.getOrderShallow().subList(i + 1, idcs[1]));
                Iterator zItr = Z.iterator();
                do {
                    if (first) {
                        scorer.moveTo(y, i);
                        first = false;
                        continue;
                    }
                    Node z = (Node)zItr.next();
                    if (!ancestors.contains(z)) continue;
                    if (scorer.getParents(z).contains(x)) {
                        singular = false;
                    }
                    scorer.moveTo(z, i++);
                } while (zItr.hasNext());
                if (currentDepth > depth[2] && !singular) {
                    scorer.goToBookmark(currentDepth);
                    continue;
                }
                if (this.violatesKnowledge(scorer.getPi())) continue;
                double sNew = scorer.score();
                if (sNew > sOld) {
                    if (this.verbose) {
                        String s = String.format("Edges: %d \t|\t Score Improvement: %f \t|\t Tucks Performed: %s %s", scorer.getNumEdges(), sNew - sOld, tucks, tuck);
                        TetradLogger.getInstance().forceLogMessage(s);
                    }
                    return;
                }
                if (sNew == sOld && currentDepth < depth[0]) {
                    tucks.add(tuck);
                    if (currentDepth > depth[1] && !dfsHistory.contains(tucks)) {
                        dfsHistory.add(new HashSet<Set<Node>>(tucks));
                        this.graspDfsTol(scorer, sOld, depth, currentDepth + 1, tol, tolCur, tucks, dfsHistory);
                    }
                    tucks.remove(tuck);
                } else if (sNew < sOld && currentDepth < depth[0] && tolCur < tol) {
                    tucks.add(tuck);
                    this.graspDfsTol(scorer, sOld, depth, currentDepth + 1, tol, tolCur + 1, tucks, dfsHistory);
                    tucks.remove(tuck);
                }
                if (scorer.score() > sOld) {
                    return;
                }
                scorer.goToBookmark(currentDepth);
            }
        }
    }

    @NotNull
    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void setCacheScores(boolean cachingScores) {
        this.cachingScores = cachingScores;
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.test.setVerbose(verbose);
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth should be >= -1.");
        }
        this.depth = depth;
    }

    public void setUncoveredDepth(int uncoveredDepth) {
        if (this.depth < -1) {
            throw new IllegalArgumentException("Uncovered depth should be >= -1.");
        }
        this.uncoveredDepth = uncoveredDepth;
    }

    public void setNonSingularDepth(int nonSingularDepth) {
        if (this.depth < -1) {
            throw new IllegalArgumentException("Non-singular depth should be >= -1.");
        }
        this.nonSingularDepth = nonSingularDepth;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (!this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public void setUseRaskuttiUhler(boolean usePearl) {
        this.usePearl = usePearl;
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setAllowRandomnessInsideAlgorithm(boolean allowRandomnessInsideAlgorithm) {
        this.allowRandomnessInsideAlgorithm = allowRandomnessInsideAlgorithm;
    }

    public void setToleranceDepth(int toleranceDepth) {
        this.toleranceDepth = toleranceDepth;
    }
}

