/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MbSearch;
import java.util.LinkedList;
import java.util.List;

public class GrowShrink
implements MbSearch {
    private final IndependenceTest independenceTest;
    private List<Node> variables;

    public GrowShrink(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.variables = test.getVariables();
    }

    @Override
    public List<Node> findMb(Node target) {
        LinkedList<Node> blanket = new LinkedList<Node>();
        boolean changed = true;
        while (changed) {
            changed = false;
            LinkedList<Node> remaining = new LinkedList<Node>(this.variables);
            remaining.removeAll(blanket);
            remaining.remove(target);
            for (Node node : remaining) {
                if (this.independenceTest.checkIndependence(node, target, blanket).independent()) continue;
                blanket.add(node);
                changed = true;
            }
        }
        changed = true;
        while (changed) {
            changed = false;
            for (Node node : new LinkedList<Node>(blanket)) {
                blanket.remove(node);
                if (this.independenceTest.checkIndependence(node, target, blanket).independent()) {
                    changed = true;
                    continue;
                }
                blanket.add(node);
            }
        }
        return blanket;
    }

    @Override
    public String getAlgorithmName() {
        return "Grow Shrink";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetName);
        }
        return target;
    }

    public void setVariables(List<Node> variables) {
        this.variables = variables;
    }
}

