/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

public class GwpResult {
    public AdjacencyEvaluationResult adj;
    public OrientationEvaluationResult ori;
    public CoefficientEvaluationResult coeffAll;
    public CoefficientEvaluationResult coeffSome;
    public CPDAGEvaluationResult pat;
    public String name;

    public GwpResult(String methodName, AdjacencyEvaluationResult adj, OrientationEvaluationResult ori, CoefficientEvaluationResult coeffAll, CoefficientEvaluationResult coeffSome) {
        this.name = methodName;
        this.adj = adj;
        this.ori = ori;
        this.coeffAll = coeffAll;
        this.coeffSome = coeffSome;
    }

    public GwpResult(String methodName, CPDAGEvaluationResult pat) {
        this.name = methodName;
        this.pat = pat;
    }

    public static class AdjacencyEvaluationResult
    implements PartialEvaluationResult {
        public Integer errorsOfOmission;
        public Integer errorsOfCommission;

        public AdjacencyEvaluationResult(Integer errorsOfOmission, Integer errorsOfCommission) {
            this.errorsOfOmission = errorsOfOmission;
            this.errorsOfCommission = errorsOfCommission;
        }

        public double loss() {
            return this.errorsOfOmission + this.errorsOfCommission;
        }

        @Override
        public double[] values() {
            return new double[]{this.errorsOfOmission.intValue(), this.errorsOfCommission.intValue(), this.loss()};
        }
    }

    public static class OrientationEvaluationResult
    implements PartialEvaluationResult {
        public Integer nCorrect;
        public Integer directedWrongWay;
        public Integer undirectedWhenShouldBeDirected;
        public Integer directedWhenShouldBeUndirected;

        public OrientationEvaluationResult(Integer correct, Integer directedWrongWay, Integer undirectedWhenShouldBeDirected, Integer directedWhenShouldBeUndirected) {
            this.nCorrect = correct;
            this.directedWrongWay = directedWrongWay;
            this.undirectedWhenShouldBeDirected = undirectedWhenShouldBeDirected;
            this.directedWhenShouldBeUndirected = directedWhenShouldBeUndirected;
        }

        @Override
        public double[] values() {
            return new double[]{this.nCorrect.intValue(), this.directedWrongWay.intValue(), this.undirectedWhenShouldBeDirected.intValue(), this.directedWhenShouldBeUndirected.intValue()};
        }
    }

    public static class CoefficientEvaluationResult
    implements PartialEvaluationResult {
        public Double totalCoeffErrorSq;
        public Integer nEdgesEvaluated;

        public CoefficientEvaluationResult(Double totalCoeffErrorSq, Integer edgesEvaluated) {
            this.totalCoeffErrorSq = totalCoeffErrorSq;
            this.nEdgesEvaluated = edgesEvaluated;
        }

        public double loss() {
            return this.totalCoeffErrorSq;
        }

        @Override
        public double[] values() {
            return new double[]{this.totalCoeffErrorSq, this.nEdgesEvaluated.intValue(), this.loss()};
        }
    }

    public static class CPDAGEvaluationResult {
        public AdjacencyEvaluationResult adj;
        public OrientationEvaluationResult ori;

        public CPDAGEvaluationResult(AdjacencyEvaluationResult adj, OrientationEvaluationResult ori) {
            this.adj = adj;
            this.ori = ori;
        }

        public double loss() {
            double oriLoss = (double)this.ori.directedWrongWay.intValue() + 0.5 * (double)this.ori.undirectedWhenShouldBeDirected.intValue() + 0.5 * (double)this.ori.directedWhenShouldBeUndirected.intValue();
            double adjLoss = 1.5 * (double)this.adj.errorsOfOmission.intValue() + 1.0 * (double)this.adj.errorsOfCommission.intValue();
            return adjLoss + oriLoss;
        }
    }

    public static interface PartialEvaluationResult {
        public double[] values();
    }
}

