/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.util.RandomUtil;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.math3.util.FastMath;

public class Hungarian {
    public static int readInput(String prompt) {
        Scanner in = new Scanner(System.in);
        System.out.print(prompt);
        return in.nextInt();
    }

    public static void printTime(double time) {
        String timeElapsed = "";
        int days = (int)FastMath.floor(time) / 86400;
        int hours = (int)FastMath.floor(time % 86400.0) / 3600;
        int minutes = (int)FastMath.floor(time % 3600.0 / 60.0);
        int seconds = (int)FastMath.round(time % 60.0);
        if (days > 0) {
            timeElapsed = days + "d:";
        }
        if (hours > 0) {
            timeElapsed = timeElapsed + hours + "h:";
        }
        if (minutes > 0) {
            timeElapsed = timeElapsed + minutes + "m:";
        }
        timeElapsed = timeElapsed + seconds + "s";
        System.out.print("\nTotal time required: " + timeElapsed + "\n\n");
    }

    public static void generateRandomArray(double[][] array, String randomMethod) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (randomMethod.equals("random")) {
                    array[i][j] = RandomUtil.getInstance().nextDouble();
                }
                if (!randomMethod.equals("gaussian")) continue;
                array[i][j] = RandomUtil.getInstance().nextNormal(0.0, 1.0) / 4.0;
                if (array[i][j] > 0.5) {
                    array[i][j] = 0.5;
                }
                if (array[i][j] < -0.5) {
                    array[i][j] = -0.5;
                }
                array[i][j] = array[i][j] + 0.5;
            }
        }
    }

    public static double findLargest(double[][] array) {
        double largest = 0.0;
        double[][] dArray = array;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] doubles;
            for (double aDouble : doubles = dArray[i]) {
                if (!(aDouble > largest)) continue;
                largest = aDouble;
            }
        }
        return largest;
    }

    public static double[][] transpose(double[][] array) {
        double[][] transposedArray = new double[array[0].length][array.length];
        for (int i = 0; i < transposedArray.length; ++i) {
            for (int j = 0; j < transposedArray[i].length; ++j) {
                transposedArray[i][j] = array[j][i];
            }
        }
        return transposedArray;
    }

    public static double[][] copyOf(double[][] original) {
        double[][] copy = new double[original.length][original[0].length];
        for (int i = 0; i < original.length; ++i) {
            System.arraycopy(original[i], 0, copy[i], 0, original[i].length);
        }
        return copy;
    }

    public static int[][] hgAlgorithm(double[][] array, String sumType) {
        double[][] cost = Hungarian.copyOf(array);
        if (sumType.equalsIgnoreCase("max")) {
            double maxWeight = Hungarian.findLargest(cost);
            for (int i = 0; i < cost.length; ++i) {
                for (int j = 0; j < cost[i].length; ++j) {
                    cost[i][j] = maxWeight - cost[i][j];
                }
            }
        }
        double maxCost = Hungarian.findLargest(cost);
        int[][] mask = new int[cost.length][cost[0].length];
        int[] rowCover = new int[cost.length];
        int[] colCover = new int[cost[0].length];
        int[] zero_RC = new int[2];
        int step = 1;
        boolean done = false;
        while (!done) {
            switch (step) {
                case 1: {
                    step = Hungarian.hg_step1(cost);
                    break;
                }
                case 2: {
                    step = Hungarian.hg_step2(cost, mask, rowCover, colCover);
                    break;
                }
                case 3: {
                    step = Hungarian.hg_step3(mask, colCover);
                    break;
                }
                case 4: {
                    step = Hungarian.hg_step4(step, cost, mask, rowCover, colCover, zero_RC);
                    break;
                }
                case 5: {
                    step = Hungarian.hg_step5(mask, rowCover, colCover, zero_RC);
                    break;
                }
                case 6: {
                    step = Hungarian.hg_step6(cost, rowCover, colCover, maxCost);
                    break;
                }
                case 7: {
                    done = true;
                }
            }
        }
        int[][] assignment = new int[array.length][2];
        for (int i = 0; i < mask.length; ++i) {
            for (int j = 0; j < mask[i].length; ++j) {
                if (mask[i][j] != 1) continue;
                assignment[i][0] = i;
                assignment[i][1] = j;
            }
        }
        return assignment;
    }

    public static int hg_step1(double[][] cost) {
        for (int i = 0; i < cost.length; ++i) {
            int j;
            double minval = cost[i][0];
            for (j = 0; j < cost[i].length; ++j) {
                if (!(minval > cost[i][j])) continue;
                minval = cost[i][j];
            }
            for (j = 0; j < cost[i].length; ++j) {
                cost[i][j] = cost[i][j] - minval;
            }
        }
        return 2;
    }

    public static int hg_step2(double[][] cost, int[][] mask, int[] rowCover, int[] colCover) {
        for (int i = 0; i < cost.length; ++i) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (cost[i][j] != 0.0 || colCover[j] != 0 || rowCover[i] != 0) continue;
                mask[i][j] = 1;
                colCover[j] = 1;
                rowCover[i] = 1;
            }
        }
        Hungarian.clearCovers(rowCover, colCover);
        return 3;
    }

    public static int hg_step3(int[][] mask, int[] colCover) {
        for (int[] ints : mask) {
            for (int j = 0; j < ints.length; ++j) {
                if (ints[j] != 1) continue;
                colCover[j] = 1;
            }
        }
        int count = 0;
        for (int i : colCover) {
            count += i;
        }
        int step = count >= mask.length ? 7 : 4;
        return step;
    }

    public static int hg_step4(int step, double[][] cost, int[][] mask, int[] rowCover, int[] colCover, int[] zero_RC) {
        int[] row_col = new int[2];
        boolean done = false;
        while (!done) {
            Hungarian.findUncoveredZero(row_col, cost, rowCover, colCover);
            if (row_col[0] == -1) {
                done = true;
                step = 6;
                continue;
            }
            mask[row_col[0]][row_col[1]] = 2;
            boolean starInRow = false;
            for (int j = 0; j < mask[row_col[0]].length; ++j) {
                if (mask[row_col[0]][j] != 1) continue;
                starInRow = true;
                row_col[1] = j;
            }
            if (starInRow) {
                rowCover[row_col[0]] = 1;
                colCover[row_col[1]] = 0;
                continue;
            }
            zero_RC[0] = row_col[0];
            zero_RC[1] = row_col[1];
            done = true;
            step = 5;
        }
        return step;
    }

    public static void findUncoveredZero(int[] row_col, double[][] cost, int[] rowCover, int[] colCover) {
        row_col[0] = -1;
        row_col[1] = 0;
        int i = 0;
        boolean done = false;
        while (!done) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (cost[i][j] != 0.0 || rowCover[i] != 0 || colCover[j] != 0) continue;
                row_col[0] = i;
                row_col[1] = j;
                done = true;
            }
            if (++i < cost.length) continue;
            done = true;
        }
    }

    public static int hg_step5(int[][] mask, int[] rowCover, int[] colCover, int[] zero_RC) {
        int count = 0;
        int[][] path = new int[mask[0].length * mask.length][2];
        path[count][0] = zero_RC[0];
        path[count][1] = zero_RC[1];
        boolean done = false;
        while (!done) {
            int r = Hungarian.findStarInCol(mask, path[count][1]);
            if (r >= 0) {
                path[++count][0] = r;
                path[count][1] = path[count - 1][1];
            } else {
                done = true;
            }
            if (done) continue;
            int c = Hungarian.findPrimeInRow(mask, path[count][0]);
            path[++count][0] = path[count - 1][0];
            path[count][1] = c;
        }
        Hungarian.convertPath(mask, path, count);
        Hungarian.clearCovers(rowCover, colCover);
        Hungarian.erasePrimes(mask);
        return 3;
    }

    public static int findStarInCol(int[][] mask, int col) {
        int r = -1;
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i][col] != 1) continue;
            r = i;
        }
        return r;
    }

    public static int findPrimeInRow(int[][] mask, int row) {
        int c = -1;
        for (int j = 0; j < mask[row].length; ++j) {
            if (mask[row][j] != 2) continue;
            c = j;
        }
        return c;
    }

    public static void convertPath(int[][] mask, int[][] path, int count) {
        for (int i = 0; i <= count; ++i) {
            mask[path[i][0]][path[i][1]] = mask[path[i][0]][path[i][1]] == 1 ? 0 : 1;
        }
    }

    public static void erasePrimes(int[][] mask) {
        for (int i = 0; i < mask.length; ++i) {
            for (int j = 0; j < mask[i].length; ++j) {
                if (mask[i][j] != 2) continue;
                mask[i][j] = 0;
            }
        }
    }

    public static void clearCovers(int[] rowCover, int[] colCover) {
        Arrays.fill(rowCover, 0);
        Arrays.fill(colCover, 0);
    }

    public static int hg_step6(double[][] cost, int[] rowCover, int[] colCover, double maxCost) {
        double minval = Hungarian.findSmallest(cost, rowCover, colCover, maxCost);
        for (int i = 0; i < rowCover.length; ++i) {
            for (int j = 0; j < colCover.length; ++j) {
                if (rowCover[i] == 1) {
                    cost[i][j] = cost[i][j] + minval;
                }
                if (colCover[j] != 0) continue;
                cost[i][j] = cost[i][j] - minval;
            }
        }
        return 4;
    }

    public static double findSmallest(double[][] cost, int[] rowCover, int[] colCover, double maxCost) {
        double minval = maxCost;
        for (int i = 0; i < cost.length; ++i) {
            for (int j = 0; j < cost[i].length; ++j) {
                if (rowCover[i] != 0 || colCover[j] != 0 || !(minval > cost[i][j])) continue;
                minval = cost[i][j];
            }
        }
        return minval;
    }

    public static void main(String[] args) {
        String sumType = "max";
        int numOfRows = Hungarian.readInput("How many rows for the matrix? ");
        int numOfCols = Hungarian.readInput("How many columns for the matrix? ");
        double[][] array = new double[numOfRows][numOfCols];
        Hungarian.generateRandomArray(array, "random");
        if (array.length > array[0].length) {
            System.out.println("Array transposed (because rows>columns).\n");
            array = Hungarian.transpose(array);
        }
        System.out.println("\n(Printing out only 2 decimals)\n");
        System.out.println("The matrix is:");
        double[][] dArray = array;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] doubles;
            for (double aDouble : doubles = dArray[i]) {
                System.out.printf("%.2f\t", aDouble);
            }
            System.out.println();
        }
        System.out.println();
        double startTime = System.nanoTime();
        int[][] assignment = Hungarian.hgAlgorithm(array, "max");
        double endTime = System.nanoTime();
        System.out.println("The winning assignment (max sum) is:\n");
        double sum = 0.0;
        for (int[] ints : assignment) {
            System.out.printf("array(%d,%d) = %.2f\n", ints[0] + 1, ints[1] + 1, array[ints[0]][ints[1]]);
            sum += array[ints[0]][ints[1]];
        }
        System.out.printf("\nThe %s is: %.2f\n", "max", sum);
        Hungarian.printTime((endTime - startTime) / 1.0E9);
    }
}

