/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ChiSquareTest;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class IndTestChiSquare
implements IndependenceTest {
    private final ChiSquareTest chiSquareTest;
    private final List<Node> variables;
    private final DataSet dataSet;
    private double xSquare;
    private int df;
    private double pValue;
    private final HashSet<IndependenceFact> facts = new HashSet();
    private boolean verbose;

    public IndTestChiSquare(DataSet dataSet, double alpha) {
        this.dataSet = dataSet;
        this.variables = new ArrayList<Node>(dataSet.getVariables());
        this.chiSquareTest = new ChiSquareTest(dataSet, alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node variable : nodes) {
            if (this.variables.contains(variable)) continue;
            throw new IllegalArgumentException("All nodes must be original nodes");
        }
        int[] indices = new int[nodes.size()];
        int j = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!nodes.contains(this.variables.get(i))) continue;
            indices[++j] = i;
        }
        DataSet newDataSet = this.dataSet.subsetColumns(indices);
        double alpha = this.chiSquareTest.getAlpha();
        return new IndTestChiSquare(newDataSet, alpha);
    }

    public double getXSquare() {
        return this.xSquare;
    }

    public int getDf() {
        return this.df;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        int i;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node v : z) {
            if (v != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[2 + z.size()];
        testIndices[0] = this.variables.indexOf(x);
        testIndices[1] = this.variables.indexOf(y);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 2] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + " was not used in the constructor.");
        }
        ChiSquareTest.Result result = this.chiSquareTest.calcChiSquare(testIndices);
        this.xSquare = result.getXSquare();
        this.df = result.getDf();
        this.pValue = result.getPValue();
        if (this.verbose && result.isIndep()) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.pValue));
        }
        IndependenceFact fact = new IndependenceFact(x, y, z);
        this.facts.add(fact);
        return new IndependenceResult(fact, result.isIndep(), result.getPValue());
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        int i;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node aZ : z) {
            if (aZ != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[1 + z.size()];
        testIndices[0] = this.variables.indexOf(x1);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 1] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + "was not used in the constructor.");
        }
        boolean countDetermined = this.chiSquareTest.isDetermined(testIndices, this.getDeterminationP());
        if (countDetermined) {
            StringBuilder sb = new StringBuilder();
            sb.append("Determination found: ").append(x1).append(" is determined by {");
            for (int i2 = 0; i2 < z.size(); ++i2) {
                sb.append(z.get(i2));
                if (i2 >= z.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return countDetermined;
    }

    @Override
    public double getAlpha() {
        return this.chiSquareTest.getAlpha();
    }

    @Override
    public void setAlpha(double alpha) {
        this.chiSquareTest.setAlpha(alpha);
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return "Chi Square, alpha = " + nf.format(this.getAlpha());
    }

    private double getDeterminationP() {
        return 0.99;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return -(this.getPValue() - this.getAlpha());
    }

    public HashSet<IndependenceFact> getFacts() {
        return this.facts;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

