/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Matrix;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class IndTestCodec
implements IndependenceTest {
    private double alpha = 0.0;
    private final List<Node> variables;
    private final DataSet dataSet;
    private final double[][] data;
    private final boolean verbose = true;

    public IndTestCodec(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.dataSet = dataSet;
        this.data = dataSet.getDoubleData().transpose().toArray();
        this.alpha = alpha;
        this.variables = dataSet.getVariables();
        HashMap<Node, Integer> nodesHash = new HashMap<Node, Integer>();
        for (int i = 0; i < this.variables.size(); ++i) {
            nodesHash.put(this.variables.get(i), i);
        }
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node y, Node z, List<Node> x) {
        IndependenceFact fact = new IndependenceFact(y, z, x);
        int N = this.data[0].length;
        ArrayList<Integer> X = new ArrayList<Integer>();
        for (Node node : x) {
            X.add(this.indexOf(node));
        }
        ArrayList<Integer> XZ = new ArrayList<Integer>();
        XZ.add(this.indexOf(z));
        XZ.addAll(X);
        int[] R = new int[N];
        int _y = this.indexOf(y);
        double[] ydata = this.data[_y];
        for (int j = 0; j < N; ++j) {
            int count = 0;
            for (int i = 0; i < N; ++i) {
                if (!(ydata[i] < ydata[j])) continue;
                ++count;
            }
            R[j] = count;
        }
        double num = 0.0;
        double den = 0.0;
        for (int j = 0; j < N; ++j) {
            double Ndistance = Double.POSITIVE_INFINITY;
            int Nj = 0;
            for (int i = 0; i < N; ++i) {
                double d;
                if (i == j || !((d = this.distance(this.data, X, i, j)) < Ndistance)) continue;
                Ndistance = d;
                Nj = i;
            }
            double Mdistance = Double.POSITIVE_INFINITY;
            int Mj = 0;
            for (int i = 0; i < N; ++i) {
                double d;
                if (i == j || !((d = this.distance(this.data, XZ, i, j)) < Mdistance)) continue;
                Mdistance = d;
                Mj = i;
            }
            num += (double)(FastMath.min(R[j], R[Mj]) - FastMath.min(R[j], R[Nj]));
            den += (double)(R[j] - FastMath.min(R[j], R[Nj]));
        }
        double t = num / den;
        if (t < 0.0) {
            return new IndependenceResult(fact, true, t);
        }
        if (t > 1.0) {
            return new IndependenceResult(fact, false, t);
        }
        return new IndependenceResult(fact, t <= this.alpha, t);
    }

    private int indexOf(Node node) {
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!this.variables.get(i).getName().equals(node.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        return this.dataSet.getVariable(name);
    }

    @Override
    public List<String> getVariableNames() {
        return this.dataSet.getVariableNames();
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return 0.0;
    }

    @Override
    public void setAlpha(double alpha) {
    }

    @Override
    public DataModel getData() {
        return null;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return 0.0;
    }

    @Override
    public void setVerbose(boolean verbose) {
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    private double distance(double[][] data, List<Integer> cols, int i, int j) {
        double sum = 0.0;
        for (int col : cols) {
            double d = (data[col][i] - data[col][j]) / 2.0;
            if (Double.isNaN(d)) continue;
            sum += d * d;
        }
        return FastMath.sqrt(sum);
    }

    @Override
    public String toString() {
        return "Fisher Z, alpha = " + new DecimalFormat("0.0###").format(this.getAlpha());
    }
}

