/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ConditionalCorrelationIndependenceLingam;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IndTestConditionalCorrelationLingam
implements IndependenceTest {
    private final ConditionalCorrelationIndependenceLingam cci;
    private final List<Node> variables;
    private double alpha;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final DataSet dataSet;
    private boolean verbose;
    private double score = Double.NaN;

    public IndTestConditionalCorrelationLingam(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Q mut be in [0, 1]");
        }
        List<Node> nodes = dataSet.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.cci = new ConditionalCorrelationIndependenceLingam(dataSet, alpha);
        this.alpha = alpha;
        this.dataSet = dataSet;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        double score;
        this.score = score = this.cci.isIndependent(x, y, z);
        double p = this.cci.getPValue(score);
        System.out.println("p " + p);
        boolean bl = independent = p > this.alpha;
        if (independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, p));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, p);
    }

    public double getPValue() {
        return this.cci.getPValue();
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
        this.cci.setAlpha(alpha);
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (Node node : this.variables) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public String toString() {
        return "Conditional Correlation, q = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNumFunctions(int numFunctions) {
        this.cci.setNumFunctions(numFunctions);
    }

    public double getWeight() {
        return this.cci.getWidth();
    }

    public void setBasis(ConditionalCorrelationIndependenceLingam.Basis basis) {
        this.cci.setBasis(basis);
    }
}

