/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ConditionalGaussianLikelihood;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class IndTestConditionalGaussianLRT
implements IndependenceTest {
    private final DataSet data;
    private final Map<Node, Integer> nodesHash;
    private double alpha;
    private final ConditionalGaussianLikelihood likelihood;
    private double pValue = Double.NaN;
    private boolean verbose;
    private int numCategoriesToDiscretize = 3;

    public IndTestConditionalGaussianLRT(DataSet data, double alpha, boolean discretize) {
        this.data = data;
        this.likelihood = new ConditionalGaussianLikelihood(data);
        this.likelihood.setDiscretize(discretize);
        this.nodesHash = new HashedMap<Node, Integer>();
        List<Node> variables = data.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            this.nodesHash.put(variables.get(i), i);
        }
        this.alpha = alpha;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        this.likelihood.setNumCategoriesToDiscretize(this.numCategoriesToDiscretize);
        ArrayList<Node> allVars = new ArrayList<Node>(z);
        allVars.add(x);
        allVars.add(y);
        this.likelihood.setRows(this.getRows(allVars, this.nodesHash));
        int _x = this.nodesHash.get(x);
        int _y = this.nodesHash.get(y);
        int[] list0 = new int[z.size() + 1];
        int[] list2 = new int[z.size()];
        list0[0] = _x;
        for (int i = 0; i < z.size(); ++i) {
            int _z;
            list0[i + 1] = _z = this.nodesHash.get(z.get(i)).intValue();
            list2[i] = _z;
        }
        ConditionalGaussianLikelihood.Ret ret1 = this.likelihood.getLikelihood(_y, list0);
        ConditionalGaussianLikelihood.Ret ret2 = this.likelihood.getLikelihood(_y, list2);
        double lik0 = ret1.getLik() - ret2.getLik();
        double dof0 = ret1.getDof() - ret2.getDof();
        if (dof0 <= 0.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (this.alpha == 0.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (this.alpha == 1.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (lik0 == Double.POSITIVE_INFINITY) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        double pValue = Double.isNaN(lik0) ? Double.NaN : 1.0 - new ChiSquaredDistribution(dof0).cumulativeProbability(2.0 * lik0);
        this.pValue = pValue;
        boolean bl = independent = this.pValue > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.pValue));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, pValue);
    }

    private List<Integer> getRows(List<Node> allVars, Map<Node, Integer> nodesHash) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        block0: for (int k = 0; k < this.data.getNumRows(); ++k) {
            for (Node node : allVars) {
                if (!(node instanceof ContinuousVariable ? Double.isNaN(this.data.getDouble(k, nodesHash.get(node))) : node instanceof DiscreteVariable && this.data.getInt(k, nodesHash.get(node)) == -99)) continue;
                continue block0;
            }
            rows.add(k);
        }
        return rows;
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public List<Node> getVariables() {
        return this.data.getVariables();
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public DataSet getData() {
        return this.data;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getAlpha() - this.getPValue();
    }

    @Override
    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.0000");
        return "Conditional Gaussian LRT, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNumCategoriesToDiscretize(int numCategoriesToDiscretize) {
        this.numCategoriesToDiscretize = numCategoriesToDiscretize;
    }
}

