/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.CutoffFinder;
import edu.cmu.tetrad.util.Integrator;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.PartialCorrelationPdf;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Vector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class IndTestCramerT
implements IndependenceTest {
    private DataSet dataSet;
    private final ICovarianceMatrix covMatrix;
    private final List<Node> variables;
    private double alpha;
    private PartialCorrelationPdf pdf;
    private double cutoff;
    private double storedR;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private boolean verbose;

    public IndTestCramerT(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.dataSet = dataSet;
        this.covMatrix = new CorrelationMatrix(dataSet);
        this.variables = Collections.unmodifiableList(this.covMatrix.getVariables());
        this.setAlpha(alpha);
    }

    public IndTestCramerT(CorrelationMatrix covMatrix, double alpha) {
        this.covMatrix = covMatrix;
        this.variables = Collections.unmodifiableList(covMatrix.getVariables());
        this.setAlpha(alpha);
    }

    public IndTestCramerT(ICovarianceMatrix covMatrix, double alpha) {
        CorrelationMatrix corrMatrix = new CorrelationMatrix(covMatrix);
        this.variables = Collections.unmodifiableList(corrMatrix.getVariables());
        this.covMatrix = corrMatrix;
        this.setAlpha(alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.variables.indexOf(vars.get(i));
        }
        ICovarianceMatrix newCorrMatrix = this.covMatrix.getSubmatrix(indices);
        double alphaNew = this.getAlpha();
        return new IndTestCramerT(newCorrMatrix, alphaNew);
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int size = z.size() + 2;
        int[] indices = new int[size];
        indices[0] = this.getVariables().indexOf(x);
        indices[1] = this.getVariables().indexOf(y);
        for (int i = 0; i < z.size(); ++i) {
            indices[i + 2] = this.getVariables().indexOf(z.get(i));
        }
        Matrix submatrix = this.covMatrix().getMatrix().getSelection(indices, indices);
        if (DataUtils.containsMissingValue(submatrix)) {
            throw new IllegalArgumentException("Please remove or impute missing values first.");
        }
        if (submatrix.rank() != submatrix.rows()) {
            throw new IllegalArgumentException("Matrix singularity detected while using correlations \nto check for independence; probably due to collinearity \nin the data. The independence fact being checked was \n" + x + " _||_ " + y + " | " + z + ".");
        }
        submatrix = submatrix.inverse();
        double a = -1.0 * submatrix.get(0, 1);
        double b = FastMath.sqrt(submatrix.get(0, 0) * submatrix.get(1, 1));
        this.storedR = a / b;
        if (FastMath.abs(this.storedR) > 1.0) {
            this.storedR = FastMath.signum(this.storedR);
        }
        if (Double.isNaN(this.storedR)) {
            throw new IllegalArgumentException("Conditional correlation cannot be computed: " + SearchLogUtils.independenceFact(x, y, z));
        }
        boolean independent = this.isZero(this.storedR, size, this.getAlpha());
        double pValue = this.getPValue();
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, pValue));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, pValue);
    }

    public double getPValue() {
        return 2.0 * Integrator.getArea(this.pdf(), FastMath.abs(this.storedR), 1.0, 100);
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    private ICovarianceMatrix covMatrix() {
        return this.covMatrix;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        int i = this.covMatrix.getVariables().indexOf(x);
        Matrix matrix2D = this.covMatrix.getMatrix();
        double variance = matrix2D.get(i, i);
        if (parents.length > 0) {
            Matrix inverse;
            Matrix Czz = matrix2D.getSelection(parents, parents);
            try {
                inverse = Czz.inverse();
            }
            catch (Exception e) {
                return true;
            }
            Vector Cyz = matrix2D.getColumn(i);
            Cyz = Cyz.viewSelection(parents);
            Vector b = inverse.times(Cyz);
            variance -= Cyz.dotProduct(b);
        }
        return variance < 0.01;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return -(this.getPValue() - this.getAlpha());
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable : variables) {
            variableNames.add(variable.getName());
        }
        return variableNames;
    }

    @Override
    public String toString() {
        return "Partial Correlation T Test, alpha = " + nf.format(this.getAlpha());
    }

    private boolean isZero(double r, int k, double alpha) {
        if (this.pdf() == null || this.pdf().getK() != k) {
            this.cutoff = this.cutoff(k, alpha);
        }
        return FastMath.abs(r) <= this.cutoff;
    }

    private double cutoff(int k, double alpha) {
        this.pdf = new PartialCorrelationPdf(this.sampleSize() - 1, k);
        double upperBound = 1.0;
        double delta = 1.0E-5;
        return CutoffFinder.getCutoff(this.pdf(), 1.0, alpha, 1.0E-5);
    }

    private int sampleSize() {
        return this.covMatrix().getSampleSize();
    }

    private PartialCorrelationPdf pdf() {
        return this.pdf;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

