/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IndTestDSep
implements IndependenceTest {
    private IndependenceFacts independenceFacts;
    private Graph graph;
    private List<Node> observedVars;
    private List<Node> _observedVars;
    private List<IndependenceFact> facts;
    private boolean verbose = false;
    private double pvalue = 0.0;

    public IndTestDSep(Graph graph) {
        this(graph, false);
    }

    public IndTestDSep(IndependenceFacts facts, List<Node> variables) {
        this(facts, false);
        facts.setNodes(variables);
    }

    public IndTestDSep(IndependenceFacts facts) {
        this(facts, false);
    }

    public IndTestDSep(Graph graph, boolean keepLatents) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
        this._observedVars = this.calcVars(graph.getNodes(), keepLatents);
        this.observedVars = new ArrayList<Node>(this._observedVars);
    }

    public IndTestDSep(IndependenceFacts facts, boolean keepLatents) {
        if (facts == null) {
            throw new NullPointerException();
        }
        this.independenceFacts = facts;
        this._observedVars = this.calcVars(facts.getVariables(), keepLatents);
        this.observedVars = new ArrayList<Node>(this._observedVars);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        ArrayList<Node> _vars = new ArrayList<Node>();
        for (Node var : vars) {
            Node _var = this.getVariable(var.getName());
            if (_var == null) {
                throw new IllegalArgumentException("All vars must be original vars");
            }
            _vars.add(_var);
        }
        this._observedVars = _vars;
        this.observedVars = new ArrayList<Node>(this._observedVars);
        this.facts = new ArrayList<IndependenceFact>();
        return this;
    }

    private List<Node> calcVars(List<Node> nodes, boolean keepLatents) {
        if (keepLatents) {
            return nodes;
        }
        ArrayList<Node> _nodes = new ArrayList<Node>(nodes);
        _nodes.removeIf(node -> node.getNodeType() == NodeType.LATENT);
        return _nodes;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        double pValue;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        if (!this.observedVars.contains(x)) {
            throw new IllegalArgumentException("Not an observed variable: " + x);
        }
        if (!this.observedVars.contains(y)) {
            throw new IllegalArgumentException("Not an observed variable: " + y);
        }
        for (Node _z : z) {
            if (this.observedVars.contains(_z)) continue;
            throw new IllegalArgumentException("Not an observed variable: " + _z);
        }
        boolean dSeparated = this.graph != null ? !this.getGraph().paths().isDConnectedTo(x, y, z) : this.independenceFacts.isIndependent(x, y, z);
        if (this.verbose && dSeparated) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, 1.0));
        }
        if (dSeparated) {
            if (this.facts != null) {
                this.facts.add(new IndependenceFact(x, y, z));
            }
            pValue = 1.0;
        } else {
            pValue = 0.0;
        }
        this.pvalue = pValue;
        return new IndependenceResult(new IndependenceFact(x, y, z), dSeparated, pValue);
    }

    public boolean isDSeparated(Node x, Node y, List<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node aZ : z) {
            if (aZ != null) continue;
            throw new NullPointerException();
        }
        return this.getGraph().paths().isDSeparatedFrom(x, y, z);
    }

    public double getPValue() {
        return this.pvalue;
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this._observedVars);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> nodes = this._observedVars;
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (Node var : nodes) {
            nodeNames.add(var.getName());
        }
        return nodeNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        return false;
    }

    @Override
    public double getAlpha() {
        return 0.5;
    }

    @Override
    public void setAlpha(double alpha) {
    }

    @Override
    public Node getVariable(String name) {
        for (Node variable : this.observedVars) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    @Override
    public String toString() {
        return "D-separation";
    }

    @Override
    public DataSet getData() {
        return null;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue() == 1.0 ? -1.0 : 1.0;
    }

    public List<IndependenceFact> getFacts() {
        return this.facts;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

