/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.util.FastMath;

public class IndTestDegenerateGaussianLRT
implements IndependenceTest {
    private final BoxDataSet ddata;
    private final double[][] _ddata;
    private final Map<Node, Integer> nodesHash;
    private final DataSet dataSet;
    private double alpha = 0.001;
    private double pValue = Double.NaN;
    private final List<Node> variables;
    private final Map<Integer, List<Integer>> embedding;
    private static final double L2PE = FastMath.log(17.079468445347132);
    private boolean verbose;

    public IndTestDegenerateGaussianLRT(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        int n = dataSet.getNumRows();
        this.embedding = new HashMap<Integer, List<Integer>>();
        ArrayList<Node> A = new ArrayList<Node>();
        ArrayList<double[]> B = new ArrayList<double[]>();
        HashMap<Node, Integer> nodesHash = new HashMap<Node, Integer>();
        for (int j = 0; j < this.variables.size(); ++j) {
            nodesHash.put(this.variables.get(j), j);
        }
        this.nodesHash = nodesHash;
        int index = 0;
        int i = 0;
        for (int i_ = 0; i_ < this.variables.size(); ++i_) {
            Node v = this.variables.get(i_);
            if (v instanceof DiscreteVariable) {
                HashMap keys = new HashMap();
                HashMap keysReverse = new HashMap();
                for (int j = 0; j < n; ++j) {
                    ArrayList<Integer> key = new ArrayList<Integer>();
                    key.add(this.dataSet.getInt(j, i_));
                    if (!keys.containsKey(key)) {
                        keys.put(key, i);
                        keysReverse.put(i, key);
                        ContinuousVariable v_ = new ContinuousVariable("V__" + ++index);
                        A.add(v_);
                        B.add(new double[n]);
                        ++i;
                    }
                    ((double[])B.get((int)((Integer)keys.get(key)).intValue()))[j] = 1.0;
                }
                keys.remove(keysReverse.get(--i));
                A.remove(i);
                B.remove(i);
                this.embedding.put(i_, new ArrayList(keys.values()));
                continue;
            }
            A.add(v);
            double[] b = new double[n];
            for (int j = 0; j < n; ++j) {
                b[j] = this.dataSet.getDouble(j, i_);
            }
            B.add(b);
            ArrayList<Integer> index2 = new ArrayList<Integer>();
            index2.add(i);
            this.embedding.put(i_, index2);
            ++i;
        }
        double[][] B_ = new double[n][B.size()];
        for (int j = 0; j < B.size(); ++j) {
            for (int k = 0; k < n; ++k) {
                B_[k][j] = ((double[])B.get(j))[k];
            }
        }
        BlockRealMatrix D = new BlockRealMatrix(B_);
        this.ddata = new BoxDataSet(new DoubleDataBox(D.getData()), A);
        this._ddata = this.ddata.getDoubleData().toArray();
    }

    private Ret getlldof(List<Integer> rows, int i, int ... parents) {
        int i_;
        int N = rows.size();
        ArrayList B = new ArrayList();
        ArrayList A = new ArrayList(this.embedding.get(i));
        for (int i_2 : parents) {
            B.addAll(this.embedding.get(i_2));
        }
        int[] A_ = new int[A.size() + B.size()];
        int[] B_ = new int[B.size()];
        for (i_ = 0; i_ < A.size(); ++i_) {
            A_[i_] = (Integer)A.get(i_);
        }
        for (i_ = 0; i_ < B.size(); ++i_) {
            A_[A.size() + i_] = (Integer)B.get(i_);
            B_[i_] = (Integer)B.get(i_);
        }
        double dof = (double)(A_.length * (A_.length + 1) - B_.length * (B_.length + 1)) / 2.0;
        double ldetA = FastMath.log(this.getCov(rows, A_).det());
        double ldetB = FastMath.log(this.getCov(rows, B_).det());
        double lik = (double)N * (ldetB - ldetA) + L2PE * (double)(B_.length - A_.length);
        return new Ret(lik, dof);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        ArrayList<Node> allNodes = new ArrayList<Node>();
        allNodes.add(x);
        allNodes.add(y);
        allNodes.addAll(z);
        List<Integer> rows = this.getRows(allNodes, this.nodesHash);
        if (rows.isEmpty()) {
            return new IndependenceResult(new IndependenceFact(x, y, z), true, Double.NaN);
        }
        int _x = this.nodesHash.get(x);
        int _y = this.nodesHash.get(y);
        int[] list0 = new int[z.size() + 1];
        int[] list2 = new int[z.size()];
        list0[0] = _x;
        for (int i = 0; i < z.size(); ++i) {
            int _z;
            list0[i + 1] = _z = this.nodesHash.get(z.get(i)).intValue();
            list2[i] = _z;
        }
        Ret ret1 = this.getlldof(rows, _y, list0);
        Ret ret2 = this.getlldof(rows, _y, list2);
        double lik0 = ret1.getLik() - ret2.getLik();
        double dof0 = ret1.getDof() - ret2.getDof();
        if (dof0 <= 0.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (this.alpha == 0.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (this.alpha == 1.0) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (lik0 == Double.POSITIVE_INFINITY) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        double pValue = Double.isNaN(lik0) ? Double.NaN : 1.0 - new ChiSquaredDistribution(dof0).cumulativeProbability(2.0 * lik0);
        this.pValue = pValue;
        boolean bl = independent = this.pValue > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, pValue));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, pValue);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getAlpha() - this.getPValue();
    }

    @Override
    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.0000");
        return "Degenerate Gaussian, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private List<Integer> getRows(List<Node> allVars, Map<Node, Integer> nodesHash) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        block0: for (int k = 0; k < this.dataSet.getNumRows(); ++k) {
            for (Node node : allVars) {
                ArrayList A = new ArrayList(this.embedding.get(nodesHash.get(node)));
                Iterator iterator = A.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (!Double.isNaN(this.ddata.getDouble(k, i))) continue;
                    continue block0;
                }
            }
            rows.add(k);
        }
        return rows;
    }

    private Matrix getCov(List<Integer> rows, int[] cols) {
        Matrix cov = new Matrix(cols.length, cols.length);
        for (int i = 0; i < cols.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                double mui = 0.0;
                double muj = 0.0;
                for (int k : rows) {
                    mui += this._ddata[k][cols[i]];
                    muj += this._ddata[k][cols[j]];
                }
                mui /= (double)(rows.size() - 1);
                muj /= (double)(rows.size() - 1);
                double _cov = 0.0;
                for (int k : rows) {
                    _cov += (this._ddata[k][cols[i]] - mui) * (this._ddata[k][cols[j]] - muj);
                }
                double mean = _cov / (double)rows.size();
                cov.set(i, j, mean);
            }
        }
        return cov;
    }

    public static class Ret {
        private final double lik;
        private final double dof;

        private Ret(double lik, double dof) {
            this.lik = lik;
            this.dof = dof;
        }

        public double getLik() {
            return this.lik;
        }

        public double getDof() {
            return this.dof;
        }

        public String toString() {
            return "lik = " + this.lik + " dof = " + this.dof;
        }
    }
}

