/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public final class IndTestFisherZFisherPValue
implements IndependenceTest {
    private final List<Node> variables;
    private final int sampleSize;
    private final List<DataSet> dataSets;
    private double alpha;
    private double pValue = Double.NaN;
    private final int[] rows;
    private final List<ICovarianceMatrix> ncov;
    private final Map<Node, Integer> variablesMap;
    private double percent = 0.5;
    private final List<IndependenceTest> tests = new ArrayList<IndependenceTest>();
    private boolean verbose;

    public IndTestFisherZFisherPValue(List<DataSet> dataSets, double alpha) {
        int i;
        this.sampleSize = dataSets.get(0).getNumRows();
        this.setAlpha(alpha);
        this.ncov = new ArrayList<ICovarianceMatrix>();
        for (DataSet dataSet : dataSets) {
            this.ncov.add(new CovarianceMatrix(dataSet));
        }
        this.rows = new int[dataSets.get(0).getNumRows()];
        for (i = 0; i < this.getRows().length; ++i) {
            this.getRows()[i] = i;
        }
        this.variables = dataSets.get(0).getVariables();
        this.variablesMap = new HashMap<Node, Integer>();
        for (i = 0; i < this.variables.size(); ++i) {
            this.variablesMap.put(this.variables.get(i), i);
        }
        for (DataSet dataSet : dataSets) {
            this.tests.add(new IndTestFisherZ(dataSet, alpha));
        }
        this.dataSets = dataSets;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        double p;
        int[] all = new int[z.size() + 2];
        all[0] = this.variablesMap.get(x);
        all[1] = this.variablesMap.get(y);
        for (int i = 0; i < z.size(); ++i) {
            all[i + 2] = this.variablesMap.get(z.get(i));
        }
        ArrayList<Double> pValues = new ArrayList<Double>();
        for (ICovarianceMatrix iCovarianceMatrix : this.ncov) {
            Matrix _ncov = iCovarianceMatrix.getSelection(all, all);
            Matrix inv = _ncov.inverse();
            double r = -inv.get(0, 1) / FastMath.sqrt(inv.get(0, 0) * inv.get(1, 1));
            double _z = FastMath.sqrt((double)(this.sampleSize - z.size()) - 3.0) * 0.5 * (FastMath.log(1.0 + r) - FastMath.log(1.0 - r));
            double pvalue = 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(_z)));
            pValues.add(pvalue);
        }
        Collections.sort(pValues);
        int n = 0;
        double tf = 0.0;
        int numZeros = 0;
        Iterator r = pValues.iterator();
        while (r.hasNext()) {
            double p2 = (Double)r.next();
            if (p2 == 0.0) {
                ++numZeros;
                continue;
            }
            tf += -2.0 * FastMath.log(p2);
            ++n;
        }
        if (numZeros >= pValues.size() / 2) {
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        if (tf == 0.0) {
            throw new IllegalArgumentException("For the Fisher method, all component p values in the calculation may not be zero, \nsince not all p values can be ignored. Maybe try calculating AR residuals.");
        }
        this.pValue = p = 1.0 - ProbUtils.chisqCdf(tf, 2 * n);
        boolean bl = independent = p > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.pValue));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, p);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        return (DataSet)this.tests.get(0).getData();
    }

    @Override
    public ICovarianceMatrix getCov() {
        ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
        for (DataSet d : this.dataSets) {
            _dataSets.add(DataUtils.standardizeData(d));
        }
        return new CovarianceMatrix(DataUtils.concatenate(_dataSets));
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue();
    }

    @Override
    public String toString() {
        return "Fisher Z, Fisher P Value Percent = " + FastMath.round(this.percent * 100.0);
    }

    public int[] getRows() {
        return this.rows;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        if (percent < 0.0 || percent > 1.0) {
            throw new IllegalArgumentException();
        }
        this.percent = percent;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

