/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.RecursivePartialCorrelation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public final class IndTestFisherZRecursive
implements IndependenceTest {
    private final ICovarianceMatrix covMatrix;
    private List<Node> variables;
    private double alpha;
    private DataSet dataSet;
    private final Map<Node, Integer> indexMap;
    private final Map<String, Node> nameMap;
    private boolean verbose = true;
    private double fisherZ = Double.NaN;
    private double cutoff = Double.NaN;
    private final NormalDistribution normal = new NormalDistribution(0.0, 1.0);
    private final RecursivePartialCorrelation recursivePartialCorrelation;

    public IndTestFisherZRecursive(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha mut be in [0, 1]");
        }
        this.covMatrix = new CovarianceMatrix(dataSet);
        List<Node> nodes = this.covMatrix.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.indexMap = this.indexMap(this.variables);
        this.nameMap = this.nameMap(this.variables);
        this.setAlpha(alpha);
        this.dataSet = dataSet;
        this.recursivePartialCorrelation = new RecursivePartialCorrelation(this.covMatrix);
    }

    public IndTestFisherZRecursive(Matrix data, List<Node> variables, double alpha) {
        this.dataSet = new BoxDataSet(new VerticalDoubleDataBox(data.transpose().toArray()), variables);
        this.covMatrix = new CovarianceMatrix(this.dataSet);
        this.variables = Collections.unmodifiableList(variables);
        this.indexMap = this.indexMap(variables);
        this.nameMap = this.nameMap(variables);
        this.setAlpha(alpha);
        this.recursivePartialCorrelation = new RecursivePartialCorrelation(this.covMatrix);
    }

    public IndTestFisherZRecursive(ICovarianceMatrix covMatrix, double alpha) {
        this.covMatrix = covMatrix;
        this.variables = covMatrix.getVariables();
        this.indexMap = this.indexMap(this.variables);
        this.nameMap = this.nameMap(this.variables);
        this.setAlpha(alpha);
        this.recursivePartialCorrelation = new RecursivePartialCorrelation(this.covMatrix);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.indexMap.get(vars.get(i));
        }
        ICovarianceMatrix newCovMatrix = this.covMatrix.getSubmatrix(indices);
        double alphaNew = this.getAlpha();
        return new IndTestFisherZ(newCovMatrix, alphaNew);
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        double fisherZ;
        double r;
        int n = this.sampleSize();
        try {
            r = this.partialCorrelation(x, y, z);
        }
        catch (SingularMatrixException e) {
            System.out.println(SearchLogUtils.determinismDetected(z, x));
            this.fisherZ = Double.POSITIVE_INFINITY;
            return new IndependenceResult(new IndependenceFact(x, y, z), false, Double.NaN);
        }
        double q = 0.5 * (StrictMath.log(1.0 + r) - FastMath.log(1.0 - r));
        this.fisherZ = fisherZ = FastMath.sqrt(n - 3 - z.size()) * FastMath.abs(q);
        boolean bl = independent = fisherZ < this.cutoff;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.getPValue());
    }

    private double partialCorrelation(Node x, Node y, List<Node> z) throws SingularMatrixException {
        return this.recursivePartialCorrelation.corr(x, y, z);
    }

    public double getPValue() {
        return 2.0 * (1.0 - this.normal.cumulativeProbability(FastMath.abs(this.fisherZ)));
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range: " + alpha);
        }
        this.alpha = alpha;
        this.cutoff = StatUtils.getZForAlpha(alpha);
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        if (parents.length > 0) {
            Matrix Czz = this.covMatrix.getSelection(parents, parents);
            try {
                Czz.inverse();
            }
            catch (SingularMatrixException e) {
                System.out.println(SearchLogUtils.determinismDetected(z, x));
                return true;
            }
        }
        return false;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public String toString() {
        return "Fisher Z, alpha = " + new DecimalFormat("0.0E0").format(this.getAlpha());
    }

    private int sampleSize() {
        return this.covMatrix().getSampleSize();
    }

    private ICovarianceMatrix covMatrix() {
        return this.covMatrix;
    }

    private Map<String, Node> nameMap(List<Node> variables) {
        ConcurrentHashMap<String, Node> nameMap = new ConcurrentHashMap<String, Node>();
        for (Node node : variables) {
            nameMap.put(node.getName(), node);
        }
        return nameMap;
    }

    private Map<Node, Integer> indexMap(List<Node> variables) {
        ConcurrentHashMap<Node, Integer> indexMap = new ConcurrentHashMap<Node, Integer>();
        for (int i = 0; i < variables.size(); ++i) {
            indexMap.put(variables.get(i), i);
        }
        return indexMap;
    }

    public void setVariables(List<Node> variables) {
        if (variables.size() != this.variables.size()) {
            throw new IllegalArgumentException("Wrong # of variables.");
        }
        this.variables = new ArrayList<Node>(variables);
        this.covMatrix.setVariables(variables);
    }

    @Override
    public ICovarianceMatrix getCov() {
        return this.covMatrix;
    }

    @Override
    public List<DataSet> getDataSets() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        dataSets.add(this.dataSet);
        return dataSets;
    }

    @Override
    public int getSampleSize() {
        return this.covMatrix.getSampleSize();
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return FastMath.abs(this.fisherZ) - this.cutoff;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

