/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GSquareTest;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IndTestGSquare
implements IndependenceTest {
    private final GSquareTest gSquareTest;
    private final List<Node> variables;
    private final DataSet dataSet;
    private final double alpha;
    private double pValue;
    private double determinationP = 0.99;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private boolean verbose;

    public IndTestGSquare(DataSet dataSet, double alpha) {
        this.dataSet = dataSet;
        this.alpha = alpha;
        this.variables = new ArrayList<Node>(dataSet.getVariables());
        this.gSquareTest = new GSquareTest(dataSet, alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        int[] indices = new int[vars.size()];
        int j = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!vars.contains(this.variables.get(i))) continue;
            indices[++j] = i;
        }
        DataSet newDataSet = this.dataSet.subsetColumns(indices);
        return new IndTestGSquare(newDataSet, this.alpha);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        int i;
        if (x == null) {
            throw new NullPointerException();
        }
        if (y == null) {
            throw new NullPointerException();
        }
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[2 + z.size()];
        testIndices[0] = this.variables.indexOf(x);
        testIndices[1] = this.variables.indexOf(y);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 2] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + " was not used in the constructor.");
        }
        GSquareTest.Result result = this.gSquareTest.calcGSquare(testIndices);
        this.pValue = result.getPValue();
        if (this.verbose && result.isIndep()) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), result.isIndep(), result.getPValue());
    }

    @Override
    public void setAlpha(double alpha) {
        this.gSquareTest.setAlpha(alpha);
    }

    @Override
    public double getAlpha() {
        return this.gSquareTest.getAlpha();
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public String toString() {
        return "G Square, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean determines(List<Node> z, Node x1) {
        int i;
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int[] testIndices = new int[1 + z.size()];
        testIndices[0] = this.variables.indexOf(x1);
        for (i = 0; i < z.size(); ++i) {
            testIndices[i + 1] = this.variables.indexOf(z.get(i));
        }
        for (i = 0; i < testIndices.length; ++i) {
            if (testIndices[i] >= 0) continue;
            throw new IllegalArgumentException("Variable " + i + "was not used in the constructor.");
        }
        boolean determined = this.gSquareTest.isDetermined(testIndices, this.getDeterminationP());
        if (determined) {
            StringBuilder sb = new StringBuilder();
            sb.append("Determination found: ").append(x1).append(" is determined by {");
            for (int i2 = 0; i2 < z.size(); ++i2) {
                sb.append(z.get(i2));
                if (i2 >= z.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return determined;
    }

    public double getDeterminationP() {
        return this.determinationP;
    }

    public void setDeterminationP(double determinationP) {
        this.determinationP = determinationP;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

