/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;

public final class IndTestIndependenceFacts
implements IndependenceTest {
    private final IndependenceFacts facts;
    private boolean verbose;

    public IndTestIndependenceFacts(IndependenceFacts facts) {
        this.facts = facts;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        Node[] _z = new Node[z.size()];
        for (int i = 0; i < z.size(); ++i) {
            _z[i] = z.get(i);
        }
        boolean independent = this.facts.isIndependent(x, y, _z);
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.getPValue());
    }

    public double getPValue() {
        return Double.NaN;
    }

    @Override
    public List<Node> getVariables() {
        return this.facts.getVariables();
    }

    @Override
    public Node getVariable(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        List<Node> variables = this.facts.getVariables();
        for (Node node : variables) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        return this.facts.getVariableNames();
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return Double.NaN;
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataModel getData() {
        return this.facts;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

