/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MVPLikelihood;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public class IndTestMVPLRT
implements IndependenceTest {
    private final DataSet data;
    private final Map<Node, Integer> nodesHash;
    private double alpha;
    private final MVPLikelihood likelihood;
    private boolean verbose;
    private double pValue = Double.NaN;

    public IndTestMVPLRT(DataSet data, double alpha, int fDegree, boolean discretize) {
        this.data = data;
        this.likelihood = new MVPLikelihood(data, -1.0, fDegree, discretize);
        this.nodesHash = new HashedMap<Node, Integer>();
        List<Node> variables = data.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            this.nodesHash.put(variables.get(i), i);
        }
        this.alpha = alpha;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        int _x = this.nodesHash.get(x);
        int _y = this.nodesHash.get(y);
        int[] list0 = new int[z.size() + 1];
        int[] list1 = new int[z.size() + 1];
        int[] list2 = new int[z.size()];
        list0[0] = _x;
        list1[0] = _y;
        for (int i = 0; i < z.size(); ++i) {
            int _z;
            list0[i + 1] = _z = this.nodesHash.get(z.get(i)).intValue();
            list1[i + 1] = _z;
            list2[i] = _z;
        }
        double lik_0 = this.likelihood.getLik(_y, list0) - this.likelihood.getLik(_y, list2);
        double dof_0 = this.likelihood.getLik(_y, list0) - this.likelihood.getLik(_y, list2);
        double lik_1 = this.likelihood.getLik(_x, list1) - this.likelihood.getLik(_x, list2);
        double dof_1 = this.likelihood.getLik(_x, list1) - this.likelihood.getLik(_x, list2);
        if (dof_0 <= 0.0) {
            dof_0 = 1.0;
        }
        if (dof_1 <= 0.0) {
            dof_1 = 1.0;
        }
        double p_0 = 0.0;
        double p_1 = 0.0;
        try {
            p_0 = 1.0 - new ChiSquaredDistribution(dof_0).cumulativeProbability(2.0 * lik_0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            p_1 = 1.0 - new ChiSquaredDistribution(dof_1).cumulativeProbability(2.0 * lik_1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pValue = FastMath.min(p_0, p_1);
        boolean bl = independent = this.pValue > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, z, this.getPValue()));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.pValue);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public List<Node> getVariables() {
        return this.data.getVariables();
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public DataSet getData() {
        return this.data;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getAlpha() - this.getPValue();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

