/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class IndTestRegression
implements IndependenceTest {
    private final DoubleMatrix2D data;
    private final List<Node> variables;
    private double alpha;
    private double fishersZ;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private final DataSet dataSet;
    private boolean verbose;

    public IndTestRegression(DataSet dataSet, double alpha) {
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha mut be in [0, 1]");
        }
        this.dataSet = dataSet;
        this.data = new DenseDoubleMatrix2D(dataSet.getDoubleData().toArray());
        this.variables = Collections.unmodifiableList(dataSet.getVariables());
        this.setAlpha(alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        return null;
    }

    @Override
    public IndependenceResult checkIndependence(Node xVar, Node yVar, List<Node> zList) {
        boolean independent;
        RegressionResult result;
        if (zList == null) {
            throw new NullPointerException();
        }
        for (Node node : zList) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Node> regressors = new ArrayList<Node>();
        regressors.add(this.dataSet.getVariable(yVar.getName()));
        for (Node zVar : zList) {
            regressors.add(this.dataSet.getVariable(zVar.getName()));
        }
        RegressionDataset regressionDataset = new RegressionDataset(this.dataSet);
        try {
            result = regressionDataset.regress(xVar, regressors);
        }
        catch (Exception e) {
            return new IndependenceResult(new IndependenceFact(xVar, yVar, zList), false, Double.NaN);
        }
        double p = result.getP()[1];
        boolean bl = independent = p > this.alpha;
        if (this.verbose) {
            if (independent) {
                TetradLogger.getInstance().log("independencies", SearchLogUtils.independenceFactMsg(xVar, yVar, zList, p));
            } else {
                TetradLogger.getInstance().log("dependencies", SearchLogUtils.dependenceFactMsg(xVar, yVar, zList, p));
            }
        }
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(xVar, yVar, zList, p));
        }
        return new IndependenceResult(new IndependenceFact(xVar, yVar, zList), independent, p);
    }

    public double getPValue() {
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(this.fishersZ)));
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable : variables) {
            variableNames.add(variable.getName());
        }
        return variableNames;
    }

    @Override
    public String toString() {
        return "Linear Regression Test, alpha = " + nf.format(this.getAlpha());
    }

    @Override
    public boolean determines(List<Node> zList, Node xVar) {
        boolean determined;
        if (zList == null) {
            throw new NullPointerException();
        }
        for (Node node : zList) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        int size = zList.size();
        int[] zCols = new int[size];
        int xIndex = this.getVariables().indexOf(xVar);
        for (int i = 0; i < zList.size(); ++i) {
            zCols[i] = this.getVariables().indexOf(zList.get(i));
        }
        int[] zRows = new int[this.data.rows()];
        for (int i = 0; i < this.data.rows(); ++i) {
            zRows[i] = i;
        }
        DoubleMatrix2D Z = this.data.viewSelection(zRows, zCols);
        DoubleMatrix1D x = this.data.viewColumn(xIndex);
        DoubleMatrix2D Zt = new Algebra().transpose(Z);
        DoubleMatrix2D ZtZ = new Algebra().mult(Zt, Z);
        DenseDoubleMatrix2D G = new DenseDoubleMatrix2D(new Matrix(ZtZ.toArray()).inverse().toArray());
        DoubleMatrix2D Zt2 = Zt.like();
        Zt2.assign(Zt);
        DoubleMatrix2D GZt = new Algebra().mult((DoubleMatrix2D)G, Zt2);
        DoubleMatrix1D b_x = new Algebra().mult(GZt, x);
        DoubleMatrix1D xPred = new Algebra().mult(Z, b_x);
        DoubleMatrix1D xRes = xPred.copy().assign(x, Functions.minus);
        double SSE = xRes.aggregate(Functions.plus, Functions.square);
        boolean bl = determined = SSE < 1.0E-4;
        if (determined) {
            StringBuilder sb = new StringBuilder();
            sb.append("Determination found: ").append(xVar).append(" is determined by {");
            for (int i = 0; i < zList.size(); ++i) {
                sb.append(zList.get(i));
                if (i >= zList.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}");
            TetradLogger.getInstance().log("independencies", sb.toString());
        }
        return determined;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

