/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class IndTestScore
implements IndependenceTest {
    private final Score score;
    private final List<Node> variables;
    private double bump = Double.NaN;
    private final DataModel data;
    private boolean verbose;

    public IndTestScore(Score score) {
        this(score, null);
    }

    public IndTestScore(Score score, DataModel data) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.score = score;
        this.variables = score.getVariables();
        this.data = data;
    }

    @Override
    public IndTestScore indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        boolean independent;
        double v;
        ArrayList<Node> z1 = new ArrayList<Node>(z);
        if (this.determines(z1, x)) {
            new IndependenceResult(new IndependenceFact(x, y, z), false, this.getPValue());
        }
        if (this.determines(z1, y)) {
            new IndependenceResult(new IndependenceFact(x, y, z), false, this.getPValue());
        }
        this.bump = v = this.score.localScoreDiff(this.variables.indexOf(x), this.variables.indexOf(y), this.varIndices(z));
        boolean bl = independent = v <= 0.0;
        if (this.verbose && independent) {
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFact(x, y, z) + " score = " + nf.format(this.bump));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.getPValue());
    }

    private int[] varIndices(List<Node> z) {
        int[] indices = new int[z.size()];
        for (int i = 0; i < z.size(); ++i) {
            indices[i] = this.variables.indexOf(z.get(i));
        }
        return indices;
    }

    public double getPValue() {
        return this.bump;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String name) {
        for (Node node : this.variables) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : this.variables) {
            names.add(node.getName());
        }
        return names;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return this.score.determines(z, y);
    }

    @Override
    public double getAlpha() {
        return -1.0;
    }

    @Override
    public void setAlpha(double alpha) {
    }

    @Override
    public DataModel getData() {
        return this.data;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return ((SemBicScore)this.score).getCovariances();
    }

    @Override
    public List<DataSet> getDataSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSampleSize() {
        return this.score.getSampleSize();
    }

    @Override
    public List<Matrix> getCovMatrices() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getScore() {
        return this.bump;
    }

    public Score getWrappedScore() {
        return this.score;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return this.score.toString() + " Interpreted as a Test";
    }
}

