/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.EstimateRank;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Vector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class IndTestTrekSep
implements IndependenceTest {
    private final ICovarianceMatrix covMatrix;
    private final List<Node> latents;
    private boolean verbose;
    private final List<List<Node>> clustering;
    private List<Node> variables;
    private double alpha;
    private double pValue;
    private static final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
    private DataSet dataSet;
    private final Map<Node, Integer> indexMap;
    private final Map<String, Node> nameMap;

    public IndTestTrekSep(ICovarianceMatrix covMatrix, double alpha, List<List<Node>> clustering, List<Node> latents) {
        this.clustering = clustering;
        this.covMatrix = covMatrix;
        this.variables = Collections.unmodifiableList(covMatrix.getVariables());
        this.indexMap = this.indexMap(this.variables, latents);
        this.nameMap = this.nameMap(this.variables);
        this.latents = latents;
        this.setAlpha(alpha);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.variables.contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        int[] indices = new int[vars.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.indexMap.get(vars.get(i));
        }
        ICovarianceMatrix newCovMatrix = this.covMatrix.getSubmatrix(indices);
        double alphaNew = this.getAlpha();
        return new IndTestTrekSep(newCovMatrix, alphaNew, this.clustering, this.latents);
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        int i;
        int n = this.sampleSize();
        int xi = this.latents.indexOf(x);
        int yi = this.latents.indexOf(y);
        int nA = this.clustering.get(xi).size();
        int nB = this.clustering.get(yi).size();
        for (Node node : z) {
            int s = this.latents.indexOf(node);
            int m = this.clustering.get(s).size() / 2;
            nA += m;
            nB += m;
        }
        int[] A = new int[nA];
        int[] B = new int[nB];
        int a = 0;
        int b = 0;
        for (i = 0; i < this.clustering.get(xi).size(); ++i) {
            A[i] = this.variables.indexOf(this.clustering.get(xi).get(i));
            ++a;
        }
        for (i = 0; i < this.clustering.get(yi).size(); ++i) {
            B[i] = this.variables.indexOf(this.clustering.get(yi).get(i));
            ++b;
        }
        for (Node node : z) {
            int s = this.latents.indexOf(node);
            int m = this.clustering.get(s).size() / 2;
            for (int j = 1; j <= m; ++j) {
                A[a] = this.variables.indexOf(this.clustering.get(s).get(j - 1));
                ++a;
                B[b] = this.variables.indexOf(this.clustering.get(s).get(m + j - 1));
                ++b;
            }
        }
        double[][] CovMatrix = this.covMatrix.getMatrix().toArray();
        int rank = new EstimateRank().Estimate(A, B, CovMatrix, n, this.alpha);
        boolean independent = rank <= z.size();
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.pValue);
    }

    public double getPValue() {
        return this.pValue;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.latents;
    }

    @Override
    public Node getVariable(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public List<String> getVariableNames() {
        List<Node> variables = this.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node variable1 : variables) {
            variableNames.add(variable1.getName());
        }
        return variableNames;
    }

    @Override
    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        int i = this.covMatrix.getVariables().indexOf(x);
        Matrix matrix2D = this.covMatrix.getMatrix();
        double variance = matrix2D.get(i, i);
        if (parents.length > 0) {
            Matrix inverse;
            Matrix Czz = matrix2D.getSelection(parents, parents);
            try {
                inverse = Czz.inverse();
            }
            catch (Exception e) {
                return true;
            }
            Vector Cyz = matrix2D.getColumn(i);
            Cyz = Cyz.viewSelection(parents);
            Vector b = inverse.times(Cyz);
            variance -= Cyz.dotProduct(b);
        }
        return variance < 1.0E-20;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public String toString() {
        return "t-Separation test, alpha = " + nf.format(this.getAlpha());
    }

    private int sampleSize() {
        return this.covMatrix().getSampleSize();
    }

    private ICovarianceMatrix covMatrix() {
        return this.covMatrix;
    }

    private Map<String, Node> nameMap(List<Node> variables) {
        ConcurrentHashMap<String, Node> nameMap = new ConcurrentHashMap<String, Node>();
        for (Node node : variables) {
            nameMap.put(node.getName(), node);
        }
        return nameMap;
    }

    private Map<Node, Integer> indexMap(List<Node> variables, List<Node> latents) {
        ConcurrentHashMap<Node, Integer> indexMap = new ConcurrentHashMap<Node, Integer>();
        int index = 0;
        for (Node variable : variables) {
            indexMap.put(variable, index++);
        }
        for (Node latent : latents) {
            indexMap.put(latent, index++);
        }
        return indexMap;
    }

    public void setVariables(List<Node> variables) {
        if (variables.size() != this.variables.size()) {
            throw new IllegalArgumentException("Wrong # of variables.");
        }
        this.variables = new ArrayList<Node>(variables);
        this.covMatrix.setVariables(variables);
    }

    @Override
    public ICovarianceMatrix getCov() {
        return this.covMatrix;
    }

    @Override
    public List<DataSet> getDataSets() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        dataSets.add(this.dataSet);
        return dataSets;
    }

    @Override
    public int getSampleSize() {
        return this.covMatrix.getSampleSize();
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.getPValue();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

