/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.TeyssierScorer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class Individual
implements Comparable<Individual> {
    private final double fitness;
    private final List<Node> genes;
    private final TeyssierScorer scorer;

    public Individual(Score score, List<Node> genes) {
        this.scorer = new TeyssierScorer(null, score);
        this.genes = genes;
        this.fitness = this.scorer.score(this.genes);
    }

    public double getFitness() {
        return this.fitness;
    }

    public int getLength() {
        return this.genes.size();
    }

    public List<Node> getGenes() {
        return new ArrayList<Node>(this.genes);
    }

    @Override
    public int compareTo(@NotNull Individual o) {
        return Double.compare(o.getFitness(), this.getFitness());
    }

    public Graph getGraph(boolean cpdag) {
        return this.scorer.getGraph(cpdag);
    }
}

