/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.RandomUtil;
import org.apache.commons.math3.util.FastMath;

public class InverseCorrelation {
    private final DataSet data;
    private final double threshold;

    public InverseCorrelation(DataSet dataSet, double threshold) {
        this.data = dataSet;
        this.threshold = threshold;
    }

    public Graph search() {
        CovarianceMatrix cov = new CovarianceMatrix(this.data);
        Matrix _data = cov.getMatrix();
        Matrix inverse = _data.inverse();
        System.out.println(inverse);
        EdgeListGraph graph = new EdgeListGraph(this.data.getVariables());
        for (int i = 0; i < inverse.rows(); ++i) {
            for (int j = i + 1; j < inverse.columns(); ++j) {
                int z;
                double a = inverse.get(i, j);
                double b = inverse.get(i, i);
                double c = inverse.get(j, j);
                double r = -a / FastMath.sqrt(b * c);
                int sampleSize = this.data.getNumRows();
                double fisherZ = FastMath.sqrt((double)(sampleSize - (z = this.data.getNumColumns())) - 3.0) * 0.5 * (FastMath.log(1.0 + r) - FastMath.log(1.0 - r));
                double p = this.getPValue(fisherZ);
                if (!(p < this.threshold)) continue;
                Node x = graph.getNodes().get(i);
                Node y = graph.getNodes().get(j);
                graph.addUndirectedEdge(x, y);
            }
        }
        return graph;
    }

    public double getPValue(double z) {
        return 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(z)));
    }
}

