/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphChange;
import edu.cmu.tetrad.search.IonHittingSet;
import edu.cmu.tetrad.search.PossibleDConnectingPath;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Ion2 {
    private boolean pathLengthSearch = true;
    private boolean adjacencySearch;
    private final List<Graph> input = new ArrayList<Graph>();
    private final List<Graph> output = new ArrayList<Graph>();
    private final List<String> variables = new ArrayList<String>();
    private final Set<Triple> definiteNoncolliders = new HashSet<Triple>();
    private Set<IonIndependenceFacts> separations;
    private boolean changeFlag = true;
    private final Set<Graph> discrimGraphs = new HashSet<Graph>();
    private final Set<Graph> finalResult = new HashSet<Graph>();
    private final List<Integer> recGraphs = new ArrayList<Integer>();
    private final List<Double> recHitTimes = new ArrayList<Double>();
    private double runtime;
    private double maxMemory;
    private Knowledge knowledge = new Knowledge();

    public Ion2(List<Graph> pags) {
        this.input.addAll(pags);
        for (Graph pag : this.input) {
            for (Node node : pag.getNodes()) {
                if (this.variables.contains(node.getName())) continue;
                this.variables.add(node.getName());
            }
            for (Triple triple : this.getAllTriples(pag)) {
                if (!pag.isDefNoncollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                pag.underlines().addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
    }

    public void setPathLengthSearch(boolean b) {
        this.pathLengthSearch = b;
    }

    public void setAdjacencySearch(boolean b) {
        this.adjacencySearch = b;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Knowledge must not be null.");
        }
        this.knowledge = knowledge;
    }

    public List<Graph> search() {
        double currentUsage;
        long start = MillisecondTimes.timeMillis();
        TetradLogger.getInstance().log("info", "Starting ION Search.");
        this.logGraphs("\nInitial Pags: ", this.input);
        TetradLogger.getInstance().log("info", "Transfering local information.");
        long steps = MillisecondTimes.timeMillis();
        ArrayList<Node> varNodes = new ArrayList<Node>();
        for (String string : this.variables) {
            varNodes.add(new GraphNode(string));
        }
        EdgeListGraph graph = new EdgeListGraph(varNodes);
        this.transferLocal(graph);
        for (NodePair pair : this.nonIntersection(graph)) {
            graph.addEdge(new Edge(pair.getFirst(), pair.getSecond(), Endpoint.CIRCLE, Endpoint.CIRCLE));
        }
        TetradLogger.getInstance().log("info", "Steps 1-2: " + (double)(MillisecondTimes.timeMillis() - steps) / 1000.0 + "s");
        System.out.println("step2");
        System.out.println(graph);
        steps = MillisecondTimes.timeMillis();
        LinkedList<EdgeListGraph> linkedList = new LinkedList<EdgeListGraph>();
        linkedList.offer(graph);
        List<Set<IonIndependenceFacts>> sepAndAssoc = this.findSepAndAssoc(graph);
        this.separations = sepAndAssoc.get(0);
        Set<IonIndependenceFacts> associations = sepAndAssoc.get(1);
        HashSet<Graph> step3PagsSet = new HashSet<Graph>();
        HashSet<Graph> reject = new HashSet<Graph>();
        if (this.separations.isEmpty()) {
            step3PagsSet.add(graph);
        }
        int numNodes = graph.getNumNodes();
        int pl = numNodes - 1;
        if (this.pathLengthSearch) {
            pl = 2;
        }
        block2: for (int l = pl; l < numNodes; ++l) {
            if (this.pathLengthSearch) {
                TetradLogger.getInstance().log("info", "Braching over path lengths: " + l + " of " + (numNodes - 1));
            }
            int seps = this.separations.size();
            boolean currentSep = true;
            int numAdjacencies = this.separations.size();
            for (IonIndependenceFacts fact : this.separations) {
                if (this.adjacencySearch) {
                    TetradLogger.getInstance().log("info", "Braching over path nonadjacencies: 1 of " + numAdjacencies);
                }
                --seps;
                linkedList.addAll(step3PagsSet);
                this.recGraphs.add(linkedList.size());
                step3PagsSet.clear();
                while (!linkedList.isEmpty()) {
                    System.out.println("ION Step 3 size: " + linkedList.size());
                    currentUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    if (currentUsage > this.maxMemory) {
                        this.maxMemory = currentUsage;
                    }
                    Graph pag = (Graph)linkedList.poll();
                    ArrayList<PossibleDConnectingPath> dConnections = new ArrayList<PossibleDConnectingPath>();
                    if (this.adjacencySearch) {
                        for (Collection collection : fact.getZ()) {
                            if (this.pathLengthSearch) {
                                dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, fact.getX(), fact.getY(), collection, l));
                                continue;
                            }
                            dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, fact.getX(), fact.getY(), collection));
                        }
                    } else {
                        for (IonIndependenceFacts ionIndependenceFacts : this.separations) {
                            for (Collection collection : ionIndependenceFacts.getZ()) {
                                if (this.pathLengthSearch) {
                                    dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), collection, l));
                                    continue;
                                }
                                dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), collection));
                            }
                        }
                    }
                    if (dConnections.isEmpty()) {
                        step3PagsSet.add(pag);
                        continue;
                    }
                    HashMap<Collection<Node>, List<PossibleDConnectingPath>> paths = new HashMap<Collection<Node>, List<PossibleDConnectingPath>>();
                    for (PossibleDConnectingPath possibleDConnectingPath : dConnections) {
                        LinkedList<PossibleDConnectingPath> p = (LinkedList<PossibleDConnectingPath>)paths.get(possibleDConnectingPath.getConditions());
                        if (p == null) {
                            p = new LinkedList<PossibleDConnectingPath>();
                        }
                        p.add(possibleDConnectingPath);
                        paths.put(possibleDConnectingPath.getConditions(), p);
                    }
                    ArrayList<Set<GraphChange>> possibleChanges = new ArrayList<Set<GraphChange>>();
                    for (Set<GraphChange> changes : this.findChanges(paths)) {
                        HashSet<GraphChange> hashSet = new HashSet<GraphChange>();
                        for (GraphChange gc : changes) {
                            boolean okay = true;
                            for (Triple collider : gc.getColliders()) {
                                if (!pag.underlines().isUnderlineTriple(collider.getX(), collider.getY(), collider.getZ())) continue;
                                okay = false;
                                break;
                            }
                            if (!okay) continue;
                            for (Triple collider : gc.getNoncolliders()) {
                                if (!pag.isDefCollider(collider.getX(), collider.getY(), collider.getZ())) continue;
                                okay = false;
                                break;
                            }
                            if (!okay) continue;
                            hashSet.add(gc);
                        }
                        if (!hashSet.isEmpty()) {
                            possibleChanges.add(hashSet);
                            continue;
                        }
                        possibleChanges.clear();
                        break;
                    }
                    float f = MillisecondTimes.timeMillis();
                    List<GraphChange> hittingSets = IonHittingSet.findHittingSet(possibleChanges);
                    this.recHitTimes.add((double)((float)MillisecondTimes.timeMillis() - f) / 1000.0);
                    Iterator iterator = hittingSets.iterator();
                    while (iterator.hasNext()) {
                        Graph changed;
                        GraphChange gc = (GraphChange)iterator.next();
                        boolean badhittingset = false;
                        for (Edge edge : gc.getRemoves()) {
                            Node node1 = edge.getNode1();
                            Node node2 = edge.getNode2();
                            HashSet<Triple> triples = new HashSet<Triple>();
                            triples.addAll(gc.getColliders());
                            triples.addAll(gc.getNoncolliders());
                            if (triples.size() != gc.getColliders().size() + gc.getNoncolliders().size()) {
                                badhittingset = true;
                                break;
                            }
                            for (Triple triple : triples) {
                                if (node1.equals(triple.getY()) && (node2.equals(triple.getX()) || node2.equals(triple.getZ()))) {
                                    badhittingset = true;
                                    break;
                                }
                                if (!node2.equals(triple.getY()) || !node1.equals(triple.getX()) && !node1.equals(triple.getZ())) continue;
                                badhittingset = true;
                                break;
                            }
                            if (badhittingset) break;
                            for (NodePair pair : gc.getOrients()) {
                                if ((!node1.equals(pair.getFirst()) || !node2.equals(pair.getSecond())) && (!node2.equals(pair.getFirst()) || !node1.equals(pair.getSecond()))) continue;
                                badhittingset = true;
                                break;
                            }
                            if (!badhittingset) continue;
                            break;
                        }
                        if (!badhittingset) {
                            for (NodePair pair : gc.getOrients()) {
                                for (Triple triple : gc.getNoncolliders()) {
                                    if (pair.getSecond().equals(triple.getY())) {
                                        if (pair.getFirst().equals(triple.getX()) && pag.getEndpoint(triple.getZ(), triple.getY()).equals(Endpoint.ARROW)) {
                                            badhittingset = true;
                                            break;
                                        }
                                        if (pair.getFirst().equals(triple.getZ()) && pag.getEndpoint(triple.getX(), triple.getY()).equals(Endpoint.ARROW)) {
                                            badhittingset = true;
                                            break;
                                        }
                                    }
                                    if (!badhittingset) continue;
                                    break;
                                }
                                if (!badhittingset) continue;
                                break;
                            }
                        }
                        if (badhittingset || reject.contains(changed = gc.applyTo(pag)) || step3PagsSet.contains(changed)) continue;
                        if (this.predictsFalseIndependence(associations, changed) || changed.paths().existsDirectedCycle()) {
                            reject.add(changed);
                        }
                        step3PagsSet.add(changed);
                    }
                }
                if (this.adjacencySearch) continue;
                continue block2;
            }
        }
        TetradLogger.getInstance().log("info", "Step 3: " + (double)(MillisecondTimes.timeMillis() - steps) / 1000.0 + "s");
        LinkedList step3Pags = new LinkedList(step3PagsSet);
        steps = MillisecondTimes.timeMillis();
        Set<Graph> outputPags = new HashSet<Graph>();
        while (!step3Pags.isEmpty()) {
            Graph pag = (Graph)step3Pags.poll();
            HashMap<Edge, Boolean> necEdges = new HashMap<Edge, Boolean>();
            for (Edge edge : pag.getEdges()) {
                necEdges.put(edge, false);
            }
            block21: for (IonIndependenceFacts fact : associations) {
                for (List<Node> nodes : fact.getZ()) {
                    if (!nodes.isEmpty()) continue;
                    List<List<Node>> treks = Ion2.treks(pag, fact.x, fact.y);
                    if (treks.size() != 1) continue block21;
                    List trek = (List)treks.get(0);
                    ArrayList triples = new ArrayList();
                    for (int i = 1; i < trek.size(); ++i) {
                        necEdges.put(pag.getEdge((Node)trek.get(i - 1), (Node)trek.get(i)), true);
                        if (i == 1) continue;
                        pag.underlines().addUnderlineTriple((Node)trek.get(i - 2), (Node)trek.get(i - 1), (Node)trek.get(i));
                    }
                    continue block21;
                }
            }
            List<Graph> possRemovePags = this.possRemove(pag, necEdges);
            currentUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (currentUsage > this.maxMemory) {
                this.maxMemory = currentUsage;
            }
            for (Graph newPag : possRemovePags) {
                boolean elimTreks = false;
                block25: for (IonIndependenceFacts ionIndependenceFacts : associations) {
                    for (List<Node> list : ionIndependenceFacts.getZ()) {
                        if (!list.isEmpty()) continue;
                        if (!Ion2.treks(newPag, ionIndependenceFacts.x, ionIndependenceFacts.y).isEmpty()) continue block25;
                        elimTreks = true;
                        continue block25;
                    }
                }
                if (elimTreks) continue;
                outputPags.add(newPag);
            }
        }
        outputPags = this.removeMoreSpecific(outputPags);
        TetradLogger.getInstance().log("info", "Step 4: " + (double)(MillisecondTimes.timeMillis() - steps) / 1000.0 + "s");
        steps = MillisecondTimes.timeMillis();
        Set<Graph> outputSet = new HashSet<Graph>();
        for (Graph pag : outputPags) {
            HashSet<Triple> unshieldedPossibleColliders = new HashSet<Triple>();
            for (Triple triple : this.getPossibleTriples(pag)) {
                if (pag.isAdjacentTo(triple.getX(), triple.getZ())) continue;
                unshieldedPossibleColliders.add(triple);
            }
            PowerSet pset = new PowerSet(unshieldedPossibleColliders);
            for (Set set : pset) {
                EdgeListGraph newGraph = new EdgeListGraph(pag);
                for (Triple triple : set) {
                    newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
                    newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
                }
                this.doFinalOrientation(newGraph);
            }
            for (Graph outputPag : this.finalResult) {
                if (this.predictsFalseIndependence(associations, outputPag)) continue;
                HashSet<Triple> underlineTriples = new HashSet<Triple>(outputPag.underlines().getUnderLines());
                for (Triple triple : underlineTriples) {
                    outputPag.underlines().removeUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
                }
                outputSet.add(outputPag);
            }
        }
        outputSet = this.checkPaths(outputSet);
        this.output.addAll(outputSet);
        TetradLogger.getInstance().log("info", "Step 5: " + (double)(MillisecondTimes.timeMillis() - steps) / 1000.0 + "s");
        this.runtime = (double)(MillisecondTimes.timeMillis() - start) / 1000.0;
        this.logGraphs("\nReturning output (" + this.output.size() + " Graphs):", this.output);
        double currentUsage2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (currentUsage2 > this.maxMemory) {
            this.maxMemory = currentUsage2;
        }
        return this.output;
    }

    public List<String> getRuntime() {
        double totalhit = 0.0;
        double longesthit = 0.0;
        double averagehit = 0.0;
        for (Double i : this.recHitTimes) {
            totalhit += i.doubleValue();
            averagehit += i / (double)this.recHitTimes.size();
            if (!(i > longesthit)) continue;
            longesthit = i;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(Double.toString(this.runtime));
        list.add(Double.toString(totalhit));
        list.add(Double.toString(longesthit));
        list.add(Double.toString(averagehit));
        return list;
    }

    public double getMaxMemUsage() {
        return this.maxMemory;
    }

    public List<Integer> getIterations() {
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i / this.recGraphs.size();
            if (i <= largestit) continue;
            largestit = i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(totalit);
        list.add(largestit);
        list.add(averageit);
        return list;
    }

    public String getStats() {
        String stats = "Total running time:  " + this.runtime + "\\\\";
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i.intValue();
            if (i <= largestit) continue;
            largestit = i;
        }
        averageit /= this.recGraphs.size();
        double totalhit = 0.0;
        double longesthit = 0.0;
        double averagehit = 0.0;
        for (Double i : this.recHitTimes) {
            totalhit += i.doubleValue();
            averagehit += i / (double)this.recHitTimes.size();
            if (!(i > longesthit)) continue;
            longesthit = i;
        }
        stats = stats + "Total iterations in step 3:  " + totalit + "\\\\";
        stats = stats + "Largest set of iterations in step 3:  " + largestit + "\\\\";
        stats = stats + "Average iterations set in step 3:  " + averageit + "\\\\";
        stats = stats + "Total hitting sets calculation time:  " + totalhit + "\\\\";
        stats = stats + "Average hitting set calculation time:  " + averagehit + "\\\\";
        stats = stats + "Longest hitting set calculation time:  " + longesthit + "\\\\";
        return stats;
    }

    private void logGraphs(String message, List<? extends Graph> graphs) {
        if (message != null) {
            TetradLogger.getInstance().log("graph", message);
        }
        for (Graph graph : graphs) {
            TetradLogger.getInstance().log("graph", graph.toString());
        }
    }

    private List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private Set<NodePair> nonadjacencies(Graph graph) {
        HashSet<NodePair> nonadjacencies = new HashSet<NodePair>();
        for (Graph inputPag : this.input) {
            for (NodePair pair : this.allNodePairs(inputPag.getNodes())) {
                if (inputPag.isAdjacentTo(pair.getFirst(), pair.getSecond())) continue;
                nonadjacencies.add(new NodePair(graph.getNode(pair.getFirst().getName()), graph.getNode(pair.getSecond().getName())));
            }
        }
        return nonadjacencies;
    }

    private void transferLocal(Graph graph) {
        Set<NodePair> nonadjacencies = this.nonadjacencies(graph);
        for (Graph pag : this.input) {
            for (Edge edge : pag.getEdges()) {
                NodePair graphNodePair = new NodePair(graph.getNode(edge.getNode1().getName()), graph.getNode(edge.getNode2().getName()));
                if (nonadjacencies.contains(graphNodePair)) continue;
                if (!graph.isAdjacentTo(graphNodePair.getFirst(), graphNodePair.getSecond())) {
                    graph.addEdge(new Edge(graphNodePair.getFirst(), graphNodePair.getSecond(), edge.getEndpoint1(), edge.getEndpoint2()));
                    continue;
                }
                Endpoint first = edge.getEndpoint1();
                Endpoint firstCurrent = graph.getEndpoint(graphNodePair.getSecond(), graphNodePair.getFirst());
                if (!first.equals(Endpoint.CIRCLE)) {
                    if (first.equals(Endpoint.ARROW) && firstCurrent.equals(Endpoint.TAIL) || first.equals(Endpoint.TAIL) && firstCurrent.equals(Endpoint.ARROW)) {
                        graph.setEndpoint(graphNodePair.getSecond(), graphNodePair.getFirst(), Endpoint.CIRCLE);
                    } else {
                        graph.setEndpoint(graphNodePair.getSecond(), graphNodePair.getFirst(), edge.getEndpoint1());
                    }
                }
                Endpoint second = edge.getEndpoint2();
                Endpoint secondCurrent = graph.getEndpoint(graphNodePair.getFirst(), graphNodePair.getSecond());
                if (second.equals(Endpoint.CIRCLE)) continue;
                if (second.equals(Endpoint.ARROW) && secondCurrent.equals(Endpoint.TAIL) || second.equals(Endpoint.TAIL) && secondCurrent.equals(Endpoint.ARROW)) {
                    graph.setEndpoint(graphNodePair.getFirst(), graphNodePair.getSecond(), Endpoint.CIRCLE);
                    continue;
                }
                graph.setEndpoint(graphNodePair.getFirst(), graphNodePair.getSecond(), edge.getEndpoint2());
            }
            for (Triple triple : pag.underlines().getUnderLines()) {
                Triple graphTriple = new Triple(graph.getNode(triple.getX().getName()), graph.getNode(triple.getY().getName()), graph.getNode(triple.getZ().getName()));
                if (!graphTriple.alongPathIn(graph)) continue;
                graph.underlines().addUnderlineTriple(graphTriple.getX(), graphTriple.getY(), graphTriple.getZ());
                this.definiteNoncolliders.add(graphTriple);
            }
        }
    }

    private Set<Triple> getAllTriples(Graph graph) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : graph.getNodes()) {
            List<Node> adjNodes = graph.getAdjacentNodes(node);
            for (int i = 0; i < adjNodes.size() - 1; ++i) {
                for (int j = i + 1; j < adjNodes.size(); ++j) {
                    triples.add(new Triple(adjNodes.get(i), node, adjNodes.get(j)));
                }
            }
        }
        return triples;
    }

    private List<NodePair> nonIntersection(Graph graph) {
        ArrayList varsets = new ArrayList();
        for (Graph inputPag : this.input) {
            HashSet<String> varset = new HashSet<String>();
            for (Node node : inputPag.getNodes()) {
                varset.add(node.getName());
            }
            varsets.add(varset);
        }
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (int i = 0; i < this.variables.size() - 1; ++i) {
            for (int j = i + 1; j < this.variables.size(); ++j) {
                boolean intersection = false;
                for (Set set : varsets) {
                    if (!set.containsAll(Arrays.asList(this.variables.get(i), this.variables.get(j)))) continue;
                    intersection = true;
                    break;
                }
                if (intersection) continue;
                pairs.add(new NodePair(graph.getNode(this.variables.get(i)), graph.getNode(this.variables.get(j))));
            }
        }
        return pairs;
    }

    private List<Set<IonIndependenceFacts>> findSepAndAssoc(Graph graph) {
        HashSet<IonIndependenceFacts> separations = new HashSet<IonIndependenceFacts>();
        HashSet<IonIndependenceFacts> associations = new HashSet<IonIndependenceFacts>();
        List<NodePair> allNodes = this.allNodePairs(graph.getNodes());
        for (NodePair pair : allNodes) {
            Node x = pair.getFirst();
            Node y = pair.getSecond();
            ArrayList<Node> variables = new ArrayList<Node>(graph.getNodes());
            variables.remove(x);
            variables.remove(y);
            List<Set<Node>> subsets = SearchGraphUtils.powerSet(variables);
            IonIndependenceFacts indep = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            IonIndependenceFacts assoc = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            boolean addIndep = false;
            boolean addAssoc = false;
            for (Graph pag : this.input) {
                for (Set<Node> subset : subsets) {
                    if (!this.containsAll(pag, subset, pair)) continue;
                    Node pagX = pag.getNode(x.getName());
                    Node pagY = pag.getNode(y.getName());
                    ArrayList<Node> pagSubset = new ArrayList<Node>();
                    for (Node node : subset) {
                        pagSubset.add(pag.getNode(node.getName()));
                    }
                    if (pag.paths().isDSeparatedFrom(pagX, pagY, new ArrayList<Node>(pagSubset))) {
                        if (pag.isAdjacentTo(pagX, pagY)) continue;
                        addIndep = true;
                        indep.addMoreZ(new ArrayList<Node>(subset));
                        continue;
                    }
                    addAssoc = true;
                    assoc.addMoreZ(new ArrayList<Node>(subset));
                }
            }
            if (addIndep) {
                separations.add(indep);
            }
            if (!addAssoc) continue;
            associations.add(assoc);
        }
        ArrayList<Set<IonIndependenceFacts>> facts = new ArrayList<Set<IonIndependenceFacts>>(2);
        facts.add(0, separations);
        facts.add(1, associations);
        return facts;
    }

    private boolean containsAll(Graph g, Set<Node> nodes, NodePair pair) {
        List<String> nodeNames = g.getNodeNames();
        if (!nodeNames.contains(pair.getFirst().getName()) || !nodeNames.contains(pair.getSecond().getName())) {
            return false;
        }
        for (Node node : nodes) {
            if (nodeNames.contains(node.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean predictsFalseIndependence(Set<IonIndependenceFacts> associations, Graph pag) {
        for (IonIndependenceFacts assocFact : associations) {
            for (List<Node> conditioningSet : assocFact.getZ()) {
                if (!pag.paths().isDSeparatedFrom(assocFact.getX(), assocFact.getY(), conditioningSet)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Triple> getPossibleTriples(Graph pag) {
        HashSet<Triple> possibleTriples = new HashSet<Triple>();
        for (Triple triple : this.getAllTriples(pag)) {
            if (!pag.isAdjacentTo(triple.getX(), triple.getY()) || !pag.isAdjacentTo(triple.getY(), triple.getZ()) || pag.underlines().isUnderlineTriple(triple.getX(), triple.getY(), triple.getZ()) || this.definiteNoncolliders.contains(triple) || pag.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
            possibleTriples.add(triple);
        }
        return possibleTriples;
    }

    private List<Set<GraphChange>> findChanges(Map<Collection<Node>, List<PossibleDConnectingPath>> paths) {
        ArrayList<Set<GraphChange>> pagChanges = new ArrayList<Set<GraphChange>>();
        Set<Map.Entry<Collection<Node>, List<PossibleDConnectingPath>>> entries = paths.entrySet();
        for (Map.Entry<Collection<Node>, List<PossibleDConnectingPath>> entry : entries) {
            Collection<Node> conditions = entry.getKey();
            List<PossibleDConnectingPath> dConnecting = entry.getValue();
            for (PossibleDConnectingPath possible : dConnecting) {
                List<Node> possPath = possible.getPath();
                HashSet<GraphChange> pathChanges = new HashSet<GraphChange>(2 * possPath.size());
                ArrayList<Node> outsidePath = new ArrayList<Node>(conditions.size());
                for (Node condition : conditions) {
                    if (possPath.contains(condition)) continue;
                    outsidePath.add(condition);
                }
                for (int i = 0; i < possPath.size() - 1; ++i) {
                    Node current = possPath.get(i);
                    Node next = possPath.get(i + 1);
                    GraphChange gc = new GraphChange();
                    gc.addRemove(possible.getPag().getEdge(current, next));
                    pathChanges.add(gc);
                    if (conditions.contains(current) && i > 0) {
                        gc = new GraphChange();
                        Triple nonColider = new Triple(possPath.get(i - 1), current, next);
                        gc.addNonCollider(nonColider);
                        pathChanges.add(gc);
                    }
                    if (conditions.contains(current) || i <= 0) continue;
                    Triple colider = new Triple(possPath.get(i - 1), current, next);
                    if (possible.getPag().underlines().isUnderlineTriple(possPath.get(i - 1), current, next)) continue;
                    Edge edge1 = possible.getPag().getEdge(colider.getX(), colider.getY());
                    Edge edge2 = possible.getPag().getEdge(colider.getZ(), colider.getY());
                    if (!edge1.getNode1().equals(colider.getY()) ? edge1.getNode2().equals(colider.getY()) && edge1.getEndpoint2().equals(Endpoint.TAIL) : edge1.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (!edge2.getNode1().equals(colider.getY()) ? edge2.getNode2().equals(colider.getY()) && edge2.getEndpoint2().equals(Endpoint.TAIL) : edge2.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (outsidePath.size() == 0) {
                        gc = new GraphChange();
                        gc.addCollider(colider);
                        pathChanges.add(gc);
                        continue;
                    }
                    for (Node outside : outsidePath) {
                        List<Object> decendantPaths = new ArrayList();
                        decendantPaths = PossibleDConnectingPath.findDConnectingPaths(possible.getPag(), current, outside, new ArrayList<Node>());
                        if (decendantPaths.isEmpty()) {
                            gc = new GraphChange();
                            gc.addCollider(colider);
                            pathChanges.add(gc);
                            continue;
                        }
                        for (PossibleDConnectingPath possibleDConnectingPath : decendantPaths) {
                            List<Node> decendantPath = possibleDConnectingPath.getPath();
                            boolean impliesDecendant = true;
                            HashSet<GraphChange> colideChanges = new HashSet<GraphChange>();
                            for (int j = 0; j < decendantPath.size() - 1; ++j) {
                                Node from = decendantPath.get(j);
                                Node to = decendantPath.get(j + 1);
                                Edge currentEdge = possible.getPag().getEdge(from, to);
                                if (currentEdge.getEndpoint1().equals(Endpoint.ARROW)) {
                                    impliesDecendant = false;
                                    break;
                                }
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addRemove(currentEdge);
                                colideChanges.add(gc);
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addOrient(to, from);
                                colideChanges.add(gc);
                            }
                            if (!impliesDecendant) continue;
                            pathChanges.addAll(colideChanges);
                        }
                    }
                }
                pagChanges.add(pathChanges);
            }
        }
        return pagChanges;
    }

    private List<Graph> possRemove(Graph pag, Map<Edge, Boolean> necEdges) {
        ArrayList<Edge> remEdges = new ArrayList<Edge>();
        for (Edge remEdge : necEdges.keySet()) {
            if (necEdges.get(remEdge).booleanValue()) continue;
            remEdges.add(remEdge);
        }
        PowerSet pset = new PowerSet(remEdges);
        ArrayList<Graph> possRemove = new ArrayList<Graph>();
        for (Set set : pset) {
            EdgeListGraph newPag = new EdgeListGraph(pag);
            for (Edge edge : set) {
                newPag.removeEdge(edge);
            }
            possRemove.add(newPag);
        }
        return possRemove;
    }

    private void doFinalOrientation(Graph graph) {
        this.discrimGraphs.clear();
        HashSet<Graph> currentDiscrimGraphs = new HashSet<Graph>();
        currentDiscrimGraphs.add(graph);
        while (this.changeFlag) {
            this.changeFlag = false;
            currentDiscrimGraphs.addAll(this.discrimGraphs);
            this.discrimGraphs.clear();
            for (Graph newGraph : currentDiscrimGraphs) {
                this.doubleTriangle(newGraph);
                this.awayFromColliderAncestorCycle(newGraph);
                if (this.discrimPaths(newGraph)) continue;
                if (this.changeFlag) {
                    this.discrimGraphs.add(newGraph);
                    continue;
                }
                this.finalResult.add(newGraph);
            }
            currentDiscrimGraphs.clear();
        }
        this.changeFlag = true;
    }

    private void doubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C) || !this.isArrowpointAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromAncestorCycle(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            List<Node> nodes = graph.getNodes();
            for (Node B : nodes) {
                int[] combination;
                List<Node> adj = graph.getAdjacentNodes(B);
                if (adj.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node A = adj.get(combination[0]);
                    Node C = adj.get(combination[1]);
                    this.awayFromAncestor(graph, A, B, C);
                    this.awayFromAncestor(graph, C, B, A);
                    this.awayFromCycle(graph, A, B, C);
                    this.awayFromCycle(graph, C, B, A);
                }
            }
        }
        this.changeFlag = true;
    }

    private void awayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.ruleR1(A, B, C, graph);
                this.ruleR1(C, B, A, graph);
                this.ruleR2(A, B, C, graph);
                this.ruleR2(C, B, A, graph);
            }
        }
    }

    private void ruleR1(Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(a, c)) {
            return;
        }
        if (graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(graph, b, c)) {
                return;
            }
            graph.setEndpoint(c, b, Endpoint.TAIL);
            graph.setEndpoint(b, c, Endpoint.ARROW);
        }
    }

    private void ruleR2(Node a, Node b, Node c, Graph graph) {
        if (!graph.isAdjacentTo(a, c)) {
            return;
        }
        if (graph.getEndpoint(b, a) == Endpoint.TAIL && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && graph.getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
        } else if (graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.TAIL && graph.getEndpoint(b, c) == Endpoint.ARROW && graph.getEndpoint(a, c) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
        }
    }

    private boolean isArrowpointAllowed(Graph graph, Node x, Node y) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW) {
            graph.getEndpoint(x, y);
        }
        return true;
    }

    private void awayFromCollider(Graph graph, Node a, Node b, Node c) {
        Endpoint BC = graph.getEndpoint(b, c);
        Endpoint CB = graph.getEndpoint(c, b);
        if (!graph.isAdjacentTo(a, c) && graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowpointAllowed(graph, b, c)) {
                    return;
                }
                graph.setEndpoint(b, c, Endpoint.ARROW);
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.ARROW && graph.getEndpoint(c, a) == Endpoint.CIRCLE && graph.paths().isDirectedFromTo(a, b) && graph.paths().isDirectedFromTo(b, c)) {
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
        }
    }

    private boolean discrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    if (!this.reachablePathFindOrient(graph, a, b, c, reachable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean reachablePathFindOrient(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(graph, l, a, b, c);
                    return true;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
        return false;
    }

    private void doDdpOrientation(Graph graph, Node l, Node a, Node b, Node c) {
        this.changeFlag = true;
        for (IonIndependenceFacts iif : this.separations) {
            if ((!iif.getX().equals(l) || !iif.getY().equals(c)) && (!iif.getY().equals(l) || !iif.getX().equals(c))) continue;
            for (List<Node> condSet : iif.getZ()) {
                if (!condSet.contains(b)) continue;
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.discrimGraphs.add(graph);
                return;
            }
        }
        EdgeListGraph newGraph1 = new EdgeListGraph(graph);
        newGraph1.setEndpoint(a, b, Endpoint.ARROW);
        newGraph1.setEndpoint(c, b, Endpoint.ARROW);
        this.discrimGraphs.add(newGraph1);
        EdgeListGraph newGraph2 = new EdgeListGraph(graph);
        newGraph2.setEndpoint(c, b, Endpoint.TAIL);
        this.discrimGraphs.add(newGraph2);
    }

    private Set<Graph> removeMoreSpecific(Set<Graph> outputPags) {
        HashSet<Graph> moreSpecific = new HashSet<Graph>();
        block0: for (Graph pag : outputPags) {
            for (Graph pag2 : outputPags) {
                if (pag.equals(pag2) || pag.getEdges().size() != pag2.getEdges().size()) continue;
                boolean sameAdjacencies = true;
                for (Edge edge1 : pag.getEdges()) {
                    if (pag2.isAdjacentTo(edge1.getNode1(), edge1.getNode2())) continue;
                    sameAdjacencies = false;
                }
                if (!sameAdjacencies) continue;
                boolean arrowstails = true;
                boolean circles = true;
                for (Edge edge2 : pag2.getEdges()) {
                    Edge edge1 = pag.getEdge(edge2.getNode1(), edge2.getNode2());
                    if (edge1.getNode1().equals(edge2.getNode1())) {
                        if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                            if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                                arrowstails = false;
                            }
                        } else if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                            circles = false;
                        }
                        if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                            if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                            arrowstails = false;
                            continue;
                        }
                        if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                        circles = false;
                        continue;
                    }
                    if (!edge1.getNode1().equals(edge2.getNode2())) continue;
                    if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                        if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                            arrowstails = false;
                        }
                    } else if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                        circles = false;
                    }
                    if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                        if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                        arrowstails = false;
                        continue;
                    }
                    if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                    circles = false;
                }
                if (!arrowstails || circles) continue;
                moreSpecific.add(pag);
                continue block0;
            }
        }
        for (Graph pag : moreSpecific) {
            outputPags.remove(pag);
        }
        return outputPags;
    }

    private Set<Graph> checkPaths(Set<Graph> pags) {
        HashSet<Graph> pagsOut = new HashSet<Graph>();
        for (Graph pag : pags) {
            boolean allAccountFor = true;
            block1: for (Graph inGraph : this.input) {
                for (Edge edge : inGraph.getEdges()) {
                    Node node1 = pag.getNode(edge.getNode1().getName());
                    Node node2 = pag.getNode(edge.getNode2().getName());
                    if (Edges.isDirectedEdge(edge) && !pag.paths().existsSemiDirectedPathFromTo(node1, Collections.singleton(node2))) {
                        allAccountFor = false;
                        break block1;
                    }
                    if (!Edges.isPartiallyOrientedEdge(edge) || !pag.paths().existsSemiDirectedPathFromTo(node2, Collections.singleton(node1))) continue;
                    allAccountFor = false;
                    break block1;
                }
            }
            if (!allAccountFor) continue;
            pagsOut.add(pag);
        }
        return pagsOut;
    }

    public static List<List<Node>> treks(Graph graph, Node node1, Node node2) {
        LinkedList<List<Node>> paths = new LinkedList<List<Node>>();
        Ion2.treks(graph, node1, node2, new LinkedList<Node>(), paths);
        return paths;
    }

    private static void treks(Graph graph, Node node1, Node node2, LinkedList<Node> path, List<List<Node>> paths) {
        path.addLast(node1);
        for (Edge edge : graph.getEdges(node1)) {
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (next == null || path.size() > 1 && (next == (node0 = path.get(path.size() - 2)) || graph.isDefCollider(node0, node1, next))) continue;
            if (next == node2) {
                LinkedList<Node> _path = new LinkedList<Node>(path);
                _path.add(next);
                paths.add(_path);
                continue;
            }
            if (path.contains(next)) continue;
            Ion2.treks(graph, next, node2, path, paths);
        }
        path.removeLast();
    }

    private Graph screenForKnowledge(Graph pag) {
        Edge edge;
        KnowledgeEdge next;
        Iterator<KnowledgeEdge> it = this.knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            next = it.next();
            Node y = pag.getNode(next.getFrom());
            Node x = pag.getNode(next.getTo());
            if (x == null || y == null || (edge = pag.getEdge(x, y)) == null) continue;
            if (edge.getProximalEndpoint(x) == Endpoint.ARROW && edge.getProximalEndpoint(y) == Endpoint.TAIL) {
                return null;
            }
            if (edge.getProximalEndpoint(x) == Endpoint.ARROW && edge.getProximalEndpoint(y) == Endpoint.CIRCLE) {
                pag.removeEdge(edge);
                pag.addEdge(Edges.bidirectedEdge(x, y));
                continue;
            }
            if (edge.getProximalEndpoint(x) != Endpoint.CIRCLE || edge.getProximalEndpoint(y) != Endpoint.CIRCLE) continue;
            pag.removeEdge(edge);
            pag.addEdge(Edges.partiallyOrientedEdge(x, y));
        }
        it = this.knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            next = it.next();
            Node x = pag.getNode(next.getFrom());
            Node y = pag.getNode(next.getTo());
            if (x == null || y == null) continue;
            edge = pag.getEdge(x, y);
            if (edge == null) {
                return null;
            }
            if (edge.getProximalEndpoint(x) == Endpoint.ARROW && edge.getProximalEndpoint(y) == Endpoint.TAIL) {
                return null;
            }
            if (edge.getProximalEndpoint(x) == Endpoint.ARROW && edge.getProximalEndpoint(y) == Endpoint.CIRCLE) {
                return null;
            }
            if (edge.getProximalEndpoint(x) == Endpoint.CIRCLE && edge.getProximalEndpoint(y) == Endpoint.ARROW) {
                pag.removeEdge(edge);
                pag.addEdge(Edges.directedEdge(x, y));
                continue;
            }
            if (edge.getProximalEndpoint(x) != Endpoint.CIRCLE || edge.getProximalEndpoint(y) != Endpoint.CIRCLE) continue;
            pag.removeEdge(edge);
            pag.addEdge(Edges.directedEdge(x, y));
        }
        return pag;
    }

    private Set<Graph> applyKnowledge(Set<Graph> outputSet) {
        HashSet<Graph> _out = new HashSet<Graph>();
        for (Graph graph : outputSet) {
            Graph _graph = this.screenForKnowledge(graph);
            if (_graph == null) continue;
            _out.add(_graph);
        }
        return _out;
    }

    private static final class IonIndependenceFacts {
        private final Node x;
        private final Node y;
        private final Collection<List<Node>> z;

        public IonIndependenceFacts(Node x, Node y, Collection<List<Node>> z) {
            if (x == null || y == null || z == null) {
                throw new NullPointerException();
            }
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Node getX() {
            return this.x;
        }

        public Node getY() {
            return this.y;
        }

        public Collection<List<Node>> getZ() {
            return this.z;
        }

        public void addMoreZ(List<Node> moreZ) {
            this.z.add(moreZ);
        }

        public int hashCode() {
            int hash = 17;
            hash += 19 * this.x.hashCode() * this.y.hashCode();
            return hash += 23 * this.z.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IonIndependenceFacts)) {
                return false;
            }
            IonIndependenceFacts fact = (IonIndependenceFacts)obj;
            return this.x.equals(fact.x) && this.y.equals(fact.y) && this.z.equals(fact.z) || this.x.equals(fact.y) & this.y.equals(fact.x) && this.z.equals(fact.z);
        }

        public String toString() {
            return "I(" + this.x + ", " + this.y + " | " + this.z + ")";
        }
    }

    private static class PowerSet<E>
    implements Iterable<Set<E>> {
        Collection<E> all;

        public PowerSet(Collection<E> all) {
            this.all = all;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new PowerSetIterator(this);
        }

        static class PowerSetIterator<InE>
        implements Iterator<Set<InE>> {
            PowerSet<InE> powerSet;
            List<InE> canonicalOrder = new ArrayList<InE>();
            List<InE> mask = new ArrayList<InE>();
            boolean hasNext = true;

            PowerSetIterator(PowerSet<InE> powerSet) {
                this.powerSet = powerSet;
                this.canonicalOrder.addAll(powerSet.all);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean allOnes() {
                for (InE bit : this.mask) {
                    if (bit != null) continue;
                    return false;
                }
                return true;
            }

            private void increment() {
                int i;
                for (i = 0; i < this.mask.size(); ++i) {
                    InE bit = this.mask.get(i);
                    if (bit == null) {
                        this.mask.set(i, this.canonicalOrder.get(i));
                        return;
                    }
                    this.mask.set(i, null);
                }
                this.mask.add(this.canonicalOrder.get(i));
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Set<InE> next() {
                HashSet<InE> result = new HashSet<InE>(this.mask);
                result.remove(null);
                boolean bl = this.hasNext = this.mask.size() < this.powerSet.all.size() || !this.allOnes();
                if (this.hasNext) {
                    this.increment();
                }
                return result;
            }
        }
    }
}

