/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.LegalPairs;
import java.util.List;

class IonLegalPairs
implements LegalPairs {
    private final Graph graph;

    public IonLegalPairs(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    @Override
    public boolean isLegalFirstEdge(Node x, Node y) {
        return this.graph.isAdjacentTo(x, y);
    }

    @Override
    public boolean isLegalPair(Node x, Node y, Node z, List<Node> c, List<Node> d) {
        if (!this.graph.isAdjacentTo(x, y) || !this.graph.isAdjacentTo(y, z)) {
            throw new IllegalArgumentException();
        }
        if (this.graph.isDefCollider(x, y, x) || this.graph.isAdjacentTo(x, z)) {
            return true;
        }
        return this.graph.underlines().isUnderlineTriple(x, y, z);
    }
}

