/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.util.Matrix;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class KimEtAlScores
implements Score {
    private DataSet dataSet;
    private ICovarianceMatrix covariances;
    private List<Node> variables;
    private final int sampleSize;
    private boolean verbose = false;
    private RuleType ruleType = RuleType.MANUAL;
    private double N;
    private double lambda;
    private boolean calculateRowSubsets = false;
    Matrix data;
    private double penaltyDiscount = 1.0;

    public KimEtAlScores(ICovarianceMatrix covariances) {
        if (covariances == null) {
            throw new NullPointerException();
        }
        this.setCovariances(covariances);
        this.variables = covariances.getVariables();
        this.sampleSize = covariances.getSampleSize();
        this.setLambda(FastMath.log(this.sampleSize));
    }

    public KimEtAlScores(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        ICovarianceMatrix covarianceMatrix = SimpleDataLoader.getCovarianceMatrix(dataSet);
        this.data = dataSet.getDoubleData();
        this.dataSet = dataSet;
        if (!dataSet.existsMissingValue()) {
            this.setCovariances(covarianceMatrix);
            this.variables = this.covariances.getVariables();
            this.sampleSize = this.covariances.getSampleSize();
            this.calculateRowSubsets = false;
            return;
        }
        this.variables = dataSet.getVariables();
        this.sampleSize = dataSet.getNumRows();
        this.calculateRowSubsets = true;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, KimEtAlScores.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int ... parents) {
        double lambda;
        double sn = 12.0;
        if ((double)parents.length > sn) {
            return Double.NEGATIVE_INFINITY;
        }
        int k = parents.length;
        double pn = this.variables.size();
        pn = FastMath.min(pn, sn);
        double n = this.N;
        double varry = SemBicScore.getVarRy(i, parents, this.data, this.covariances, this.calculateRowSubsets);
        if (this.ruleType == RuleType.MANUAL) {
            lambda = this.lambda;
        } else if (this.ruleType == RuleType.BIC) {
            lambda = FastMath.log(n);
        } else if (this.ruleType == RuleType.GIC2) {
            lambda = FastMath.pow(n, 0.33);
        } else if (this.ruleType == RuleType.RIC) {
            lambda = 2.2 * FastMath.log(pn);
        } else if (this.ruleType == RuleType.RICc) {
            lambda = 2.0 * (FastMath.log(pn) + FastMath.log(FastMath.log(pn)));
        } else if (this.ruleType == RuleType.GIC5) {
            lambda = FastMath.log(FastMath.log(n)) * FastMath.log(pn);
        } else if (this.ruleType == RuleType.GIC6) {
            lambda = FastMath.log(n) * FastMath.log(pn);
        } else {
            throw new IllegalStateException("That lambda rule is not configured: " + (Object)((Object)this.ruleType));
        }
        boolean takeLog = true;
        if (takeLog) {
            return -(n / 2.0) * FastMath.log(varry) - lambda * this.getPenaltyDiscount() * (double)k;
        }
        double trueErrorVariance = 1.0;
        return -(n / 2.0) * varry - lambda * this.getPenaltyDiscount() * (double)k * trueErrorVariance;
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    public ICovarianceMatrix getCovariances() {
        return this.covariances;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Node> variables) {
        if (this.covariances != null) {
            this.covariances.setVariables(variables);
        }
        this.variables = variables;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.sampleSize));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        int i = this.variables.indexOf(y);
        int[] k = new int[z.size()];
        for (int t = 0; t < z.size(); ++t) {
            k[t] = this.variables.indexOf(z.get(t));
        }
        double v = this.localScore(i, k);
        return Double.isNaN(v);
    }

    private void setCovariances(ICovarianceMatrix covariances) {
        this.covariances = covariances;
        this.N = covariances.getSampleSize();
    }

    private static int[] append(int[] z, int x) {
        int[] _z = Arrays.copyOf(z, z.length + 1);
        _z[z.length] = x;
        return _z;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public static enum RuleType {
        MANUAL,
        BIC,
        NANDY,
        GIC2,
        RIC,
        RICc,
        GIC5,
        GIC6;

    }
}

