/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphGroup;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FastIca;
import edu.cmu.tetrad.search.GraphWithParameters;
import edu.cmu.tetrad.search.PermutationMatrixPair;
import edu.cmu.tetrad.util.LingUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.GaussianPower;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.PowellOptimizer;
import org.apache.commons.math3.util.FastMath;

public class Ling {
    private int numSamples;
    private double threshold = 0.5;
    private long elapsedTime;
    private DataSet dataSet;

    public Ling(DataSet d) {
        this.dataSet = d;
    }

    public Ling(GraphWithParameters graphWP, int samples) {
        this.numSamples = samples;
        this.makeDataSet(graphWP);
    }

    public Ling(Graph g, int samples) {
        this.numSamples = samples;
        GraphWithParameters graphWP = new GraphWithParameters(g);
        this.makeDataSet(graphWP);
    }

    public DataSet getData() {
        return this.dataSet;
    }

    public StoredGraphs search() {
        StoredGraphs graphs = new StoredGraphs();
        try {
            long sTime = new Date().getTime();
            boolean fastIca = true;
            Matrix W = this.getWFastIca();
            System.out.println("W = " + W);
            graphs = this.findCandidateModels(this.dataSet.getVariables(), W);
            this.elapsedTime = new Date().getTime() - sTime;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return graphs;
    }

    private Matrix estimateW(Matrix matrix, int numNodes, List<Mapping> allMappings) {
        Matrix W = this.initializeW(numNodes);
        this.maxMappings(matrix, W, allMappings);
        return W;
    }

    private void maxMappings(Matrix matrix, Matrix W, List<Mapping> allMappings) {
        int numNodes = W.rows();
        for (int i = 0; i < numNodes; ++i) {
            int k;
            double maxScore = Double.NEGATIVE_INFINITY;
            double[] maxRow = new double[numNodes];
            for (Mapping mapping : this.mappingsForRow(i, allMappings)) {
                W.set(mapping.getI(), mapping.getJ(), 0.0);
            }
            try {
                this.optimizeNonGaussianity(i, matrix, W, allMappings);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                continue;
            }
            double v = this.ngFullData(i, matrix, W);
            if (Double.isNaN(v) || v >= 9999.0) continue;
            double[] row = new double[numNodes];
            for (k = 0; k < numNodes; ++k) {
                row[k] = W.get(i, k);
            }
            if (v > Double.NEGATIVE_INFINITY) {
                maxRow = row;
            }
            for (k = 0; k < numNodes; ++k) {
                W.set(i, k, maxRow[k]);
            }
        }
    }

    private void optimizeNonGaussianity(int rowIndex, Matrix dataSetTetradMatrix, Matrix W, List<Mapping> allMappings) {
        List<Mapping> mappings = this.mappingsForRow(rowIndex, allMappings);
        MultivariateFunction function = values -> {
            for (int i = 0; i < values.length; ++i) {
                Mapping mapping = (Mapping)mappings.get(i);
                W.set(mapping.getI(), mapping.getJ(), values[i]);
            }
            double v = this.ngFullData(rowIndex, dataSetTetradMatrix, W);
            if (Double.isNaN(v)) {
                return 10000.0;
            }
            return -v;
        };
        double[] values2 = new double[mappings.size()];
        for (int k = 0; k < mappings.size(); ++k) {
            Mapping mapping = mappings.get(k);
            values2[k] = W.get(mapping.getI(), mapping.getJ());
        }
        PowellOptimizer search = new PowellOptimizer(1.0E-7, 1.0E-7);
        PointValuePair pair = search.optimize(new InitialGuess(values2), new ObjectiveFunction(function), GoalType.MINIMIZE, new MaxEval(100000));
        values2 = pair.getPoint();
        for (int k = 0; k < mappings.size(); ++k) {
            Mapping mapping = mappings.get(k);
            W.set(mapping.getI(), mapping.getJ(), values2[k]);
        }
    }

    public double ngFullData(int rowIndex, Matrix data, Matrix W) {
        double[] col = new double[data.rows()];
        for (int i = 0; i < data.rows(); ++i) {
            double d = 0.0;
            for (int j = 0; j < data.columns(); ++j) {
                double coef = W.get(rowIndex, j);
                double value = data.get(i, j);
                d += coef * value;
            }
            col[i] = d;
        }
        if ((col = this.removeNaN(col)).length == 0) {
            System.out.println();
            return Double.NaN;
        }
        double sum = 0.0;
        for (double v : col) {
            sum += FastMath.log(FastMath.cosh(v));
        }
        return sum / (double)col.length;
    }

    private double[] removeNaN(double[] data) {
        ArrayList<Double> _leaveOutMissing = new ArrayList<Double>();
        for (double datum : data) {
            if (Double.isNaN(datum)) continue;
            _leaveOutMissing.add(datum);
        }
        double[] _data = new double[_leaveOutMissing.size()];
        for (int i = 0; i < _leaveOutMissing.size(); ++i) {
            _data[i] = (Double)_leaveOutMissing.get(i);
        }
        return _data;
    }

    private List<Mapping> mappingsForRow(int rowIndex, List<Mapping> allMappings) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (Mapping mapping : allMappings) {
            if (mapping.getI() != rowIndex) continue;
            mappings.add(mapping);
        }
        return mappings;
    }

    private Matrix initializeW(int numNodes) {
        Matrix W = new Matrix(numNodes, numNodes);
        for (int i = 0; i < numNodes; ++i) {
            for (int j = 0; j < numNodes; ++j) {
                if (i == j) {
                    W.set(i, j, 1.0);
                    continue;
                }
                W.set(i, j, 0.0);
            }
        }
        return W;
    }

    private List<Mapping> createMappings(int numNodes) {
        ArrayList<Mapping> allMappings = new ArrayList<Mapping>();
        for (int i = 0; i < numNodes; ++i) {
            for (int j = 0; j < numNodes; ++j) {
                if (i == j) continue;
                allMappings.add(new Mapping(i, j));
            }
        }
        return allMappings;
    }

    private Matrix getWFastIca() {
        Matrix data = new Matrix(this.dataSet.getDoubleData().toArray()).transpose();
        FastIca fastIca = new FastIca(data, 30);
        fastIca.setVerbose(false);
        fastIca.setAlgorithmType(FastIca.DEFLATION);
        fastIca.setFunction(FastIca.LOGCOSH);
        fastIca.setTolerance(0.01);
        fastIca.setMaxIterations(1000);
        fastIca.setAlpha(1.0);
        FastIca.IcaResult result = fastIca.findComponents();
        Matrix W = new Matrix(result.getW());
        return W.transpose();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setThreshold(double t) {
        this.threshold = t;
    }

    public Matrix pruneEdgesByResampling(Matrix data) {
        Matrix X = new Matrix(data.transpose().toArray());
        int npieces = 10;
        int cols = X.columns();
        int rows = X.rows();
        ArrayList<Matrix> bpieces = new ArrayList<Matrix>();
        for (int p = 0; p < 10; ++p) {
            int j;
            int i;
            edu.cmu.tetrad.util.Vector Xpm = new edu.cmu.tetrad.util.Vector(rows);
            for (i = 0; i < rows; ++i) {
                double sum = 0.0;
                for (j = 0; j < X.columns(); ++j) {
                    sum += X.get(i, j);
                }
                Xpm.set(i, sum / (double)X.columns());
            }
            for (i = 0; i < rows; ++i) {
                for (int j2 = 0; j2 < X.columns(); ++j2) {
                    X.set(i, j2, X.get(i, j2) - Xpm.get(i));
                }
            }
            Matrix Xpt = X.transpose();
            Matrix cov = X.times(Xpt);
            for (int i2 = 0; i2 < cov.rows(); ++i2) {
                for (j = 0; j < cov.columns(); ++j) {
                    cov.set(i2, j, cov.get(i2, j) / (double)X.columns());
                }
            }
            boolean posDef = LingUtils.isPositiveDefinite(cov);
            if (!posDef) {
                System.out.println("Covariance matrix is not positive definite.");
            }
            Matrix sqrt = cov.sqrt();
            Matrix I = Matrix.identity(rows);
            I.copy();
            Matrix invSqrt = sqrt.inverse();
            QRDecomposition qr = new QRDecomposition(new BlockRealMatrix(invSqrt.toArray()));
            RealMatrix r = qr.getR();
            edu.cmu.tetrad.util.Vector newestdisturbancestd = new edu.cmu.tetrad.util.Vector(rows);
            for (int t = 0; t < rows; ++t) {
                newestdisturbancestd.set(t, 1.0 / FastMath.abs(r.getEntry(t, t)));
            }
            for (int s = 0; s < rows; ++s) {
                for (int t = 0; t < FastMath.min(s, cols); ++t) {
                    r.setEntry(s, t, r.getEntry(s, t) / r.getEntry(s, s));
                }
            }
            Matrix bnewest = Matrix.identity(rows);
            bnewest = bnewest.minus(new Matrix(r.getData()));
            bpieces.add(bnewest);
        }
        Matrix means = new Matrix(rows, rows);
        Matrix stds = new Matrix(rows, rows);
        Matrix BFinal = new Matrix(rows, rows);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < rows; ++j) {
                double sum = 0.0;
                for (int y = 0; y < 10; ++y) {
                    sum += ((Matrix)bpieces.get(y)).get(i, j);
                }
                double themean = sum / 10.0;
                double sumVar = 0.0;
                for (int y = 0; y < 10; ++y) {
                    sumVar += FastMath.pow(((Matrix)bpieces.get(y)).get(i, j) - themean, 2);
                }
                double thestd = FastMath.sqrt(sumVar / 10.0);
                means.set(i, j, themean);
                stds.set(i, j, thestd);
                if (FastMath.abs(themean) < this.threshold * thestd) {
                    BFinal.set(i, j, 0.0);
                    continue;
                }
                BFinal.set(i, j, themean);
            }
        }
        return BFinal;
    }

    private void makeDataSet(GraphWithParameters graphWP) {
        GaussianPower gp2 = new GaussianPower(2.0);
        edu.cmu.tetrad.util.Vector errorCoefficients = Ling.getErrorCoeffsIdentity(graphWP.getGraph().getNumNodes());
        Matrix inVectors = Ling.simulateCyclic(graphWP, errorCoefficients, this.numSamples, gp2);
        this.dataSet = new BoxDataSet(new DoubleDataBox(inVectors.transpose().toArray()), graphWP.getGraph().getNodes());
    }

    private static edu.cmu.tetrad.util.Vector getErrorCoeffsIdentity(int n) {
        edu.cmu.tetrad.util.Vector errorCoefficients = new edu.cmu.tetrad.util.Vector(n);
        for (int i = 0; i < n; ++i) {
            errorCoefficients.set(i, 1.0);
        }
        return errorCoefficients;
    }

    private static Matrix simulateCyclic(GraphWithParameters dwp, edu.cmu.tetrad.util.Vector errorCoefficients, int n, Distribution distribution) {
        Matrix reducedForm = Ling.reducedForm(dwp);
        Matrix vectors = new Matrix(dwp.getGraph().getNumNodes(), n);
        for (int j = 0; j < n; ++j) {
            edu.cmu.tetrad.util.Vector vector = Ling.simulateReducedForm(reducedForm, errorCoefficients, distribution);
            vectors.assignColumn(j, vector);
        }
        return vectors;
    }

    private static Matrix reducedForm(GraphWithParameters graph) {
        Matrix graphMatrix = new Matrix(graph.getGraphMatrix().getDoubleData().toArray());
        int n = graphMatrix.rows();
        Matrix identityMinusGraphTetradMatrix = Matrix.identity(n).minus(graphMatrix);
        return identityMinusGraphTetradMatrix.inverse();
    }

    private static edu.cmu.tetrad.util.Vector simulateReducedForm(Matrix reducedForm, edu.cmu.tetrad.util.Vector errorCoefficients, Distribution distr) {
        int n = reducedForm.rows();
        edu.cmu.tetrad.util.Vector vector = new edu.cmu.tetrad.util.Vector(n);
        edu.cmu.tetrad.util.Vector samples = new edu.cmu.tetrad.util.Vector(n);
        for (int j = 0; j < n; ++j) {
            double sample = distr.nextRandom();
            double errorCoefficient = errorCoefficients.get(j);
            samples.set(j, sample * errorCoefficient);
        }
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                double coefficient = reducedForm.get(i, j);
                double sample = samples.get(j);
                sum += coefficient * sample;
            }
            vector.set(i, sum);
        }
        return vector;
    }

    private StoredGraphs findCandidateModels(List<Node> variables, Matrix matrixW) {
        int d;
        StoredGraphs gs = new StoredGraphs();
        System.out.println("Calculating zeroless diagonal permutations...");
        TetradLogger.getInstance().log("lingDetails", "Calculating zeroless diagonal permutations.");
        List<PermutationMatrixPair> zldPerms = this.zerolessDiagonalPermutations(matrixW, variables, this.dataSet);
        System.out.println("Calculated zeroless diagonal permutations.");
        for (PermutationMatrixPair zldPerm : zldPerms) {
            TetradLogger.getInstance().log("lingDetails", "" + zldPerm);
            System.out.println(zldPerm);
            Matrix normalizedZldW = LingUtils.normalizeDiagonal(zldPerm.getMatrixW());
            zldPerm.setMatrixBhat(Ling.computeBhatTetradMatrix(normalizedZldW, variables));
            Matrix doubleData = zldPerm.getMatrixBhat().getDoubleData();
            boolean isStableTetradMatrix = Ling.allEigenvaluesAreSmallerThanOneInModulus(new Matrix(doubleData.toArray()));
            GraphWithParameters graph = new GraphWithParameters(zldPerm.getMatrixBhat());
            gs.addGraph(graph.getGraph());
            gs.addStable(isStableTetradMatrix);
            gs.addData(zldPerm.getMatrixBhat());
        }
        TetradLogger.getInstance().log("stableGraphs", "Stable Graphs:");
        for (d = 0; d < gs.getNumGraphs(); ++d) {
            if (!gs.isStable(d)) continue;
            TetradLogger.getInstance().log("stableGraphs", "" + gs.getGraph(d));
            if (TetradLogger.getInstance().getLoggerConfig() == null || !TetradLogger.getInstance().getLoggerConfig().isEventActive("stableGraphs")) continue;
            TetradLogger.getInstance().log("wMatrices", "" + gs.getData(d));
        }
        TetradLogger.getInstance().log("unstableGraphs", "Unstable Graphs:");
        for (d = 0; d < gs.getNumGraphs(); ++d) {
            if (gs.isStable(d)) continue;
            TetradLogger.getInstance().log("unstableGraphs", "" + gs.getGraph(d));
            if (TetradLogger.getInstance().getLoggerConfig() == null || !TetradLogger.getInstance().getLoggerConfig().isEventActive("unstableGraphs")) continue;
            TetradLogger.getInstance().log("wMatrices", "" + gs.getData(d));
        }
        return gs;
    }

    private StoredGraphs findCandidateModel(List<Node> variables, Matrix matrixW) {
        int d;
        StoredGraphs gs = new StoredGraphs();
        System.out.println("Calculating zeroless diagonal permutations...");
        TetradLogger.getInstance().log("lingDetails", "Calculating zeroless diagonal permutations.");
        List<PermutationMatrixPair> zldPerms = this.zerolessDiagonalPermutation(matrixW, variables);
        System.out.println("Calculated zeroless diagonal permutations.");
        for (PermutationMatrixPair zldPerm : zldPerms) {
            TetradLogger.getInstance().log("lingDetails", "" + zldPerm);
            System.out.println(zldPerm);
            Matrix normalizedZldW = LingUtils.normalizeDiagonal(zldPerm.getMatrixW());
            zldPerm.setMatrixBhat(Ling.computeBhatTetradMatrix(normalizedZldW, variables));
            Matrix doubleData = zldPerm.getMatrixBhat().getDoubleData();
            boolean isStableTetradMatrix = Ling.allEigenvaluesAreSmallerThanOneInModulus(new Matrix(doubleData.toArray()));
            GraphWithParameters graph = new GraphWithParameters(zldPerm.getMatrixBhat());
            gs.addGraph(graph.getGraph());
            gs.addStable(isStableTetradMatrix);
            gs.addData(zldPerm.getMatrixBhat());
        }
        TetradLogger.getInstance().log("stableGraphs", "Stable Graphs:");
        for (d = 0; d < gs.getNumGraphs(); ++d) {
            if (!gs.isStable(d)) continue;
            TetradLogger.getInstance().log("stableGraphs", "" + gs.getGraph(d));
            if (TetradLogger.getInstance().getLoggerConfig() == null || !TetradLogger.getInstance().getLoggerConfig().isEventActive("stableGraphs")) continue;
            TetradLogger.getInstance().log("wMatrices", "" + gs.getData(d));
        }
        TetradLogger.getInstance().log("unstableGraphs", "Unstable Graphs:");
        for (d = 0; d < gs.getNumGraphs(); ++d) {
            if (gs.isStable(d)) continue;
            TetradLogger.getInstance().log("unstableGraphs", "" + gs.getGraph(d));
            if (TetradLogger.getInstance().getLoggerConfig() == null || !TetradLogger.getInstance().getLoggerConfig().isEventActive("unstableGraphs")) continue;
            TetradLogger.getInstance().log("wMatrices", "" + gs.getData(d));
        }
        return gs;
    }

    private List<PermutationMatrixPair> zerolessDiagonalPermutations(Matrix ica_W, List<Node> vars, DataSet dataSet) {
        Vector<PermutationMatrixPair> permutations = new Vector<PermutationMatrixPair>();
        this.pruneEdgesByResampling(dataSet.getDoubleData());
        ica_W = this.removeZeroRowsAndCols(ica_W, vars);
        Matrix mat = ica_W.transpose();
        List<List<Integer>> nRookAssignments = Ling.nRookColumnAssignments(mat, Ling.makeAllRows(mat.rows()));
        for (List<Integer> permutation : nRookAssignments) {
            Matrix matrixW = Ling.permuteRows(ica_W, permutation).transpose();
            PermutationMatrixPair permTetradMatrixPair = new PermutationMatrixPair(permutation, matrixW);
            permutations.add(permTetradMatrixPair);
        }
        return permutations;
    }

    private List<PermutationMatrixPair> zerolessDiagonalPermutation(Matrix ica_W, List<Node> vars) {
        Vector<PermutationMatrixPair> permutations = new Vector<PermutationMatrixPair>();
        ica_W = this.pruneEdgesByResampling(ica_W);
        ica_W = this.removeZeroRowsAndCols(ica_W, vars);
        ArrayList<Integer> perm = new ArrayList<Integer>();
        for (int i = 0; i < vars.size(); ++i) {
            perm.add(i);
        }
        Matrix matrixW = ica_W.transpose();
        PermutationMatrixPair pair = new PermutationMatrixPair(perm, matrixW);
        permutations.add(pair);
        return permutations;
    }

    private Matrix removeZeroRowsAndCols(Matrix w, List<Node> variables) {
        int j;
        int i;
        Matrix _W = w.copy();
        ArrayList<Node> _variables = new ArrayList<Node>(variables);
        ArrayList<Integer> remove = new ArrayList<Integer>();
        block0: for (i = 0; i < _W.rows(); ++i) {
            edu.cmu.tetrad.util.Vector row = _W.getRow(i);
            for (j = 0; j < row.size(); ++j) {
                if (row.get(j) != 0.0) continue block0;
            }
            remove.add(i);
        }
        block2: for (i = 0; i < _W.rows(); ++i) {
            edu.cmu.tetrad.util.Vector col = _W.getColumn(i);
            for (j = 0; j < col.size(); ++j) {
                if (col.get(j) != 0.0) continue block2;
            }
            if (remove.contains(i)) continue;
            remove.add(i);
        }
        int[] rows = new int[_W.rows() - remove.size()];
        int count = -1;
        for (int k = 0; k < w.rows(); ++k) {
            if (remove.contains(k)) {
                variables.remove(_variables.get(k));
                continue;
            }
            if (remove.contains(k)) continue;
            rows[++count] = k;
        }
        w = w.getSelection(rows, rows);
        return w;
    }

    private static List<Integer> makeAllRows(int n) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            l.add(i);
        }
        return l;
    }

    private static List<List<Integer>> nRookColumnAssignments(Matrix mat, List<Integer> availableRows) {
        ArrayList<List<Integer>> concats = new ArrayList<List<Integer>>();
        System.out.println("mat = " + mat);
        int n = availableRows.size();
        for (int i = 0; i < n; ++i) {
            int currentRowIndex = availableRows.get(i);
            if (mat.get(currentRowIndex, 0) == 0.0) continue;
            if (mat.columns() > 1) {
                Vector<Integer> newAvailableRows = new Vector<Integer>(availableRows);
                newAvailableRows.removeElement(currentRowIndex);
                Matrix subMat = mat.getPart(0, mat.rows() - 1, 1, mat.columns() - 2);
                List<List<Integer>> allLater = Ling.nRookColumnAssignments(subMat, newAvailableRows);
                for (List<Integer> laterPerm : allLater) {
                    laterPerm.add(0, currentRowIndex);
                    concats.add(laterPerm);
                }
                continue;
            }
            ArrayList<Integer> l = new ArrayList<Integer>();
            l.add(currentRowIndex);
            concats.add(l);
        }
        return concats;
    }

    private static Matrix permuteRows(Matrix mat, List<Integer> permutation) {
        Matrix permutedMat = mat.like();
        for (int j = 0; j < mat.rows(); ++j) {
            edu.cmu.tetrad.util.Vector row = mat.getRow(j);
            permutedMat.assignRow(permutation.get(j), row);
        }
        return permutedMat;
    }

    private static DataSet computeBhatTetradMatrix(Matrix normalizedZldW, List<Node> nodes) {
        int size = normalizedZldW.rows();
        Matrix mat = Matrix.identity(size).minus(normalizedZldW);
        return new BoxDataSet(new DoubleDataBox(mat.toArray()), nodes);
    }

    private static boolean allEigenvaluesAreSmallerThanOneInModulus(Matrix mat) {
        EigenDecomposition dec = new EigenDecomposition(new BlockRealMatrix(mat.toArray()));
        double[] realEigenvalues = dec.getRealEigenvalues();
        double[] imagEigenvalues = dec.getImagEigenvalues();
        for (int i = 0; i < realEigenvalues.length; ++i) {
            double realEigenvalue = realEigenvalues[i];
            double imagEigenvalue = imagEigenvalues[i];
            double modulus = FastMath.sqrt(FastMath.pow(realEigenvalue, 2) + FastMath.pow(imagEigenvalue, 2));
            if (!(modulus >= 1.5)) continue;
            return false;
        }
        return true;
    }

    public static class StoredGraphs
    implements GraphGroup {
        private final List<Graph> graphs = new ArrayList<Graph>();
        private final List<DataSet> dataSet = new ArrayList<DataSet>();
        private final List<Boolean> stable = new ArrayList<Boolean>();

        @Override
        public int getNumGraphs() {
            return this.graphs.size();
        }

        @Override
        public Graph getGraph(int g) {
            return this.graphs.get(g);
        }

        public DataSet getData(int d) {
            return this.dataSet.get(d);
        }

        public boolean isStable(int s) {
            return this.stable.get(s);
        }

        @Override
        public void addGraph(Graph g) {
            this.graphs.add(g);
        }

        public void addData(DataSet d) {
            this.dataSet.add(d);
        }

        public void addStable(Boolean s) {
            this.stable.add(s);
        }
    }

    private static class Mapping {
        private final int i;
        private final int j;

        public Mapping(int i, int j) {
            this.i = i;
            this.j = j;
        }

        public int getI() {
            return this.i;
        }

        public int getJ() {
            return this.j;
        }
    }
}

