/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FastIca;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.PermutationGenerator;
import java.util.Arrays;
import java.util.List;

public class Lingam {
    private double penaltyDiscount = 2.0;
    private double fastIcaA = 1.1;
    private int fastIcaMaxIter = 2000;
    private double fastIcaTolerance = 1.0E-6;

    public Graph search(DataSet data) {
        int[] choice2;
        int[] choice1;
        for (int j = 0; j < data.getNumColumns(); ++j) {
            for (int i = 0; i < data.getNumRows(); ++i) {
                if (!Double.isNaN(data.getDouble(i, j))) continue;
                throw new IllegalArgumentException("Please remove or impute missing values.");
            }
        }
        Matrix X = data.getDoubleData();
        X = DataUtils.centerData(X).transpose();
        FastIca fastIca = new FastIca(X, X.rows());
        fastIca.setVerbose(false);
        fastIca.setMaxIterations(this.fastIcaMaxIter);
        fastIca.setAlgorithmType(FastIca.PARALLEL);
        fastIca.setTolerance(this.fastIcaTolerance);
        fastIca.setFunction(FastIca.EXP);
        fastIca.setRowNorm(false);
        fastIca.setAlpha(this.fastIcaA);
        FastIca.IcaResult result11 = fastIca.findComponents();
        Matrix W = result11.getW();
        PermutationGenerator gen1 = new PermutationGenerator(W.columns());
        int[] perm1 = new int[]{};
        double sum1 = Double.NEGATIVE_INFINITY;
        while ((choice1 = gen1.next()) != null) {
            double sum = 0.0;
            for (int i = 0; i < W.columns(); ++i) {
                double wii = W.get(choice1[i], i);
                sum += StrictMath.abs(wii);
            }
            if (!(sum > sum1)) continue;
            sum1 = sum;
            perm1 = Arrays.copyOf(choice1, choice1.length);
        }
        int[] cols = new int[W.columns()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        Matrix WTilde = W.getSelection(perm1, cols);
        Matrix WPrime = WTilde.copy();
        for (int i = 0; i < WPrime.rows(); ++i) {
            for (int j = 0; j < WPrime.columns(); ++j) {
                WPrime.assignRow(i, WTilde.getRow(i).scalarMult(1.0 / WTilde.get(i, i)));
            }
        }
        int m = data.getNumColumns();
        Matrix BHat = Matrix.identity(m).minus(WPrime);
        PermutationGenerator gen2 = new PermutationGenerator(BHat.rows());
        int[] perm2 = new int[]{};
        double sum2 = Double.NEGATIVE_INFINITY;
        while ((choice2 = gen2.next()) != null) {
            double sum = 0.0;
            for (int i = 0; i < W.rows(); ++i) {
                for (int j = 0; j < i; ++j) {
                    double c = BHat.get(choice2[i], choice2[j]);
                    sum += StrictMath.abs(c);
                }
            }
            if (!(sum > sum2)) continue;
            sum2 = sum;
            perm2 = Arrays.copyOf(choice2, choice2.length);
        }
        SemBicScore score = new SemBicScore(new CovarianceMatrix(data));
        score.setPenaltyDiscount(this.penaltyDiscount);
        Fges fges = new Fges(score);
        Knowledge knowledge = new Knowledge();
        List<Node> variables = data.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            knowledge.addToTier(i, variables.get(perm2[i]).getName());
        }
        fges.setKnowledge(knowledge);
        Graph graph = fges.search();
        System.out.println("graph Returning this graph: " + graph);
        return graph;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public void setFastIcaA(double fastIcaA) {
        this.fastIcaA = fastIcaA;
    }

    public void setFastMaxIter(int maxIter) {
        this.fastIcaMaxIter = maxIter;
    }

    public void setFastIcaTolerance(double tolerance) {
        this.fastIcaTolerance = tolerance;
    }
}

