/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MNLRLikelihood;
import edu.cmu.tetrad.search.Score;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class MNLRScore
implements Score {
    private final DataSet dataSet;
    private final List<Node> variables;
    private final MNLRLikelihood likelihood;
    private final double logn;

    public MNLRScore(DataSet dataSet, double structurePrior, int fDegree) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.likelihood = new MNLRLikelihood(dataSet, structurePrior, fDegree);
        this.logn = FastMath.log(dataSet.getNumRows());
    }

    @Override
    public double localScore(int i, int ... parents) {
        double sp;
        double dof;
        double lik = this.likelihood.getLik(i, parents);
        double score = 2.0 * lik - (dof = this.likelihood.getDoF(i, parents)) * this.logn + (sp = this.likelihood.getStructurePrior(parents.length));
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScore(y, x) - this.localScore(y);
    }

    private int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 0, parents.length);
        all[parents.length] = extra;
        return all;
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    @Override
    public int getSampleSize() {
        return this.dataSet.getNumRows();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.dataSet.getNumRows()));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }
}

