/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MbUtils {
    public static void trimToMbNodes(Graph graph, Node target, boolean includeBidirected) {
        if (includeBidirected) {
            List<Node> pc = graph.getAdjacentNodes(target);
            List<Node> children = graph.getNodesOutTo(target, Endpoint.ARROW);
            HashSet<Node> hashSet = new HashSet<Node>();
            for (Node v : children) {
                for (Node w : graph.getAdjacentNodes(v)) {
                    if (w == target || hashSet.contains(w) || pc.contains(w)) continue;
                    if (graph.isDefCollider(target, v, w)) {
                        hashSet.add(w);
                        continue;
                    }
                    if (!graph.getNodesInTo(v, Endpoint.ARROW).contains(target) || !graph.paths().isUndirectedFromTo(v, w)) continue;
                    hashSet.add(w);
                }
            }
            HashSet<Node> hashSet2 = new HashSet<Node>();
            hashSet2.add(target);
            hashSet2.addAll(pc);
            hashSet2.addAll(hashSet);
            List<Node> irrelevantNodes = graph.getNodes();
            irrelevantNodes.removeAll(hashSet2);
            graph.removeNodes(irrelevantNodes);
        } else {
            LinkedList<Node> pc = new LinkedList<Node>();
            for (Node node : graph.getAdjacentNodes(target)) {
                if (!graph.paths().isDirectedFromTo(target, node) && !graph.paths().isDirectedFromTo(node, target) && !graph.paths().isUndirectedFromTo(node, target)) continue;
                pc.add(node);
            }
            LinkedList children = new LinkedList();
            for (Node node : graph.getAdjacentNodes(target)) {
                if (children.contains(node) || !graph.paths().isDirectedFromTo(target, node)) continue;
                children.add(node);
            }
            HashSet<Node> hashSet = new HashSet<Node>();
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Node v3 = (Node)iterator.next();
                for (Node w : graph.getAdjacentNodes(v3)) {
                    if (w == target || hashSet.contains(w) || pc.contains(w) || !graph.paths().isDirectedFromTo(target, v3) || !graph.paths().isDirectedFromTo(w, v3)) continue;
                    hashSet.add(w);
                }
            }
            HashSet<Node> hashSet3 = new HashSet<Node>();
            hashSet3.add(target);
            hashSet3.addAll(pc);
            hashSet3.addAll(hashSet);
            List<Node> irrelevantNodes = graph.getNodes();
            irrelevantNodes.removeAll(hashSet3);
            graph.removeNodes(irrelevantNodes);
        }
    }

    public static void trimEdgesAmongParents(Graph graph, Node target) {
        List<Node> parents = graph.getParents(target);
        if (parents.size() >= 2) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(parents.size(), 2);
            while ((choice = cg.next()) != null) {
                Node w;
                Node v = parents.get(choice[0]);
                Edge edge = graph.getEdge(v, w = parents.get(choice[1]));
                if (edge == null) continue;
                graph.removeEdges(v, w);
            }
        }
    }

    public static void trimEdgesAmongParentsOfChildren(Graph graph, Node target) {
        List<Node> children = graph.getNodesOutTo(target, Endpoint.ARROW);
        HashSet<Node> parents = new HashSet<Node>();
        for (Node aChildren : children) {
            parents.addAll(graph.getParents(aChildren));
        }
        parents.remove(target);
        graph.getAdjacentNodes(target).forEach(parents::remove);
        ArrayList parentsOfChildren = new ArrayList(parents);
        if (parentsOfChildren.size() >= 2) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(parentsOfChildren.size(), 2);
            while ((choice = cg.next()) != null) {
                Node w;
                Node v = (Node)parentsOfChildren.get(choice[0]);
                Edge edge = graph.getEdge(v, w = (Node)parentsOfChildren.get(choice[1]));
                if (edge == null) continue;
                graph.removeEdge(v, w);
            }
        }
    }

    public static void trimToAdjacents(Graph graph, Node target) {
        for (Node node : graph.getNodes()) {
            if (node == target || graph.isAdjacentTo(node, target)) continue;
            graph.removeNode(node);
        }
    }

    public static List<Graph> generateMbDags(Graph mbCPDAG, boolean orientBidirectedEdges, IndependenceTest test, int depth, Node target) {
        return new LinkedList<Graph>(MbUtils.listMbDags(new EdgeListGraph(mbCPDAG), orientBidirectedEdges, test, depth, target));
    }

    private static Set<Graph> listMbDags(Graph mbCPDAG, boolean orientBidirectedEdges, IndependenceTest test, int depth, Node target) {
        HashSet<Graph> dags = new HashSet<Graph>();
        EdgeListGraph graph = new EdgeListGraph(mbCPDAG);
        MbUtils.doAbbreviatedMbOrientation(graph, test, depth, target);
        Set<Edge> edges = graph.getEdges();
        Edge edge = null;
        for (Edge _edge : edges) {
            if (orientBidirectedEdges && Edges.isBidirectedEdge(_edge)) {
                edge = _edge;
                break;
            }
            if (!Edges.isUndirectedEdge(_edge)) continue;
            edge = _edge;
            break;
        }
        if (edge == null) {
            dags.add(graph);
            return dags;
        }
        graph.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.TAIL);
        graph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.ARROW);
        dags.addAll(MbUtils.listMbDags(graph, orientBidirectedEdges, test, depth, target));
        graph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.TAIL);
        graph.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.ARROW);
        dags.addAll(MbUtils.listMbDags(graph, orientBidirectedEdges, test, depth, target));
        return dags;
    }

    public static Graph getOneMbDag(Graph mbCPDAG) {
        return SearchGraphUtils.dagFromCPDAG(mbCPDAG);
    }

    private static void doAbbreviatedMbOrientation(Graph graph, IndependenceTest test, int depth, Node target) {
        SearchGraphUtils.orientUsingMeekRulesLocally(new Knowledge(), graph, test, depth);
        MbUtils.trimToMbNodes(graph, target, false);
        MbUtils.trimEdgesAmongParents(graph, target);
        MbUtils.trimEdgesAmongParentsOfChildren(graph, target);
    }
}

