/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MeekRules
implements ImpliedOrientation {
    private Knowledge knowledge = new Knowledge();
    private boolean aggressivelyPreventCycles;
    boolean useRule4;
    private final Map<Edge, Edge> changedEdges = new HashMap<Edge, Edge>();
    private PrintStream out;
    private boolean verbose;
    private boolean revertToUnshieldedColliders = true;

    public MeekRules() {
        this.useRule4 = !this.knowledge.isEmpty();
    }

    @Override
    public Set<Node> orientImplied(Graph graph) {
        HashSet<Node> visited = new HashSet<Node>();
        TetradLogger.getInstance().log("impliedOrientations", "Starting Orientation Step D.");
        if (this.revertToUnshieldedColliders) {
            this.revertToUnshieldedColliders(graph.getNodes(), graph, visited);
        }
        boolean oriented = true;
        while (oriented) {
            oriented = false;
            for (Edge edge : graph.getEdges()) {
                Node y;
                if (!Edges.isUndirectedEdge(edge)) continue;
                Node x = edge.getNode1();
                if (this.meekR1(x, y = edge.getNode2(), graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR1(y, x, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR2(x, y, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR2(y, x, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR3(x, y, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR3(y, x, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (this.meekR4(x, y, graph, visited)) {
                    oriented = true;
                    continue;
                }
                if (!this.meekR4(y, x, graph, visited)) continue;
                oriented = true;
            }
        }
        TetradLogger.getInstance().log("impliedOrientations", "Finishing Orientation Step D.");
        return visited;
    }

    public void revertToUnshieldedColliders(List<Node> nodes, Graph graph, Set<Node> visited) {
        boolean reverted = true;
        while (reverted) {
            reverted = false;
            for (Node node : nodes) {
                if (!this.revertToUnshieldedColliders(node, graph, visited)) continue;
                reverted = true;
            }
        }
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public Map<Edge, Edge> getChangedEdges() {
        return this.changedEdges;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    private boolean meekR1(Node b, Node c, Graph graph, Set<Node> visited) {
        for (Node a : graph.getParents(b)) {
            if (graph.isAdjacentTo(c, a) || !this.direct(b, c, graph, visited)) continue;
            this.log(SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + a + "-->" + b + "---" + c + ")", graph.getEdge(b, c)));
            return true;
        }
        return false;
    }

    private boolean meekR2(Node a, Node c, Graph graph, Set<Node> visited) {
        List<Node> adjacentNodes = graph.getAdjacentNodes(c);
        adjacentNodes.remove(a);
        Set<Node> common = this.getCommonAdjacents(a, c, graph);
        for (Node b : common) {
            if (graph.paths().isDirectedFromTo(a, b) && graph.paths().isDirectedFromTo(b, c) && this.r2Helper(a, b, c, graph, visited)) {
                return true;
            }
            if (!graph.paths().isDirectedFromTo(c, b) || !graph.paths().isDirectedFromTo(b, a) || !this.r2Helper(c, b, a, graph, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean r2Helper(Node a, Node b, Node c, Graph graph, Set<Node> visited) {
        boolean directed = this.direct(a, c, graph, visited);
        this.log(SearchLogUtils.edgeOrientedMsg("Meek R2 triangle (" + a + "-->" + b + "-->" + c + ", " + a + "---" + c + ")", graph.getEdge(a, c)));
        return directed;
    }

    private boolean meekR3(Node d, Node a, Graph graph, Set<Node> visited) {
        ArrayList<Node> adjacentNodes = new ArrayList<Node>(this.getCommonAdjacents(a, d, graph));
        if (adjacentNodes.size() < 2) {
            return false;
        }
        for (int i = 0; i < adjacentNodes.size(); ++i) {
            for (int j = i + 1; j < adjacentNodes.size(); ++j) {
                Node c;
                Node b = (Node)adjacentNodes.get(i);
                if (graph.isAdjacentTo(b, c = (Node)adjacentNodes.get(j)) || !this.r3Helper(a, d, b, c, graph, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean r3Helper(Node a, Node d, Node b, Node c, Graph graph, Set<Node> visited) {
        boolean oriented = false;
        boolean b4 = graph.paths().isUndirectedFromTo(d, a);
        boolean b5 = graph.paths().isUndirectedFromTo(d, b);
        boolean b6 = graph.paths().isUndirectedFromTo(d, c);
        boolean b7 = graph.paths().isDirectedFromTo(b, a);
        boolean b8 = graph.paths().isDirectedFromTo(c, a);
        if (b4 && b5 && b6 && b7 && b8) {
            oriented = this.direct(d, a, graph, visited);
            this.log(SearchLogUtils.edgeOrientedMsg("Meek R3 " + d + "--" + a + ", " + b + ", " + c, graph.getEdge(d, a)));
        }
        return oriented;
    }

    private boolean meekR4(Node a, Node b, Graph graph, Set<Node> visited) {
        if (!this.useRule4) {
            return false;
        }
        for (Node c : graph.getParents(b)) {
            Set<Node> adj = this.getCommonAdjacents(a, c, graph);
            adj.remove(b);
            for (Node d : adj) {
                Edge dc;
                if (graph.isAdjacentTo(b, d) || !(dc = graph.getEdge(d, c)).pointsTowards(c) || graph.getEdge(a, d).isDirected() || !this.direct(a, b, graph, visited)) continue;
                this.log(SearchLogUtils.edgeOrientedMsg("Meek R4 using " + c + ", " + d, graph.getEdge(a, b)));
                return true;
            }
        }
        return false;
    }

    private boolean direct(Node a, Node c, Graph graph, Set<Node> visited) {
        if (!MeekRules.isArrowpointAllowed(a, c, this.knowledge)) {
            return false;
        }
        if (!Edges.isUndirectedEdge(graph.getEdge(a, c))) {
            return false;
        }
        Edge before = graph.getEdge(a, c);
        graph.removeEdge(before);
        if (this.aggressivelyPreventCycles && graph.paths().existsDirectedPathFromTo(c, a)) {
            graph.addEdge(before);
            return false;
        }
        Edge after = Edges.directedEdge(a, c);
        visited.add(a);
        visited.add(c);
        graph.removeEdge(before);
        graph.addEdge(after);
        return true;
    }

    private static boolean isArrowpointAllowed(Node from, Node to, Knowledge knowledge) {
        if (knowledge.isEmpty()) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    private boolean revertToUnshieldedColliders(Node y, Graph graph, Set<Node> visited) {
        boolean did = false;
        List<Node> parents = graph.getParents(y);
        block0: for (Node p : parents) {
            for (Node q : parents) {
                if (p == q || graph.isAdjacentTo(p, q)) continue;
                continue block0;
            }
            if (this.knowledge.isForbidden(y.getName(), p.getName()) || this.knowledge.isRequired(p.getName(), y.getName())) continue;
            graph.removeEdge(p, y);
            graph.addUndirectedEdge(p, y);
            visited.add(p);
            visited.add(y);
            did = true;
        }
        return did;
    }

    private void log(String message) {
        if (this.verbose) {
            TetradLogger.getInstance().forceLogMessage(message);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private Set<Node> getCommonAdjacents(Node x, Node y, Graph graph) {
        HashSet<Node> adj = new HashSet<Node>(graph.getAdjacentNodes(x));
        adj.retainAll(graph.getAdjacentNodes(y));
        return adj;
    }

    public void setRevertToUnshieldedColliders(boolean revertToUnshieldedColliders) {
        this.revertToUnshieldedColliders = revertToUnshieldedColliders;
    }
}

