/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MeekRulesCpdag
implements ImpliedOrientation {
    private Knowledge Knowledge;
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();

    @Override
    public Set<Node> orientImplied(Graph graph) {
        this.orientUsingMeekRulesLocally(this.Knowledge, graph);
        return null;
    }

    @Override
    public void setKnowledge(Knowledge Knowledge2) {
        this.Knowledge = Knowledge2;
    }

    public void orientUsingMeekRulesLocally(Knowledge Knowledge2, Graph graph) {
        boolean changed;
        this.logger.log("info", "Starting Orientation Step D.");
        while (changed = this.meekR2(graph, Knowledge2) || this.meekR1Locally(graph, Knowledge2) || this.meekR3(graph, Knowledge2) || this.meekR4(graph, Knowledge2)) {
        }
        this.logger.log("info", "Finishing Orientation Step D.");
    }

    public boolean meekR1Locally(Graph graph, Knowledge Knowledge2) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node c;
                Node b = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.paths().isUndirectedFromTo(a, c)) {
                    if (MeekRulesCpdag.isShieldedNoncollider(b, a, c, graph) || !MeekRulesCpdag.isArrowpointAllowed(a, c, Knowledge2) || graph.paths().isAncestorOf(c, a)) continue;
                    graph.setEndpoint(a, c, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + b + "-->" + a + "---" + c + ")", graph.getEdge(a, c)));
                    changed = true;
                    this.meekR2(graph, Knowledge2);
                    continue;
                }
                if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.paths().isUndirectedFromTo(a, b) || MeekRulesCpdag.isShieldedNoncollider(b, a, c, graph) || !MeekRulesCpdag.isArrowpointAllowed(a, b, Knowledge2) || graph.paths().isAncestorOf(b, a)) continue;
                graph.setEndpoint(a, b, Endpoint.ARROW);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + c + "-->" + a + "---" + b + ")", graph.getEdge(a, b)));
                changed = true;
                this.meekR2(graph, Knowledge2);
            }
        }
        return changed;
    }

    public boolean meekR2(Graph graph, Knowledge Knowledge2) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.paths().isDirectedFromTo(b, a) && graph.paths().isDirectedFromTo(a, c) && graph.paths().isUndirectedFromTo(b, c)) {
                    if (!MeekRulesCpdag.isArrowpointAllowed(b, c, Knowledge2) || graph.paths().isAncestorOf(c, b)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    this.meekR2(graph, Knowledge2);
                    continue;
                }
                if (!graph.paths().isDirectedFromTo(c, a) || !graph.paths().isDirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(c, b) || !MeekRulesCpdag.isArrowpointAllowed(c, b, Knowledge2) || graph.paths().isAncestorOf(b, c)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
                this.meekR2(graph, Knowledge2);
            }
        }
        return false;
    }

    public boolean meekR3(Graph graph, Knowledge Knowledge2) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.paths().isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.paths().isUndirectedFromTo(a, c) || !graph.paths().isUndirectedFromTo(a, d) || MeekRulesCpdag.isShieldedNoncollider(c, a, d, graph) || !graph.paths().isDirectedFromTo(c, b) || !graph.paths().isDirectedFromTo(d, b) || !MeekRulesCpdag.isArrowpointAllowed(a, b, Knowledge2) || graph.paths().isAncestorOf(b, a)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    this.meekR2(graph, Knowledge2);
                    continue block1;
                }
            }
        }
        return changed;
    }

    public boolean meekR4(Graph graph, Knowledge Knowledge2) {
        if (Knowledge2 == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.paths().isUndirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(a, c) || MeekRulesCpdag.isShieldedNoncollider(c, a, b, graph)) continue;
                    if (graph.paths().isDirectedFromTo(b, d) && graph.paths().isDirectedFromTo(d, c)) {
                        if (!MeekRulesCpdag.isArrowpointAllowed(a, c, Knowledge2) || graph.paths().isAncestorOf(c, a)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, c)));
                        changed = true;
                        this.meekR2(graph, Knowledge2);
                        continue block1;
                    }
                    if (!graph.paths().isDirectedFromTo(c, d) || !graph.paths().isDirectedFromTo(d, b) || !MeekRulesCpdag.isArrowpointAllowed(a, b, Knowledge2) || graph.paths().isAncestorOf(b, a)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.logger.log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, b)));
                    changed = true;
                    this.meekR2(graph, Knowledge2);
                    continue block1;
                }
            }
        }
        return changed;
    }

    private static boolean isShieldedNoncollider(Node a, Node b, Node c, Graph graph) {
        if (graph.underlines().isAmbiguousTriple(a, b, c)) {
            return true;
        }
        if (!graph.isAdjacentTo(a, b)) {
            return true;
        }
        if (!graph.isAdjacentTo(c, b)) {
            return true;
        }
        if (graph.isAdjacentTo(a, c)) {
            return true;
        }
        return graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.ARROW;
    }

    private static boolean isArrowpointAllowed(Object from, Object to, Knowledge Knowledge2) {
        if (Knowledge2 == null) {
            return true;
        }
        return !Knowledge2.isRequired(to.toString(), from.toString()) && !Knowledge2.isForbidden(from.toString(), to.toString());
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }
}

