/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class MeekRulesRestricted
implements ImpliedOrientation {
    private Knowledge knowledge;
    private boolean aggressivelyPreventCycles;
    boolean useRule4;
    private ArrayList<OrderedPair<Edge>> changedEdges = new ArrayList();
    private final Set<Node> visitedNodes = new HashSet<Node>();
    private final Queue<Node> rule1Queue = new LinkedList<Node>();
    private final Queue<Node> rule2Queue = new LinkedList<Node>();
    private final Queue<Node> rule3Queue = new LinkedList<Node>();
    private final Queue<Node> rule4Queue = new LinkedList<Node>();
    private Set<Node> nodes;

    @Override
    public Set<Node> orientImplied(Graph graph) {
        this.nodes = new HashSet<Node>(graph.getNodes());
        this.visitedNodes.addAll(this.nodes);
        TetradLogger.getInstance().log("impliedOrientations", "Starting Orientation Step D.");
        this.changedEdges = new ArrayList();
        this.orientUsingMeekRulesLocally(this.knowledge, graph);
        TetradLogger.getInstance().log("impliedOrientations", "Finishing Orientation Step D.");
        graph.underlines().removeTriplesNotInGraph();
        return this.visitedNodes;
    }

    public void orientImplied(Graph graph, Set<Node> nodes) {
        this.nodes = nodes;
        this.visitedNodes.addAll(nodes);
        TetradLogger.getInstance().log("impliedOrientations", "Starting Orientation Step D.");
        this.changedEdges = new ArrayList();
        this.orientUsingMeekRulesLocally(this.knowledge, graph);
        TetradLogger.getInstance().log("impliedOrientations", "Finishing Orientation Step D.");
        graph.underlines().removeTriplesNotInGraph();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph) {
        for (Node node : this.getNodes()) {
            if (graph.getParents(node).isEmpty()) continue;
            this.meekR1Locally(node, graph, knowledge);
            this.meekR2(node, graph, knowledge);
            this.meekR3(node, graph, knowledge);
            if (!this.useRule4) continue;
            this.meekR4(node, graph, knowledge);
        }
        while (!(this.rule1Queue.isEmpty() && this.rule2Queue.isEmpty() && this.rule3Queue.isEmpty() && this.rule4Queue.isEmpty())) {
            Node node;
            while (!this.rule1Queue.isEmpty()) {
                node = this.rule1Queue.remove();
                this.meekR1Locally(node, graph, knowledge);
            }
            while (!this.rule2Queue.isEmpty()) {
                node = this.rule2Queue.remove();
                this.meekR2(node, graph, knowledge);
            }
            while (!this.rule3Queue.isEmpty()) {
                node = this.rule3Queue.remove();
                this.meekR3(node, graph, knowledge);
            }
            while (!this.rule4Queue.isEmpty()) {
                node = this.rule4Queue.remove();
                this.meekR4(node, graph, knowledge);
            }
        }
    }

    private void meekR1Locally(Node a, Graph graph, Knowledge knowledge) {
        int[] combination;
        List<Node> adjacentNodes = graph.getAdjacentNodes(a);
        this.visitedNodes.add(a);
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null) {
            Node y;
            Node x;
            Edge after;
            Node c;
            Node b = adjacentNodes.get(combination[0]);
            if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
            if (graph.paths().isDirectedFromTo(b, a) && graph.paths().isUndirectedFromTo(a, c)) {
                if (MeekRulesRestricted.isShieldedNoncollider(b, a, c, graph) || !MeekRulesRestricted.isArrowpointAllowed(a, c, knowledge) || !this.doesNotCreateCycle(a, c, graph)) continue;
                after = this.direct(a, c, graph);
                x = after.getNode1();
                y = after.getNode2();
                this.rule1Queue.add(y);
                this.rule2Queue.add(y);
                this.rule3Queue.add(x);
                if (this.useRule4) {
                    this.rule4Queue.add(x);
                }
                TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R1 triangle (" + b + "-->" + a + "---" + c + ")", graph.getEdge(a, c)));
                continue;
            }
            if (!graph.paths().isDirectedFromTo(c, a) || !graph.paths().isUndirectedFromTo(a, b) || MeekRulesRestricted.isShieldedNoncollider(b, a, c, graph) || !MeekRulesRestricted.isArrowpointAllowed(a, b, knowledge) || !this.doesNotCreateCycle(a, b, graph)) continue;
            after = this.direct(a, b, graph);
            x = after.getNode1();
            y = after.getNode2();
            this.rule1Queue.add(y);
            this.rule2Queue.add(y);
            this.rule3Queue.add(x);
            if (this.useRule4) {
                this.rule4Queue.add(x);
            }
            TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R1 (" + c + "-->" + a + "---" + b + ")", graph.getEdge(a, b)));
        }
    }

    private void meekR2(Node a, Graph graph, Knowledge knowledge) {
        int[] combination;
        List<Node> adjacentNodes = graph.getAdjacentNodes(a);
        this.visitedNodes.add(a);
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null) {
            Node y;
            Node x;
            Edge after;
            Node b = adjacentNodes.get(combination[0]);
            Node c = adjacentNodes.get(combination[1]);
            if (graph.paths().isDirectedFromTo(b, a) && graph.paths().isDirectedFromTo(a, c) && graph.paths().isUndirectedFromTo(b, c)) {
                if (!MeekRulesRestricted.isArrowpointAllowed(b, c, knowledge) || !this.doesNotCreateCycle(b, c, graph)) continue;
                after = this.direct(b, c, graph);
                x = after.getNode1();
                y = after.getNode2();
                this.rule1Queue.add(y);
                this.rule2Queue.add(y);
                this.rule3Queue.add(x);
                if (this.useRule4) {
                    this.rule4Queue.add(x);
                }
                TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                continue;
            }
            if (!graph.paths().isDirectedFromTo(c, a) || !graph.paths().isDirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(c, b) || !MeekRulesRestricted.isArrowpointAllowed(c, b, knowledge) || !this.doesNotCreateCycle(c, b, graph)) continue;
            after = this.direct(c, b, graph);
            x = after.getNode1();
            y = after.getNode2();
            this.rule1Queue.add(y);
            this.rule2Queue.add(y);
            this.rule3Queue.add(x);
            if (this.useRule4) {
                this.rule4Queue.add(x);
            }
            TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
        }
    }

    private void meekR3(Node a, Graph graph, Knowledge knowledge) {
        List<Node> adjacentNodes = graph.getAdjacentNodes(a);
        this.visitedNodes.add(a);
        if (adjacentNodes.size() < 3) {
            return;
        }
        for (Node b : adjacentNodes) {
            int[] combination;
            LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
            otherAdjacents.remove(b);
            if (!graph.paths().isUndirectedFromTo(a, b)) continue;
            ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
            while ((combination = cg.next()) != null) {
                Node d;
                Node c = (Node)otherAdjacents.get(combination[0]);
                if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.paths().isDirectedFromTo(c, a) || !graph.paths().isDirectedFromTo(d, a) || !graph.paths().isUndirectedFromTo(b, c) || !graph.paths().isUndirectedFromTo(b, d) || !MeekRulesRestricted.isArrowpointAllowed(b, a, knowledge) || !this.doesNotCreateCycle(b, a, graph) || MeekRulesRestricted.isShieldedNoncollider(c, b, d, graph)) continue;
                Edge after = this.direct(b, a, graph);
                Node x = after.getNode1();
                Node y = after.getNode2();
                this.rule1Queue.add(y);
                this.rule2Queue.add(y);
                this.rule3Queue.add(x);
                if (this.useRule4) {
                    this.rule4Queue.add(x);
                }
                TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
            }
        }
    }

    private void meekR4(Node a, Graph graph, Knowledge knowledge) {
        if (!this.useRule4) {
            return;
        }
        List<Node> adjacentNodes = graph.getAdjacentNodes(a);
        this.visitedNodes.add(a);
        if (adjacentNodes.size() < 3) {
            return;
        }
        for (Node d : adjacentNodes) {
            int[] combination;
            if (!graph.isAdjacentTo(d, a)) continue;
            LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
            otherAdjacents.remove(d);
            ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
            while ((combination = cg.next()) != null) {
                Node y;
                Node x;
                Edge after;
                Node b = (Node)otherAdjacents.get(combination[0]);
                Node c = (Node)otherAdjacents.get(combination[1]);
                if (graph.paths().isDirectedFromTo(b, a) && graph.paths().isDirectedFromTo(a, c)) {
                    if (!graph.paths().isUndirectedFromTo(d, b) || !graph.paths().isUndirectedFromTo(d, c) || MeekRulesRestricted.isShieldedNoncollider(c, d, b, graph) || !MeekRulesRestricted.isArrowpointAllowed(d, c, knowledge) || !this.doesNotCreateCycle(d, c, graph)) continue;
                    after = this.direct(d, c, graph);
                    x = after.getNode1();
                    y = after.getNode2();
                    this.rule1Queue.add(y);
                    this.rule2Queue.add(y);
                    this.rule3Queue.add(x);
                    if (this.useRule4) {
                        this.rule4Queue.add(x);
                    }
                    TetradLogger.getInstance().log("impliedOientations", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, c)));
                    continue;
                }
                if (!graph.paths().isDirectedFromTo(c, a) || !graph.paths().isDirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(d, b) || !graph.paths().isUndirectedFromTo(d, c) || MeekRulesRestricted.isShieldedNoncollider(c, d, b, graph) || !MeekRulesRestricted.isArrowpointAllowed(d, c, knowledge) || !this.doesNotCreateCycle(d, c, graph)) continue;
                after = this.direct(d, c, graph);
                x = after.getNode1();
                y = after.getNode2();
                this.rule1Queue.add(y);
                this.rule2Queue.add(y);
                this.rule3Queue.add(x);
                if (this.useRule4) {
                    this.rule4Queue.add(x);
                }
                TetradLogger.getInstance().log("impliedOientations", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, c)));
            }
        }
    }

    private Edge direct(Node a, Node c, Graph graph) {
        Edge before = graph.getEdge(a, c);
        Edge after = Edges.directedEdge(a, c);
        graph.removeEdge(before);
        graph.addEdge(after);
        this.changedEdges.add(new OrderedPair<Edge>(before, after));
        return after;
    }

    private static boolean isShieldedNoncollider(Node a, Node b, Node c, Graph graph) {
        if (!graph.isAdjacentTo(a, b)) {
            return true;
        }
        if (!graph.isAdjacentTo(c, b)) {
            return true;
        }
        if (graph.isAdjacentTo(a, c)) {
            return true;
        }
        if (graph.underlines().isAmbiguousTriple(a, b, c)) {
            return true;
        }
        return graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.ARROW;
    }

    private static boolean isArrowpointAllowed(Node from, Node to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    private boolean doesNotCreateCycle(Node x, Node y, Graph graph) {
        if (this.aggressivelyPreventCycles) {
            return !graph.paths().isAncestorOf(y, x);
        }
        return true;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public List<OrderedPair<Edge>> getChangedEdges() {
        return this.changedEdges;
    }

    public Set<Node> getVisitedNodes() {
        return this.visitedNodes;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }
}

