/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class PagUtils {
    public static boolean graphInPagStep0(Graph pag, Graph dag) {
        List<Node> pagNodes = pag.getNodes();
        for (Node pagNode : pagNodes) {
            if (dag.getNode(pagNode.getName()) == null) {
                return false;
            }
            if (dag.getNode(pagNode.getName()).getNodeType() == NodeType.MEASURED) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep1(Graph pag, Graph dag) {
        IndTestDSep test = new IndTestDSep(pag);
        ArrayList<Node> V = new ArrayList<Node>(dag.getNodes());
        for (Edge edge : pag.getEdges()) {
            int[] choice;
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            ArrayList<Node> W = new ArrayList<Node>(V);
            W.remove(A);
            W.remove(B);
            ChoiceGenerator gen = new ChoiceGenerator(W.size(), W.size());
            while ((choice = gen.next()) != null) {
                List<Node> S = GraphUtils.asList(choice, W);
                if (!test.isDSeparated(A, B, S)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean graphInPagStep2(Graph pag, Graph dag) {
        Set<Edge> pagEdges = pag.getEdges();
        for (Edge edge : pagEdges) {
            if (edge.getEndpoint1() != Endpoint.TAIL) continue;
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            ArrayList<Node> singletonB = new ArrayList<Node>();
            singletonB.add(Bd);
            List<Node> ancestorsOfB = dag.paths().getAncestors(singletonB);
            if (ancestorsOfB.contains(Ad)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep3(Graph pag, Graph dag) {
        Set<Edge> pagEdges = pag.getEdges();
        for (Edge edge : pagEdges) {
            if (edge.getEndpoint2() != Endpoint.ARROW) continue;
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            if (!dag.paths().isAncestorOf(Bd, Ad)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep4(Graph pag, Graph dag) {
        Set<Triple> pagUnderLines = pag.underlines().getUnderLines();
        for (Triple underline : pagUnderLines) {
            Node A = underline.getX();
            Node B = underline.getY();
            Node C = underline.getZ();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            Node Cd = dag.getNode(C.getName());
            if (dag.paths().isAncestorOf(Bd, Ad) || dag.paths().isAncestorOf(Bd, Cd)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep5(Graph pag, Graph dag) {
        for (Triple triple : pag.underlines().getDottedUnderlines()) {
            Node A = triple.getX();
            Node B = triple.getY();
            Node C = triple.getZ();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            Node Cd = dag.getNode(C.getName());
            if (!pag.isParentOf(A, B) || !pag.isParentOf(C, B)) continue;
            ArrayList<Node> commonChildrenAC = new ArrayList<Node>(dag.getChildren(Ad));
            commonChildrenAC.retainAll(dag.getChildren(Cd));
            for (Node Dd : commonChildrenAC) {
                if (!dag.paths().isDescendentOf(Bd, Dd)) continue;
                return false;
            }
        }
        return true;
    }
}

