/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.FasConcurrent;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.OrientCollidersMaxP;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class PcAll
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private int heuristic;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private boolean aggressivelyPreventCycles;
    private SepsetMap sepsets;
    private boolean verbose;
    private boolean useHeuristic;
    private int maxPathLength;
    private FasType fasType = FasType.REGULAR;
    private Concurrent concurrent = Concurrent.YES;
    private ColliderDiscovery colliderDiscovery = ColliderDiscovery.FAS_SEPSETS;
    private ConflictRule conflictRule = ConflictRule.OVERWRITE;
    private Graph externalGraph = null;

    public PcAll(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    private static void orientCollider(Node x, Node y, Node z, ConflictRule conflictRule, Graph graph) {
        if (conflictRule == ConflictRule.PRIORITY) {
            if (graph.getEndpoint(y, x) != Endpoint.ARROW && graph.getEndpoint(y, z) != Endpoint.ARROW) {
                graph.removeEdge(x, y);
                graph.removeEdge(z, y);
                graph.addDirectedEdge(x, y);
                graph.addDirectedEdge(z, y);
            }
        } else if (conflictRule == ConflictRule.BIDIRECTED) {
            graph.setEndpoint(x, y, Endpoint.ARROW);
            graph.setEndpoint(z, y, Endpoint.ARROW);
            System.out.println("Orienting " + graph.getEdge(x, y) + " " + graph.getEdge(z, y));
            System.out.println("graph = " + graph);
        } else if (conflictRule == ConflictRule.OVERWRITE) {
            graph.removeEdge(x, y);
            graph.removeEdge(z, y);
            graph.addDirectedEdge(x, y);
            graph.addDirectedEdge(z, y);
        }
        TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        return knowledge == null || !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public void setUseHeuristic(boolean useHeuristic) {
        this.useHeuristic = useHeuristic;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setFasType(FasType fasType) {
        this.fasType = fasType;
    }

    public void setConcurrent(Concurrent concurrent) {
        this.concurrent = concurrent;
    }

    public void setHeuristic(int heuristic) {
        this.heuristic = heuristic;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public void setColliderDiscovery(ColliderDiscovery colliderDiscovery) {
        this.colliderDiscovery = colliderDiscovery;
    }

    public void setConflictRule(ConflictRule conflictRule) {
        this.conflictRule = conflictRule;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getNonadjacencies() {
        Graph complete = GraphUtils.completeGraph(this.graph);
        Set<Edge> nonAdjacencies = complete.getEdges();
        Graph undirected = GraphUtils.undirectedGraph(this.graph);
        nonAdjacencies.removeAll(undirected.getEdges());
        return new HashSet<Edge>(nonAdjacencies);
    }

    @Override
    public Graph search() {
        return this.search(this.getIndependenceTest().getVariables());
    }

    public Graph search(List<Node> nodes) {
        IFas fas;
        nodes = new ArrayList<Node>(nodes);
        this.logger.log("info", "Starting algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.independenceTest.setVerbose(this.verbose);
        long startTime = MillisecondTimes.timeMillis();
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        if (this.fasType == FasType.REGULAR) {
            if (this.concurrent == Concurrent.NO) {
                fas = new Fas(this.getIndependenceTest());
                ((Fas)fas).setHeuristic(this.heuristic);
            } else {
                fas = new FasConcurrent(this.getIndependenceTest());
                ((FasConcurrent)fas).setStable(false);
            }
        } else if (this.concurrent == Concurrent.NO) {
            fas = new Fas(this.getIndependenceTest());
            ((Fas)fas).setStable(true);
        } else {
            fas = new FasConcurrent(this.getIndependenceTest());
            ((FasConcurrent)fas).setStable(true);
        }
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        if (this.colliderDiscovery == ColliderDiscovery.FAS_SEPSETS) {
            this.orientCollidersUsingSepsets(this.sepsets, this.knowledge, this.graph, this.verbose, this.conflictRule);
        } else if (this.colliderDiscovery == ColliderDiscovery.MAX_P) {
            if (this.verbose) {
                System.out.println("MaxP orientation...");
            }
            OrientCollidersMaxP orientCollidersMaxP = new OrientCollidersMaxP(this.independenceTest);
            orientCollidersMaxP.setConflictRule(this.conflictRule);
            orientCollidersMaxP.setUseHeuristic(this.useHeuristic);
            orientCollidersMaxP.setMaxPathLength(this.maxPathLength);
            orientCollidersMaxP.setDepth(this.depth);
            orientCollidersMaxP.orient(this.graph);
        } else if (this.colliderDiscovery == ColliderDiscovery.CONSERVATIVE) {
            if (this.verbose) {
                System.out.println("CPC orientation...");
            }
            this.orientUnshieldedTriplesConservative(this.knowledge);
        }
        this.graph = GraphUtils.replaceNodes(this.graph, nodes);
        MeekRules meekRules = new MeekRules();
        meekRules.setKnowledge(this.knowledge);
        meekRules.setVerbose(this.verbose);
        meekRules.orientImplied(this.graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logTriples();
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    private void logTriples() {
        TetradLogger.getInstance().log("info", "\nCollider triples:");
        for (Triple triple : this.colliderTriples) {
            TetradLogger.getInstance().log("info", "Collider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nNoncollider triples:");
        for (Triple triple : this.noncolliderTriples) {
            TetradLogger.getInstance().log("info", "Noncollider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nAmbiguous triples (i.e. list of triples for which \nthere is ambiguous data about whether they are colliderDiscovery or not):");
        for (Triple triple : this.getAmbiguousTriples()) {
            TetradLogger.getInstance().log("info", "Ambiguous: " + triple);
        }
    }

    private void orientUnshieldedTriplesConservative(Knowledge knowledge) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        List<Node> nodes = this.graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                List<List<Node>> sepsetsxz = this.getSepsets(x, z, this.graph);
                if (this.isColliderSepset(y, sepsetsxz)) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        PcAll.orientCollider(x, y, z, this.conflictRule, this.graph);
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (this.isNoncolliderSepset(y, sepsetsxz)) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.graph.underlines().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private List<List<Node>> getSepsets(Node i, Node k, Graph g) {
        List<Node> adji = g.getAdjacentNodes(i);
        List<Node> adjk = g.getAdjacentNodes(k);
        ArrayList<List<Node>> sepsets = new ArrayList<List<Node>>();
        for (int d = 0; d <= FastMath.max(adji.size(), adjk.size()); ++d) {
            List<Node> v;
            int[] choice;
            ChoiceGenerator gen;
            if (adji.size() >= 2 && d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                    v = GraphUtils.asList(choice, adji);
                    if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                    sepsets.add(v);
                }
            }
            if (adjk.size() < 2 || d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                v = GraphUtils.asList(choice, adjk);
                if (!this.getIndependenceTest().checkIndependence(i, k, v).independent()) continue;
                sepsets.add(v);
            }
        }
        return sepsets;
    }

    private boolean isColliderSepset(Node j, List<List<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (List<Node> sepset : sepsets) {
            if (!sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean isNoncolliderSepset(Node j, List<List<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (List<Node> sepset : sepsets) {
            if (sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return PcAll.isArrowpointAllowed1(x, y, knowledge) && PcAll.isArrowpointAllowed1(z, y, knowledge);
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void orientCollidersUsingSepsets(SepsetMap set, Knowledge knowledge, Graph graph, boolean verbose, ConflictRule conflictRule) {
        if (verbose) {
            System.out.println("FAS Sepset orientation...");
        }
        TetradLogger.getInstance().log("details", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1]))) continue;
                List<Node> sepset = set.get(a, c);
                ArrayList<Node> s2 = new ArrayList<Node>(sepset);
                if (!s2.contains(b)) {
                    s2.add(b);
                }
                if (sepset.contains(b) || !PcAll.isArrowpointAllowed(a, b, knowledge) || !PcAll.isArrowpointAllowed(c, b, knowledge)) continue;
                PcAll.orientCollider(a, b, c, conflictRule, graph);
                if (verbose) {
                    System.out.println("Collider orientation <" + a + ", " + b + ", " + c + "> sepset = " + sepset);
                }
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(a, b, c, sepset));
            }
        }
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }

    public static enum FasType {
        REGULAR,
        STABLE;

    }

    public static enum Concurrent {
        YES,
        NO;

    }

    public static enum ColliderDiscovery {
        FAS_SEPSETS,
        CONSERVATIVE,
        MAX_P;

    }

    public static enum ConflictRule {
        PRIORITY,
        BIDIRECTED,
        OVERWRITE;

    }
}

