/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.SublistGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PcLocal
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();
    private long elapsedTime;
    private Graph graph;
    private MeekRules meekRules;
    private final SepsetMap sepsetMap = new SepsetMap();
    private boolean verbose;
    private Graph externalGraph;

    public PcLocal(IndependenceTest independenceTest) {
        this(independenceTest, null);
    }

    public PcLocal(IndependenceTest independenceTest, Graph graph) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.graph = graph;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public Graph search() {
        long time1 = MillisecondTimes.timeMillis();
        if (this.externalGraph != null) {
            this.graph = new EdgeListGraph(this.externalGraph);
            this.graph.reorientAllWith(Endpoint.TAIL);
        } else if (this.graph == null) {
            this.graph = new EdgeListGraph(this.getIndependenceTest().getVariables());
        } else {
            this.graph = new EdgeListGraph(this.graph);
            this.graph.reorientAllWith(Endpoint.TAIL);
        }
        this.meekRules = new MeekRules();
        this.meekRules.setKnowledge(this.knowledge);
        List<Node> nodes = this.getIndependenceTest().getVariables();
        int numEdges = nodes.size() * (nodes.size() - 1) / 2;
        int index = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                if (this.verbose && ++index % 100 == 0) {
                    this.log(index + " of " + numEdges);
                }
                Node x = nodes.get(i);
                Node y = nodes.get(j);
                this.tryAddingEdge(x, y);
            }
        }
        for (Node node : nodes) {
            this.reorientNode(node);
        }
        this.applyMeek();
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        long time2 = MillisecondTimes.timeMillis();
        this.elapsedTime = time2 - time1;
        return this.graph;
    }

    private void log(String message) {
        TetradLogger.getInstance().log("info", message);
    }

    private void tryAddingEdge(Node x, Node y) {
        if (this.graph.isAdjacentTo(x, y)) {
            return;
        }
        if (this.sepset(x, y) == null) {
            if (this.getKnowledge().isForbidden(x.getName(), y.getName()) && this.getKnowledge().isForbidden(y.getName(), x.getName())) {
                return;
            }
            this.graph.addUndirectedEdge(x, y);
            this.reorient(x, y);
            for (Node w : this.graph.getAdjacentNodes(x)) {
                this.tryRemovingEdge(w, x);
            }
            for (Node w : this.graph.getAdjacentNodes(y)) {
                this.tryRemovingEdge(w, y);
            }
        }
    }

    private void tryRemovingEdge(Node x, Node y) {
        if (!this.graph.isAdjacentTo(x, y)) {
            return;
        }
        if (this.sepset(x, y) != null) {
            if (!this.getKnowledge().noEdgeRequired(x.getName(), y.getName())) {
                return;
            }
            this.graph.removeEdge(x, y);
            this.reorient(x, y);
        }
    }

    private List<Node> sepset(Node x, Node y) {
        List<Node> cond;
        int[] choice;
        if (x == y) {
            throw new IllegalArgumentException("Can't have x == y.");
        }
        List<Node> adj = this.graph.getAdjacentNodes(x);
        adj.remove(y);
        SublistGenerator gen = new SublistGenerator(adj.size(), adj.size());
        while ((choice = gen.next()) != null) {
            cond = GraphUtils.asList(choice, adj);
            if (!this.getIndependenceTest().checkIndependence(x, y, cond).independent()) continue;
            this.sepsetMap.set(x, y, cond);
            return cond;
        }
        adj = this.graph.getAdjacentNodes(y);
        adj.remove(x);
        gen = new SublistGenerator(adj.size(), adj.size());
        while ((choice = gen.next()) != null) {
            cond = GraphUtils.asList(choice, adj);
            if (!this.getIndependenceTest().checkIndependence(x, y, cond).independent()) continue;
            this.sepsetMap.set(x, y, cond);
            return cond;
        }
        return null;
    }

    private void reorient(Node x, Node y) {
        this.reorientNode(y);
        this.reorientNode(x);
        for (Node c : this.getCommonAdjacents(x, y)) {
            this.reorientNode(c);
        }
    }

    private Set<Node> getCommonAdjacents(Node x, Node y) {
        HashSet<Node> commonChildren = new HashSet<Node>(this.graph.getAdjacentNodes(x));
        commonChildren.retainAll(this.graph.getAdjacentNodes(y));
        return commonChildren;
    }

    private void reorientNode(Node y) {
        this.unorientAdjacents(y);
        this.orientLocalColliders(y);
    }

    private void applyMeek() {
        this.meekRules.orientImplied(this.graph);
    }

    private void unorientAdjacents(Node y) {
        for (Node z : this.graph.getAdjacentNodes(y)) {
            if (this.graph.isParentOf(y, z)) continue;
            this.graph.removeEdge(z, y);
            this.graph.addUndirectedEdge(z, y);
        }
    }

    private void orientLocalColliders(Node y) {
        List<Node> adjy = this.graph.getAdjacentNodes(y);
        for (int i = 0; i < adjy.size(); ++i) {
            for (int j = i + 1; j < adjy.size(); ++j) {
                List<Node> cond;
                Node z = adjy.get(i);
                Node w = adjy.get(j);
                if (this.graph.paths().isAncestorOf(y, z) || this.graph.paths().isAncestorOf(y, w) || this.graph.isAdjacentTo(z, w) || (cond = this.sepset(z, w)) == null || cond.contains(y) || this.knowledge.isForbidden(z.getName(), y.getName()) || this.knowledge.isForbidden(w.getName(), y.getName())) continue;
                this.graph.setEndpoint(z, y, Endpoint.ARROW);
                this.graph.setEndpoint(w, y, Endpoint.ARROW);
            }
        }
    }

    public static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public SepsetMap getSepsets() {
        return this.sepsetMap;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExternalGraph(Graph externalGraph) {
        this.externalGraph = externalGraph;
    }
}

