/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class PcStable
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepsets;
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private PrintStream out = System.out;

    public PcStable(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        if (this.verbose) {
            this.logger.log("info", "Starting PC algorithm");
            this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        }
        long startTime = MillisecondTimes.timeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        this.graph = new EdgeListGraph(nodes);
        Fas fas = new Fas(this.getIndependenceTest());
        fas.setStable(true);
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        SearchGraphUtils.orientCollidersUsingSepsets(this.sepsets, this.knowledge, this.graph, this.verbose, false);
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        rules.setKnowledge(this.knowledge);
        rules.orientImplied(this.graph);
        if (this.verbose) {
            this.logger.log("graph", "\nReturning this graph: " + this.graph);
        }
        this.elapsedTime = MillisecondTimes.timeMillis() - startTime;
        if (this.verbose) {
            this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
            this.logger.log("info", "Finishing PC Algorithm.");
            this.logger.flush();
        }
        return this.graph;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List<Node> getNodes() {
        return this.graph.getNodes();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }
}

