/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.OrientCollidersMaxP;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PcStableMax
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = -1;
    private Graph graph;
    private long elapsedTime;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private boolean useHeuristic;
    private int maxPathLength;

    public PcStableMax(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        this.logger.log("info", "Starting PC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        long startTime = MillisecondTimes.timeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!allNodes.containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        Fas fas = new Fas(this.getIndependenceTest());
        fas.setStable(true);
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        OrientCollidersMaxP orientCollidersMaxP = new OrientCollidersMaxP(this.independenceTest);
        orientCollidersMaxP.setKnowledge(this.knowledge);
        orientCollidersMaxP.setUseHeuristic(this.useHeuristic);
        orientCollidersMaxP.setMaxPathLength(this.maxPathLength);
        orientCollidersMaxP.orient(this.graph);
        MeekRules rules = new MeekRules();
        rules.setKnowledge(this.knowledge);
        rules.orientImplied(this.graph);
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        this.elapsedTime = MillisecondTimes.timeMillis() - startTime;
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.log("info", "Finishing PC Algorithm.");
        this.logger.flush();
        return this.graph;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getNonadjacencies() {
        Graph complete = GraphUtils.completeGraph(this.graph);
        Set<Edge> nonAdjacencies = complete.getEdges();
        Graph undirected = GraphUtils.undirectedGraph(this.graph);
        nonAdjacencies.removeAll(undirected.getEdges());
        return new HashSet<Edge>(nonAdjacencies);
    }

    public List<Node> getNodes() {
        return this.graph.getNodes();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setUseHeuristic(boolean useHeuristic) {
        this.useHeuristic = useHeuristic;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }
}

