/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Individual;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

class Population {
    private final List<Node> vars;
    private final Score score;
    private final int numIndividuals;
    private final ConcurrentSkipListSet<Individual> individuals = new ConcurrentSkipListSet();

    public Population(Score score, List<Node> vars, int numIndividuals) {
        this.score = score;
        this.vars = vars;
        this.numIndividuals = numIndividuals;
    }

    public void initializePopulation() {
        for (int i = 0; i < this.numIndividuals; ++i) {
            ArrayList<Node> order = new ArrayList<Node>(this.vars);
            RandomUtil.shuffle(order);
            this.individuals.add(new Individual(this.score, order));
        }
    }

    public Individual getFittestIndividual() {
        if (!this.individuals.isEmpty()) {
            return this.individuals.first();
        }
        return null;
    }

    public void add(Individual individual) {
        this.individuals.add(individual);
    }

    public int getNumGenes() {
        return this.vars.size();
    }
}

