/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.TetradTest;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class PopulationTetradTest
implements TetradTest {
    private final CorrelationMatrix CorrelationMatrix;
    private final boolean[] bvalues;
    private final double epsilon = 0.001;

    public PopulationTetradTest(CorrelationMatrix CorrelationMatrix2) {
        this.CorrelationMatrix = CorrelationMatrix2;
        this.bvalues = new boolean[3];
    }

    @Override
    public String[] getVarNames() {
        return this.CorrelationMatrix.getVariableNames().toArray(new String[0]);
    }

    @Override
    public List<Node> getVariables() {
        return this.CorrelationMatrix.getVariables();
    }

    @Override
    public DataSet getDataSet() {
        return null;
    }

    @Override
    public int tetradScore(int v1, int v2, int v3, int v4) {
        int count = 0;
        double p_12 = this.CorrelationMatrix.getValue(v1, v2);
        double p_13 = this.CorrelationMatrix.getValue(v1, v3);
        double p_14 = this.CorrelationMatrix.getValue(v1, v4);
        double p_23 = this.CorrelationMatrix.getValue(v2, v3);
        double p_24 = this.CorrelationMatrix.getValue(v2, v4);
        double p_34 = this.CorrelationMatrix.getValue(v3, v4);
        for (int i = 0; i < 3; ++i) {
            this.bvalues[i] = false;
        }
        if (FastMath.abs(p_12 * p_34 - p_13 * p_24) < this.epsilon) {
            ++count;
            this.bvalues[0] = true;
        }
        if (FastMath.abs(p_12 * p_34 - p_14 * p_23) < this.epsilon) {
            ++count;
            this.bvalues[1] = true;
        }
        if (FastMath.abs(p_13 * p_24 - p_14 * p_23) < this.epsilon) {
            ++count;
            this.bvalues[2] = true;
        }
        return count;
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        return this.tetradScore(v1, v2, v3, v4) == 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        if (this.tetradScore(v1, v2, v3, v4) != 1) {
            return false;
        }
        return this.bvalues[2];
    }

    @Override
    public boolean tetradHolds(int v1, int v2, int v3, int v4) {
        double p_12 = this.CorrelationMatrix.getValue(v1, v2);
        double p_13 = this.CorrelationMatrix.getValue(v1, v3);
        double p_24 = this.CorrelationMatrix.getValue(v2, v4);
        double p_34 = this.CorrelationMatrix.getValue(v3, v4);
        this.bvalues[0] = FastMath.abs(p_12 * p_34 - p_13 * p_24) < this.epsilon;
        return this.bvalues[0];
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d) {
        return this.tetradScore3(a, b, c, d);
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d, int e) {
        return this.tetradScore3(a, b, c, d) && this.tetradScore3(a, b, c, e) && this.tetradScore3(b, c, d, e);
    }

    @Override
    public boolean oneFactorTest(int a, int b, int c, int d, int e, int f) {
        return this.tetradScore3(a, b, c, d) && this.tetradScore3(b, c, d, e) && this.tetradScore3(c, d, e, f);
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d) {
        this.tetradScore(a, b, c, d);
        return this.bvalues[2];
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d, int e) {
        this.tetradScore(a, b, d, e);
        if (!this.bvalues[2]) {
            return false;
        }
        this.tetradScore(a, c, d, e);
        if (!this.bvalues[2]) {
            return false;
        }
        this.tetradScore(b, c, d, e);
        return this.bvalues[2];
    }

    @Override
    public boolean twoFactorTest(int a, int b, int c, int d, int e, int f) {
        if (!this.twoFactorTest(a, b, c, d, e)) {
            return false;
        }
        if (!this.twoFactorTest(a, b, c, d, f)) {
            return false;
        }
        return this.twoFactorTest(a, b, c, e, f);
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        return -1.0;
    }

    @Override
    public double tetradPValue(int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2) {
        return 0.0;
    }

    @Override
    public double getSignificance() {
        return 0.0;
    }

    @Override
    public void setSignificance(double sig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICovarianceMatrix getCovMatrix() {
        return null;
    }
}

