/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PossibleDConnectingPath {
    private final Graph pag;
    private final Set<Node> conditions;
    private final List<Node> path;

    private PossibleDConnectingPath(Graph p, Set<Node> conditions, List<Node> path) {
        if (p == null || conditions == null || path == null) {
            throw new NullPointerException();
        }
        this.conditions = conditions;
        this.path = path;
        this.pag = p;
    }

    public Graph getPag() {
        return this.pag;
    }

    public Set<Node> getConditions() {
        return Collections.unmodifiableSet(this.conditions);
    }

    public List<Node> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public String toString() {
        return this.path.toString();
    }

    public static List<PossibleDConnectingPath> findDConnectingPaths(Graph pag, Node x, Node y, Collection<Node> z) {
        if (!pag.containsNode(x) || !pag.containsNode(y) || x.equals(y)) {
            return Collections.emptyList();
        }
        for (Node node : z) {
            if (pag.containsNode(node)) continue;
            return Collections.emptyList();
        }
        if (pag.isAdjacentTo(x, y)) {
            return Collections.singletonList(new PossibleDConnectingPath(pag, new HashSet<Node>(z), Arrays.asList(x, y)));
        }
        LinkedList<PossibleDConnectingPath> connectingPaths = new LinkedList<PossibleDConnectingPath>();
        HashSet<Node> conditions = new HashSet<Node>(z);
        Set<Node> closure = PossibleDConnectingPath.getConditioningClosure(pag, z);
        HashSet<List<Node>> paths = new HashSet<List<Node>>();
        PossibleDConnectingPath.findPaths(pag, paths, null, x, y, conditions, closure, new LinkedList<Node>());
        for (List list : paths) {
            connectingPaths.add(new PossibleDConnectingPath(pag, conditions, list));
        }
        return connectingPaths;
    }

    public static List<PossibleDConnectingPath> findDConnectingPathsOfLength(Graph pag, Node x, Node y, Collection<Node> z, Integer length) {
        if (!pag.containsNode(x) || !pag.containsNode(y) || x.equals(y)) {
            return Collections.emptyList();
        }
        for (Node node : z) {
            if (pag.containsNode(node)) continue;
            return Collections.emptyList();
        }
        if (pag.isAdjacentTo(x, y)) {
            return Collections.singletonList(new PossibleDConnectingPath(pag, new HashSet<Node>(z), Arrays.asList(x, y)));
        }
        LinkedList<PossibleDConnectingPath> connectingPaths = new LinkedList<PossibleDConnectingPath>();
        HashSet<Node> conditions = new HashSet<Node>(z);
        Set<Node> closure = PossibleDConnectingPath.getConditioningClosure(pag, z);
        HashSet<List<Node>> paths = new HashSet<List<Node>>();
        PossibleDConnectingPath.findPathsOfLength(pag, paths, null, x, y, conditions, closure, new LinkedList<Node>(), length);
        for (List list : paths) {
            connectingPaths.add(new PossibleDConnectingPath(pag, conditions, list));
        }
        return connectingPaths;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PossibleDConnectingPath)) {
            return false;
        }
        PossibleDConnectingPath p = (PossibleDConnectingPath)o;
        return p.pag.equals(this.pag) && p.path.equals(this.path) && p.conditions.equals(this.conditions);
    }

    private static Set<Node> getConditioningClosure(Graph pag, Collection<Node> z) {
        HashSet<Node> closure = new HashSet<Node>();
        for (Node node : z) {
            PossibleDConnectingPath.doParentClosureVisit(pag, node, closure);
        }
        return closure;
    }

    private static void doParentClosureVisit(Graph pag, Node node, Set<Node> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (Edge edge1 : pag.getEdges(node)) {
                Node sub = Edges.traverseReverseDirected(node, edge1);
                if (sub == null) continue;
                PossibleDConnectingPath.doParentClosureVisit(pag, sub, closure);
            }
        }
    }

    private static void findPaths(Graph pag, Set<List<Node>> paths, Node previous, Node current, Node target, Set<Node> condition, Set<Node> conditionClosure, List<Node> history) {
        if (history.contains(current)) {
            return;
        }
        if (current.equals(target)) {
            history.add(current);
            paths.add(history);
            return;
        }
        List<Node> adjacencies = pag.getAdjacentNodes(current);
        for (Node adj : adjacencies) {
            boolean pass;
            if (previous == null) {
                ArrayList<Node> h = new ArrayList<Node>(history);
                h.add(current);
                PossibleDConnectingPath.findPaths(pag, paths, current, adj, target, condition, conditionClosure, h);
                continue;
            }
            boolean isConditionClosure = conditionClosure.contains(current);
            boolean isCondition = condition.contains(current);
            if (pag.isDefCollider(previous, current, adj)) {
                pass = isConditionClosure;
            } else {
                boolean bl = pass = !isCondition || !pag.underlines().isUnderlineTriple(previous, current, adj) && PossibleDConnectingPath.isOpen(pag, previous, current, adj);
            }
            if (!pass) continue;
            ArrayList<Node> h = new ArrayList<Node>(history);
            h.add(current);
            PossibleDConnectingPath.findPaths(pag, paths, current, adj, target, condition, conditionClosure, h);
        }
    }

    private static void findPathsOfLength(Graph pag, Set<List<Node>> paths, Node previous, Node current, Node target, Set<Node> condition, Set<Node> conditionClosure, List<Node> history, Integer length) {
        if (history.size() > length) {
            return;
        }
        if (history.contains(current)) {
            return;
        }
        if (current.equals(target) && history.size() == length.intValue()) {
            history.add(current);
            paths.add(history);
            return;
        }
        List<Node> adjacencies = pag.getAdjacentNodes(current);
        for (Node adj : adjacencies) {
            boolean pass;
            if (previous == null) {
                ArrayList<Node> h = new ArrayList<Node>(history);
                h.add(current);
                PossibleDConnectingPath.findPathsOfLength(pag, paths, current, adj, target, condition, conditionClosure, h, length);
                continue;
            }
            boolean isConditionClosure = conditionClosure.contains(current);
            boolean isCondition = condition.contains(current);
            if (pag.isDefCollider(previous, current, adj)) {
                pass = isConditionClosure;
            } else {
                boolean bl = pass = !isCondition || !pag.underlines().isUnderlineTriple(previous, current, adj) && PossibleDConnectingPath.isOpen(pag, previous, current, adj);
            }
            if (!pass) continue;
            ArrayList<Node> h = new ArrayList<Node>(history);
            h.add(current);
            PossibleDConnectingPath.findPathsOfLength(pag, paths, current, adj, target, condition, conditionClosure, h, length);
        }
    }

    private static boolean isOpen(Graph pag, Node x, Node y, Node z) {
        Edge edge = pag.getEdge(x, y);
        if (edge.getEndpoint1() != Endpoint.CIRCLE || edge.getEndpoint2() != Endpoint.CIRCLE) {
            return false;
        }
        edge = pag.getEdge(y, z);
        return edge.getEndpoint1() == Endpoint.CIRCLE && edge.getEndpoint2() == Endpoint.CIRCLE;
    }
}

