/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class PossibleDsepFci {
    private final Graph graph;
    private final IndependenceTest test;
    private final SepsetMap sepset;
    private int depth = -1;
    private Knowledge knowledge = new Knowledge();
    private int maxReachablePathLength = -1;

    public PossibleDsepFci(Graph graph, IndependenceTest test) {
        if (graph == null) {
            throw new NullPointerException("null GaSearchGraph passed in PossibleDSepSearch constructor!");
        }
        if (test == null) {
            throw new NullPointerException("null IndependenceChecker passed in PossibleDSepSearch constructor!");
        }
        this.graph = graph;
        this.test = test;
        this.sepset = new SepsetMap();
        this.setMaxPathLength(this.maxReachablePathLength);
    }

    public SepsetMap search() {
        for (Edge edge : new ArrayList<Edge>(this.graph.getEdges())) {
            Node y;
            Node x = edge.getNode1();
            List<Node> condSet = this.getSepset(this.test, x, y = edge.getNode2());
            if (condSet == null) continue;
            for (Node n : condSet) {
                if (this.graph.getAdjacentNodes(n).contains(x) || this.graph.getAdjacentNodes(n).contains(y)) continue;
                System.out.println("Not adjacent");
            }
            this.graph.removeEdge(x, y);
            this.sepset.set(x, y, condSet);
            System.out.println("Removed " + x + "--- " + y + " sepset = " + condSet);
        }
        return this.sepset;
    }

    public List<Node> getSepset(IndependenceTest test, Node node1, Node node2) {
        List<Node> condSet = this.getCondSet(test, node1, node2, this.maxReachablePathLength);
        if (this.sepset == null) {
            condSet = this.getCondSet(test, node2, node1, this.maxReachablePathLength);
        }
        return condSet;
    }

    private List<Node> getCondSet(IndependenceTest test, Node node1, Node node2, int maxPathLength) {
        List<Node> possibleDsepSet = this.getPossibleDsep(node1, node2, maxPathLength);
        ArrayList<Node> possibleDsep = new ArrayList<Node>(possibleDsepSet);
        boolean noEdgeRequired = this.getKnowledge().noEdgeRequired(node1.getName(), node2.getName());
        List<Node> possParents = this.possibleParents(node1, possibleDsep, this.getKnowledge());
        int _depth = this.getDepth() == -1 ? 1000 : this.getDepth();
        for (int d = 0; d <= FastMath.min(_depth, possParents.size()); ++d) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(possParents.size(), d);
            while ((choice = cg.next()) != null) {
                List<Node> condSet = GraphUtils.asList(choice, possParents);
                boolean independent = test.checkIndependence(node1, node2, condSet).independent();
                if (!independent || !noEdgeRequired) continue;
                return condSet;
            }
        }
        return null;
    }

    private List<Node> possibleParents(Node x, List<Node> nodes, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : nodes) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String _z, String _x, Knowledge bk) {
        return !bk.isForbidden(_z, _x) && !bk.isRequired(_x, _z);
    }

    private List<Node> getPossibleDsep(Node node1, Node node2, int maxPathLength) {
        List<Node> dsep = this.graph.paths().possibleDsep(node1, node2, maxPathLength);
        dsep.remove(node1);
        dsep.remove(node2);
        return dsep;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setMaxPathLength(int maxReachablePathLength) {
        if (maxReachablePathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxReachablePathLength);
        }
        this.maxReachablePathLength = maxReachablePathLength == -1 ? Integer.MAX_VALUE : maxReachablePathLength;
    }
}

