/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import edu.pitt.dbmi.algo.bayesian.constraint.inference.BCInference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProbabilisticMAPIndependence
implements IndependenceTest {
    private final BCInference bci;
    private final DataSet data;
    private final List<Node> nodes;
    private final Map<Node, Integer> indices;
    private final Map<IndependenceFact, Double> H;
    private double posterior;
    private boolean verbose;

    public ProbabilisticMAPIndependence(DataSet dataSet) {
        int i;
        this.data = dataSet;
        int[] counts = new int[dataSet.getNumColumns() + 2];
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            counts[j + 1] = ((DiscreteVariable)dataSet.getVariable(j)).getNumCategories();
        }
        if (!dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Not a discrete data set.");
        }
        int[][] cases = new int[dataSet.getNumRows() + 1][dataSet.getNumColumns() + 2];
        for (i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                cases[i + 1][j + 1] = dataSet.getInt(i, j) + 1;
            }
        }
        this.bci = new BCInference(cases, counts);
        this.nodes = dataSet.getVariables();
        this.indices = new HashMap<Node, Integer>();
        for (i = 0; i < this.nodes.size(); ++i) {
            this.indices.put(this.nodes.get(i), i);
        }
        this.H = new HashMap<IndependenceFact, Double>();
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, List<Node> z) {
        Node[] nodes = new Node[z.size()];
        for (int i = 0; i < z.size(); ++i) {
            nodes[i] = z.get(i);
        }
        return this.checkIndependence(x, y, nodes);
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Node ... z) {
        boolean independent;
        double p;
        double pInd = this.probConstraint(BCInference.OP.independent, x, y, z);
        this.posterior = p = this.probOp(pInd);
        boolean bl = independent = p > 0.5;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(SearchLogUtils.independenceFactMsg(x, y, Arrays.asList(z), p));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, pInd);
    }

    public double probConstraint(BCInference.OP op, Node x, Node y, Node[] z) {
        int _x = this.indices.get(x) + 1;
        int _y = this.indices.get(y) + 1;
        int[] _z = new int[z.length + 1];
        _z[0] = z.length;
        for (int i = 0; i < z.length; ++i) {
            _z[i + 1] = this.indices.get(z[i]) + 1;
        }
        return this.bci.probConstraint(op, _x, _y, _z);
    }

    @Override
    public List<Node> getVariables() {
        return this.nodes;
    }

    @Override
    public Node getVariable(String name) {
        for (Node node : this.nodes) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> getVariableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : this.nodes) {
            names.add(node.getName());
        }
        return names;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataModel getData() {
        return this.data;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return null;
    }

    @Override
    public List<DataSet> getDataSets() {
        return null;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    @Override
    public List<Matrix> getCovMatrices() {
        return null;
    }

    @Override
    public double getScore() {
        return this.posterior;
    }

    public Map<IndependenceFact, Double> getH() {
        return new HashMap<IndependenceFact, Double>(this.H);
    }

    private double probOp(double pInd) {
        double probOp = pInd;
        return probOp;
    }

    public double getPosterior() {
        return this.posterior;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

